/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.client.screens;

import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.Owo;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import io.wispforest.owo.util.pond.OwoScreenHandlerExtension;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ScreenInternals {
    public static final ResourceLocation SYNC_PROPERTIES = ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"sync_screen_handler_properties");

    public static void init(PayloadRegistrar registrar) {
        StreamCodec localPacketCodec = CodecUtils.toPacketCodec(LocalPacket.ENDEC);
        IPayloadHandler handler = (payload, context) -> context.enqueueWork(() -> {
            AbstractContainerMenu screenHandler = context.player().containerMenu;
            if (screenHandler == null) {
                Owo.LOGGER.error("Received local packet for null ScreenHandler");
                return;
            }
            ((OwoScreenHandlerExtension)screenHandler).owo$handlePacket((LocalPacket)payload, context.player().level().isClientSide());
        });
        registrar.playBidirectional(LocalPacket.ID, localPacketCodec, handler, handler);
        registrar.playToClient(SyncPropertiesPacket.ID, CodecUtils.toPacketCodec(SyncPropertiesPacket.ENDEC), (payload, context) -> context.enqueueWork(() -> {
            AbstractContainerMenu screenHandler = context.player().containerMenu;
            if (screenHandler == null) {
                Owo.LOGGER.error("Received sync properties packet for null ScreenHandler");
                return;
            }
            ((OwoScreenHandlerExtension)screenHandler).owo$readPropertySync((SyncPropertiesPacket)payload);
        }));
    }

    public record LocalPacket(int packetId, FriendlyByteBuf payload) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<LocalPacket> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"local_packet"));
        public static final Endec<LocalPacket> ENDEC = StructEndecBuilder.of((StructField)Endec.VAR_INT.fieldOf("packetId", LocalPacket::packetId), (StructField)MinecraftEndecs.PACKET_BYTE_BUF.fieldOf("payload", LocalPacket::payload), LocalPacket::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }

    public record SyncPropertiesPacket(FriendlyByteBuf payload) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SyncPropertiesPacket> ID = new CustomPacketPayload.Type(SYNC_PROPERTIES);
        public static final Endec<SyncPropertiesPacket> ENDEC = StructEndecBuilder.of((StructField)MinecraftEndecs.PACKET_BYTE_BUF.fieldOf("payload", SyncPropertiesPacket::payload), SyncPropertiesPacket::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }
}

