/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.compat.rei;

import io.wispforest.owo.itemgroup.OwoItemGroup;
import io.wispforest.owo.mixin.itemgroup.CreativeInventoryScreenAccessor;
import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.util.pond.OwoCreativeInventoryScreenExtensions;
import java.util.ArrayList;
import java.util.Collections;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.OverlayRendererProvider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.forge.REIPluginClient;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.world.item.CreativeModeTab;
import org.jetbrains.annotations.Nullable;

@REIPluginClient
public class OwoReiPlugin
implements REIClientPlugin {
    @Nullable
    private static OverlayRendererProvider.Sink renderSink = null;

    public void registerExclusionZones(ExclusionZones zones) {
        zones.register(CreativeModeInventoryScreen.class, screen -> {
            CreativeModeTab group = CreativeInventoryScreenAccessor.owo$getSelectedTab();
            if (!(group instanceof OwoItemGroup)) {
                return Collections.emptySet();
            }
            OwoItemGroup owoGroup = (OwoItemGroup)group;
            if (owoGroup.getButtons().isEmpty()) {
                return Collections.emptySet();
            }
            int x = ((OwoCreativeInventoryScreenExtensions)screen).owo$getRootX();
            int y = ((OwoCreativeInventoryScreenExtensions)screen).owo$getRootY();
            int stackHeight = owoGroup.getButtonStackHeight();
            y -= 13 * (stackHeight - 4);
            ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
            for (int i = 0; i < owoGroup.getButtons().size(); ++i) {
                int xOffset = x + 198 + i / stackHeight * 26;
                int yOffset = y + 10 + i % stackHeight * 30;
                rectangles.add(new Rectangle(xOffset, yOffset, 24, 24));
            }
            return rectangles;
        });
        zones.register(BaseOwoHandledScreen.class, screen -> screen.componentsForExclusionAreas().map(rect -> new Rectangle(rect.x(), rect.y(), rect.width(), rect.height())).toList());
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerDecider(new OverlayDecider(this){

            public <R extends Screen> boolean isHandingScreen(Class<R> screen) {
                return BaseOwoHandledScreen.class.isAssignableFrom(screen);
            }

            public OverlayRendererProvider getRendererProvider() {
                return new OverlayRendererProvider(this){

                    public void onApplied(OverlayRendererProvider.Sink sink) {
                        renderSink = sink;
                    }

                    public void onRemoved() {
                        renderSink = null;
                    }
                };
            }
        });
    }
}

