/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.config;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonGrammar;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.JsonPrimitive;
import blue.endless.jankson.api.DeserializationException;
import blue.endless.jankson.api.Marshaller;
import blue.endless.jankson.api.SyntaxError;
import blue.endless.jankson.impl.POJODeserializer;
import blue.endless.jankson.magic.TypeMagic;
import io.wispforest.endec.Endec;
import io.wispforest.endec.format.jankson.JanksonDeserializer;
import io.wispforest.endec.format.jankson.JanksonSerializer;
import io.wispforest.endec.impl.ReflectiveEndecBuilder;
import io.wispforest.owo.Owo;
import io.wispforest.owo.config.ConfigSynchronizer;
import io.wispforest.owo.config.Option;
import io.wispforest.owo.config.annotation.Config;
import io.wispforest.owo.config.annotation.Modmenu;
import io.wispforest.owo.config.annotation.Nest;
import io.wispforest.owo.config.annotation.PredicateConstraint;
import io.wispforest.owo.config.annotation.RangeConstraint;
import io.wispforest.owo.config.annotation.RegexConstraint;
import io.wispforest.owo.config.annotation.Sync;
import io.wispforest.owo.config.ui.ConfigScreen;
import io.wispforest.owo.config.ui.ConfigScreenProviders;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.util.NumberReflection;
import io.wispforest.owo.util.Observable;
import io.wispforest.owo.util.ReflectionUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigWrapper<C> {
    private static final Map<String, Class<?>> KNOWN_CONFIG_CLASSES = new HashMap();
    protected final String name;
    protected final C instance;
    protected boolean loading = false;
    protected final Jankson jankson;
    protected final Map<Option.Key, Option> options = new LinkedHashMap<Option.Key, Option>();
    protected final Map<Option.Key, Option> optionsView = Collections.unmodifiableMap(this.options);
    protected final ReflectiveEndecBuilder builder = MinecraftEndecs.addDefaults(new ReflectiveEndecBuilder());

    @Deprecated
    protected ConfigWrapper(Class<C> clazz, Consumer<Jankson.Builder> janksonBuilder) {
        this(clazz, (SerializationBuilder serializationBuilder) -> janksonBuilder.accept(serializationBuilder.janksonBuilder()));
    }

    protected ConfigWrapper(Class<C> clazz) {
        this(clazz, (SerializationBuilder builder) -> {});
    }

    protected ConfigWrapper(Class<C> clazz, BuilderConsumer consumer) {
        ReflectionUtils.requireZeroArgsConstructor(clazz, s -> "Config model class " + s + " must provide a zero-args constructor");
        this.instance = ReflectionUtils.tryInstantiateWithNoArgs(clazz);
        Jankson.Builder janksonBuilder = Jankson.builder();
        SerializationBuilder builder = new SerializationBuilder(janksonBuilder, this.builder);
        builder.janksonBuilder().registerSerializer(ResourceLocation.class, (identifier, marshaller) -> new JsonPrimitive((Object)identifier.toString())).registerDeserializer(JsonPrimitive.class, ResourceLocation.class, (primitive, m) -> ResourceLocation.tryParse((String)primitive.asString()));
        builder.addEndec(Color.class, Color.RGBA_HEX_ENDEC);
        consumer.build(builder);
        this.jankson = janksonBuilder.build();
        Config configAnnotation = clazz.getAnnotation(Config.class);
        this.name = configAnnotation.name();
        if (KNOWN_CONFIG_CLASSES.put(this.name, this.getClass()) != null) {
            throw new IllegalStateException("Config name '" + this.name + "' is already taken by an instance of class '" + KNOWN_CONFIG_CLASSES.get(this.name).getName() + "'");
        }
        if (FMLLoader.getCurrent().getDist() == Dist.CLIENT && clazz.isAnnotationPresent(Modmenu.class)) {
            Modmenu modmenuAnnotation = clazz.getAnnotation(Modmenu.class);
            ConfigScreenProviders.register(modmenuAnnotation.modId(), screen -> ConfigScreen.createWithCustomModel(ResourceLocation.parse((String)modmenuAnnotation.uiModelId()), this, screen));
        }
        try {
            this.initializeOptions(configAnnotation.saveOnModification());
            for (Option option : this.options.values()) {
                if (option.syncMode().isNone()) continue;
                ConfigSynchronizer.register(this);
                break;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("Failed to initialize config " + this.name, e);
        }
    }

    public void save() {
        if (this.loading) {
            return;
        }
        try {
            this.fileLocation().getParent().toFile().mkdirs();
            Files.writeString(this.fileLocation(), (CharSequence)this.jankson.toJson(this.instance).toJson(JsonGrammar.JANKSON), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            Owo.LOGGER.warn("Could not save config {}", (Object)this.name, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (!Files.exists(this.fileLocation(), new LinkOption[0])) {
            this.save();
            return;
        }
        try {
            this.loading = true;
            JsonObject configObject = this.jankson.load(Files.readString(this.fileLocation(), StandardCharsets.UTF_8));
            for (Option option : this.options.values()) {
                Object newValue;
                Class clazz = option.clazz();
                JsonElement element = (JsonElement)configObject.recursiveGet(JsonElement.class, option.key().asString());
                if (element == null) {
                    option.set(option.defaultValue());
                    continue;
                }
                if (Map.class.isAssignableFrom(clazz)) {
                    Field field = option.backingField().field();
                    newValue = TypeMagic.createAndCast(clazz);
                    POJODeserializer.unpackMap((Map)((Map)newValue), ReflectionUtils.getTypeArgument(field.getGenericType(), 0), ReflectionUtils.getTypeArgument(field.getGenericType(), 1), (JsonElement)element, (Marshaller)this.jankson.getMarshaller());
                } else if (List.class.isAssignableFrom(clazz) || Set.class.isAssignableFrom(clazz)) {
                    newValue = TypeMagic.createAndCast(clazz);
                    POJODeserializer.unpackCollection((Collection)((Collection)newValue), ReflectionUtils.getTypeArgument(option.backingField().field().getGenericType(), 0), (JsonElement)element, (Marshaller)this.jankson.getMarshaller());
                } else {
                    newValue = configObject.getMarshaller().marshall(clazz, element);
                }
                if (!option.verifyConstraint(newValue)) continue;
                option.set(newValue == null ? option.defaultValue() : newValue);
            }
        }
        catch (DeserializationException | SyntaxError | IOException e) {
            Owo.LOGGER.warn("Could not load config {}", (Object)this.name, (Object)e);
        }
        finally {
            this.loading = false;
        }
    }

    @Nullable
    public Field fieldForKey(Option.Key key) {
        try {
            ArrayList<String> path = new ArrayList<String>(List.of(key.path()));
            Class<?> clazz = this.instance.getClass();
            while (path.size() > 1) {
                clazz = clazz.getDeclaredField(path.remove(0)).getType();
            }
            return clazz.getField(path.get(0));
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public String name() {
        return this.name;
    }

    public Path fileLocation() {
        return FMLLoader.getCurrent().getGameDir().resolve(FMLPaths.CONFIGDIR.relative()).resolve(this.name + ".json5");
    }

    @Nullable
    public <T> Option<T> optionForKey(Option.Key key) {
        return this.options.get(key);
    }

    public Map<Option.Key, Option<?>> allOptions() {
        return this.optionsView;
    }

    public void forEachOption(Consumer<Option<?>> action) {
        for (Option option : this.options.values()) {
            action.accept(option);
        }
    }

    private void initializeOptions(boolean hookSave) throws IllegalAccessException, NoSuchMethodException {
        LinkedHashMap<Option.Key, Option.BoundField<Object>> fields = new LinkedHashMap<Option.Key, Option.BoundField<Object>>();
        this.collectFieldValues(Option.Key.ROOT, this.instance, fields);
        Option.SyncMode instanceSyncMode = this.instance.getClass().isAnnotationPresent(Sync.class) ? this.instance.getClass().getAnnotation(Sync.class).value() : Option.SyncMode.NONE;
        for (Map.Entry<Option.Key, Option.BoundField<Object>> entry : fields.entrySet()) {
            Annotation annotation;
            Option.Key key = entry.getKey();
            Option.BoundField<Object> boundField = entry.getValue();
            Field field = boundField.field();
            Class<?> fieldType = field.getType();
            Constraint constraint = null;
            if (field.isAnnotationPresent(RangeConstraint.class)) {
                annotation = field.getAnnotation(RangeConstraint.class);
                if (NumberReflection.isNumberType(fieldType)) {
                    Predicate<Object> predicate = fieldType == Long.TYPE || fieldType == Long.class ? arg_0 -> ConfigWrapper.lambda$initializeOptions$6((RangeConstraint)annotation, arg_0) : arg_0 -> ConfigWrapper.lambda$initializeOptions$7((RangeConstraint)annotation, arg_0);
                    constraint = new Constraint("Range from " + annotation.min() + " to " + annotation.max(), predicate);
                } else {
                    throw new IllegalStateException("@RangeConstraint can only be applied to numeric fields");
                }
            }
            if (field.isAnnotationPresent(RegexConstraint.class)) {
                annotation = field.getAnnotation(RegexConstraint.class);
                if (CharSequence.class.isAssignableFrom(fieldType)) {
                    Pattern pattern = Pattern.compile(annotation.value());
                    constraint = new Constraint("Regex " + annotation.value(), o -> o != null && pattern.matcher((CharSequence)o).matches());
                } else {
                    throw new IllegalStateException("@RegexConstraint can only be applied to fields with a string representation");
                }
            }
            if (field.isAnnotationPresent(PredicateConstraint.class)) {
                annotation = field.getAnnotation(PredicateConstraint.class);
                Method method = boundField.owner().getClass().getMethod(annotation.value(), fieldType);
                if (method.getReturnType() != Boolean.TYPE) {
                    throw new NoSuchMethodException("Return type of predicate implementation '" + annotation.value() + "' must be 'boolean'");
                }
                if (!Modifier.isStatic(method.getModifiers())) {
                    throw new IllegalStateException("Predicate implementation '" + annotation.value() + "' must be static");
                }
                MethodHandle handle = MethodHandles.publicLookup().unreflect(method);
                constraint = new Constraint("Predicate method " + annotation.value(), o -> this.invokePredicate(handle, o));
            }
            Object defaultValue = boundField.getValue();
            Observable<Object> observable = Observable.of(defaultValue);
            if (hookSave) {
                observable.observe(o -> this.save());
            }
            Option.SyncMode syncMode = instanceSyncMode;
            if (field.isAnnotationPresent(Sync.class)) {
                syncMode = field.getAnnotation(Sync.class).value();
            } else {
                Option.Key parentKey = key.parent();
                while (!parentKey.isRoot()) {
                    Field parentField = this.fieldForKey(parentKey);
                    if (parentField.isAnnotationPresent(Sync.class)) {
                        syncMode = parentField.getAnnotation(Sync.class).value();
                    }
                    parentKey = parentKey.parent();
                }
            }
            this.options.put(key, new Option<Object>(this.name, key, defaultValue, observable, boundField, constraint, syncMode, this.builder));
        }
    }

    private void collectFieldValues(Option.Key parent, Object instance, Map<Option.Key, Option.BoundField<Object>> fields) throws IllegalAccessException {
        for (Field field : instance.getClass().getDeclaredFields()) {
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            if (field.isAnnotationPresent(Nest.class)) {
                Object fieldValue = field.get(instance);
                if (fieldValue != null) {
                    this.collectFieldValues(parent.child(field.getName()), fieldValue, fields);
                    continue;
                }
                throw new IllegalStateException("Nested config option containers must never be null");
            }
            fields.put(parent.child(field.getName()), new Option.BoundField(instance, field));
        }
    }

    private boolean invokePredicate(MethodHandle predicate, Object value) {
        try {
            return predicate.invoke(value);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not invoke predicate", e);
        }
    }

    private static /* synthetic */ boolean lambda$initializeOptions$7(RangeConstraint annotation, Object o) {
        return o != null && ((Number)o).doubleValue() >= annotation.min() && ((Number)o).doubleValue() <= annotation.max();
    }

    private static /* synthetic */ boolean lambda$initializeOptions$6(RangeConstraint annotation, Object o) {
        return o != null && (double)((Long)o).longValue() >= annotation.min() && (double)((Long)o).longValue() <= annotation.max();
    }

    public static interface BuilderConsumer {
        public void build(SerializationBuilder var1);
    }

    public record SerializationBuilder(Jankson.Builder janksonBuilder, ReflectiveEndecBuilder endecBuilder) {
        public <T> SerializationBuilder addEndec(Class<T> clazz, Endec<T> endec) {
            this.endecBuilder().register(endec, clazz);
            this.janksonBuilder().registerSerializer(clazz, (t, marshaller) -> (JsonElement)endec.encodeFully(JanksonSerializer::of, t)).registerDeserializer(JsonElement.class, clazz, (element, marshaller) -> endec.decodeFully(JanksonDeserializer::of, element));
            return this;
        }
    }

    public record Constraint(String formatted, Predicate predicate) {
        public boolean test(Object value) {
            return this.predicate.test(value);
        }
    }
}

