/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.endec;

import com.mojang.datafixers.util.Function3;
import io.netty.buffer.Unpooled;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationAttributes;
import io.wispforest.endec.impl.ReflectiveEndecBuilder;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.CodecUtils;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public final class MinecraftEndecs {
    public static final Endec<FriendlyByteBuf> PACKET_BYTE_BUF = Endec.BYTES.xmap(bytes -> {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.writeBytes(bytes);
        return buffer;
    }, buffer -> {
        int rinx = buffer.readerIndex();
        byte[] bytes = new byte[buffer.readableBytes()];
        buffer.readBytes(bytes);
        buffer.readerIndex(rinx);
        return bytes;
    });
    public static final Endec<ResourceLocation> IDENTIFIER = Endec.STRING.xmap(ResourceLocation::parse, ResourceLocation::toString);
    public static final Endec<ItemStack> ITEM_STACK = CodecUtils.toEndecWithRegistries(ItemStack.OPTIONAL_CODEC, ItemStack.OPTIONAL_STREAM_CODEC);
    public static final Endec<Component> TEXT = CodecUtils.toEndec(ComponentSerialization.CODEC, ComponentSerialization.TRUSTED_CONTEXT_FREE_STREAM_CODEC);
    public static final Endec<Vec3i> VEC3I = MinecraftEndecs.vectorEndec("Vec3i", Endec.INT, Vec3i::new, Vec3i::getX, Vec3i::getY, Vec3i::getZ);
    public static final Endec<Vec3> VEC3D = MinecraftEndecs.vectorEndec("Vec3d", Endec.DOUBLE, Vec3::new, Vec3::x, Vec3::y, Vec3::z);
    public static final Endec<Vector3f> VECTOR3F = MinecraftEndecs.vectorEndec("Vector3f", Endec.FLOAT, Vector3f::new, Vector3f::x, Vector3f::y, Vector3f::z);
    public static final Endec<BlockPos> BLOCK_POS = Endec.ifAttr((SerializationAttribute)SerializationAttributes.HUMAN_READABLE, MinecraftEndecs.vectorEndec("BlockPos", Endec.INT, BlockPos::new, Vec3i::getX, Vec3i::getY, Vec3i::getZ)).orElse(Endec.LONG.xmap(BlockPos::of, BlockPos::asLong));
    public static final Endec<ChunkPos> CHUNK_POS = Endec.ifAttr((SerializationAttribute)SerializationAttributes.HUMAN_READABLE, (Endec)Endec.INT.listOf().validate(ints -> {
        if (ints.size() != 2) {
            throw new IllegalStateException("ChunkPos array must have two elements");
        }
    }).xmap(ints -> new ChunkPos(((Integer)ints.get(0)).intValue(), ((Integer)ints.get(1)).intValue()), chunkPos -> List.of(Integer.valueOf(chunkPos.x), Integer.valueOf(chunkPos.z)))).orElse(Endec.LONG.xmap(ChunkPos::new, ChunkPos::toLong));
    public static final Endec<BlockHitResult> BLOCK_HIT_RESULT = StructEndecBuilder.of((StructField)VEC3D.fieldOf("pos", HitResult::getLocation), (StructField)Endec.forEnum(Direction.class).fieldOf("side", BlockHitResult::getDirection), (StructField)BLOCK_POS.fieldOf("block_pos", BlockHitResult::getBlockPos), (StructField)Endec.BOOLEAN.fieldOf("inside_block", BlockHitResult::isInside), (StructField)Endec.BOOLEAN.fieldOf("missed", $ -> $.getType() == HitResult.Type.MISS), (pos, side, blockPos, insideBlock, missed) -> missed == false ? new BlockHitResult(pos, side, blockPos, insideBlock.booleanValue()) : BlockHitResult.miss((Vec3)pos, (Direction)side, (BlockPos)blockPos));

    private MinecraftEndecs() {
    }

    public static ReflectiveEndecBuilder addDefaults(ReflectiveEndecBuilder builder) {
        builder.register(PACKET_BYTE_BUF, FriendlyByteBuf.class);
        builder.register(IDENTIFIER, ResourceLocation.class).register(ITEM_STACK, ItemStack.class).register(TEXT, Component.class);
        builder.register(VEC3I, Vec3i.class).register(VEC3D, Vec3.class).register(VECTOR3F, Vector3f.class);
        builder.register(BLOCK_POS, BlockPos.class).register(CHUNK_POS, ChunkPos.class);
        builder.register(BLOCK_HIT_RESULT, BlockHitResult.class);
        return builder;
    }

    public static <T> Endec<T> ofRegistry(Registry<T> registry) {
        return IDENTIFIER.xmap(arg_0 -> registry.getValue(arg_0), arg_0 -> registry.getKey(arg_0));
    }

    public static <T> Endec<TagKey<T>> unprefixedTagKey(ResourceKey<? extends Registry<T>> registry) {
        return IDENTIFIER.xmap(id -> TagKey.create((ResourceKey)registry, (ResourceLocation)id), TagKey::location);
    }

    public static <T> Endec<TagKey<T>> prefixedTagKey(ResourceKey<? extends Registry<T>> registry) {
        return Endec.STRING.xmap(s -> TagKey.create((ResourceKey)registry, (ResourceLocation)ResourceLocation.parse((String)s.substring(1))), tag -> "#" + String.valueOf(tag.location()));
    }

    private static <C, V> Endec<V> vectorEndec(String name, Endec<C> componentEndec, Function3<C, C, C, V> constructor, Function<V, C> xGetter, Function<V, C> yGetter, Function<V, C> zGetter) {
        return componentEndec.listOf().validate(ints -> {
            if (ints.size() != 3) {
                throw new IllegalStateException(name + " array must have three elements");
            }
        }).xmap(components -> constructor.apply(components.get(0), components.get(1), components.get(2)), vector -> List.of(xGetter.apply(vector), yGetter.apply(vector), zGetter.apply(vector)));
    }
}

