/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.format.nbt;

import com.google.common.collect.MapMaker;
import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SelfDescribedDeserializer;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;
import io.wispforest.endec.util.RecursiveDeserializer;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class NbtDeserializer
extends RecursiveDeserializer<Tag>
implements SelfDescribedDeserializer<Tag> {
    private final Set<Tag> encodedOptionals = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());

    protected NbtDeserializer(Tag element) {
        super((Object)element);
    }

    public static NbtDeserializer of(Tag element) {
        return new NbtDeserializer(element);
    }

    private <N extends Tag> N getAs(Tag element, Class<N> clazz) {
        if (clazz.isInstance(element)) {
            return (N)((Tag)clazz.cast(element));
        }
        throw new IllegalStateException("Expected a " + clazz.getSimpleName() + ", found a " + element.getClass().getSimpleName());
    }

    public byte readByte(SerializationContext ctx) {
        return this.getAs((Tag)this.getValue(), ByteTag.class).byteValue();
    }

    public short readShort(SerializationContext ctx) {
        return this.getAs((Tag)this.getValue(), ShortTag.class).shortValue();
    }

    public int readInt(SerializationContext ctx) {
        return this.getAs((Tag)this.getValue(), IntTag.class).intValue();
    }

    public long readLong(SerializationContext ctx) {
        return this.getAs((Tag)this.getValue(), LongTag.class).longValue();
    }

    public float readFloat(SerializationContext ctx) {
        return this.getAs((Tag)this.getValue(), FloatTag.class).floatValue();
    }

    public double readDouble(SerializationContext ctx) {
        return this.getAs((Tag)this.getValue(), DoubleTag.class).doubleValue();
    }

    public int readVarInt(SerializationContext ctx) {
        return this.getAs((Tag)this.getValue(), NumericTag.class).intValue();
    }

    public long readVarLong(SerializationContext ctx) {
        return this.getAs((Tag)this.getValue(), NumericTag.class).longValue();
    }

    public boolean readBoolean(SerializationContext ctx) {
        return this.getAs((Tag)this.getValue(), ByteTag.class).byteValue() != 0;
    }

    public String readString(SerializationContext ctx) {
        return (String)this.getAs((Tag)this.getValue(), StringTag.class).asString().get();
    }

    public byte[] readBytes(SerializationContext ctx) {
        return this.getAs((Tag)this.getValue(), ByteArrayTag.class).getAsByteArray();
    }

    public <V> Optional<V> readOptional(SerializationContext ctx, Endec<V> endec) {
        Tag value = (Tag)this.getValue();
        if (this.encodedOptionals.contains(value)) {
            return Optional.of(endec.decode(ctx, (Deserializer)this));
        }
        Deserializer.Struct struct = this.struct();
        return (Boolean)struct.field("present", ctx, Endec.BOOLEAN) != false ? Optional.of(struct.field("value", ctx, endec)) : Optional.empty();
    }

    public <E> Deserializer.Sequence<E> sequence(SerializationContext ctx, Endec<E> elementEndec) {
        CollectionTag list = this.getAs((Tag)this.getValue(), CollectionTag.class);
        return new Sequence<E>(ctx, elementEndec, (Iterable<Tag>)list, list.size());
    }

    public <V> Deserializer.Map<V> map(SerializationContext ctx, Endec<V> valueEndec) {
        return new Map<V>(ctx, valueEndec, this.getAs((Tag)this.getValue(), CompoundTag.class));
    }

    public Deserializer.Struct struct() {
        return new Struct(this.getAs((Tag)this.getValue(), CompoundTag.class));
    }

    public <S> void readAny(SerializationContext ctx, Serializer<S> visitor) {
        this.decodeValue(ctx, visitor, (Tag)this.getValue());
    }

    private <S> void decodeValue(SerializationContext ctx, Serializer<S> visitor, Tag value) {
        switch (value.getId()) {
            case 1: {
                visitor.writeByte(ctx, ((ByteTag)value).byteValue());
                break;
            }
            case 2: {
                visitor.writeShort(ctx, ((ShortTag)value).shortValue());
                break;
            }
            case 3: {
                visitor.writeInt(ctx, ((IntTag)value).intValue());
                break;
            }
            case 4: {
                visitor.writeLong(ctx, ((LongTag)value).longValue());
                break;
            }
            case 5: {
                visitor.writeFloat(ctx, ((FloatTag)value).floatValue());
                break;
            }
            case 6: {
                visitor.writeDouble(ctx, ((DoubleTag)value).doubleValue());
                break;
            }
            case 8: {
                visitor.writeString(ctx, (String)value.asString().get());
                break;
            }
            case 7: {
                visitor.writeBytes(ctx, ((ByteArrayTag)value).getAsByteArray());
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                CollectionTag list = (CollectionTag)value;
                try (Serializer.Sequence sequence = visitor.sequence(ctx, Endec.of(this::decodeValue, (ctx1, deserializer) -> null), list.size());){
                    list.forEach(arg_0 -> ((Serializer.Sequence)sequence).element(arg_0));
                    break;
                }
            }
            case 10: {
                CompoundTag compound = (CompoundTag)value;
                try (Serializer.Map map = visitor.map(ctx, Endec.of(this::decodeValue, (ctx1, deserializer) -> null), compound.size());){
                    for (String key : compound.keySet()) {
                        map.entry(key, (Object)compound.get(key));
                    }
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Non-standard, unrecognized NbtElement implementation cannot be decoded");
            }
        }
    }

    private class Sequence<V>
    implements Deserializer.Sequence<V> {
        private final SerializationContext ctx;
        private final Endec<V> valueEndec;
        private final Iterator<Tag> elements;
        private final int size;

        private Sequence(SerializationContext ctx, Endec<V> valueEndec, Iterable<Tag> elements, int size) {
            this.ctx = ctx;
            this.valueEndec = valueEndec;
            this.elements = elements.iterator();
            this.size = size;
        }

        public int estimatedSize() {
            return this.size;
        }

        public boolean hasNext() {
            return this.elements.hasNext();
        }

        public V next() {
            Tag value = this.elements.next();
            return (V)NbtDeserializer.this.frame(() -> value, () -> this.valueEndec.decode(this.ctx, (Deserializer)NbtDeserializer.this));
        }
    }

    private class Map<V>
    implements Deserializer.Map<V> {
        private final SerializationContext ctx;
        private final Endec<V> valueEndec;
        private final CompoundTag compound;
        private final Iterator<String> keys;
        private final int size;

        private Map(SerializationContext ctx, Endec<V> valueEndec, CompoundTag compound) {
            this.ctx = ctx;
            this.valueEndec = valueEndec;
            this.compound = compound;
            this.keys = compound.keySet().iterator();
            this.size = compound.size();
        }

        public int estimatedSize() {
            return this.size;
        }

        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public Map.Entry<String, V> next() {
            String key = this.keys.next();
            return (Map.Entry)NbtDeserializer.this.frame(() -> this.compound.get(key), () -> java.util.Map.entry(key, this.valueEndec.decode(this.ctx, (Deserializer)NbtDeserializer.this)));
        }
    }

    public class Struct
    implements Deserializer.Struct {
        private final CompoundTag compound;

        public Struct(CompoundTag compound) {
            this.compound = compound;
        }

        @Nullable
        public <F> F field(String name, SerializationContext ctx, Endec<F> endec, @Nullable Supplier<F> defaultValueFactory) {
            if (!this.compound.contains(name)) {
                if (defaultValueFactory == null) {
                    throw new IllegalStateException("Field '" + name + "' was missing from serialized data, but no default value was provided");
                }
                return defaultValueFactory.get();
            }
            Tag element = this.compound.get(name);
            if (defaultValueFactory != null) {
                NbtDeserializer.this.encodedOptionals.add(element);
            }
            return (F)NbtDeserializer.this.frame(() -> element, () -> endec.decode(ctx, (Deserializer)NbtDeserializer.this));
        }
    }
}

