/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.base;

import io.wispforest.owo.Owo;
import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.base.BaseUIModelScreen;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.parsing.ConfigureHotReloadScreen;
import io.wispforest.owo.ui.parsing.UIModel;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseUIModelHandledScreen<R extends ParentComponent, S extends AbstractContainerMenu>
extends BaseOwoHandledScreen<R, S> {
    protected final UIModel model;
    protected final Class<R> rootComponentClass;
    @Nullable
    protected final ResourceLocation modelId;

    protected BaseUIModelHandledScreen(S handler, Inventory inventory, Component title, Class<R> rootComponentClass, BaseUIModelScreen.DataSource source) {
        super(handler, inventory, title);
        ResourceLocation resourceLocation;
        UIModel providedModel = source.get();
        if (providedModel == null) {
            source.reportError();
            this.invalid = true;
        }
        this.rootComponentClass = rootComponentClass;
        this.model = providedModel;
        if (source instanceof BaseUIModelScreen.DataSource.AssetDataSource) {
            BaseUIModelScreen.DataSource.AssetDataSource assetSource = (BaseUIModelScreen.DataSource.AssetDataSource)source;
            resourceLocation = assetSource.assetPath();
        } else {
            resourceLocation = null;
        }
        this.modelId = resourceLocation;
    }

    protected BaseUIModelHandledScreen(S handler, Inventory inventory, Component title, Class<R> rootComponentClass, ResourceLocation modelId) {
        this(handler, inventory, title, rootComponentClass, BaseUIModelScreen.DataSource.asset(modelId));
    }

    @Override
    @NotNull
    protected OwoUIAdapter<R> createAdapter() {
        return this.model.createAdapter(this.rootComponentClass, (Screen)this);
    }

    @Override
    public boolean keyPressed(KeyEvent input) {
        if (Owo.DEBUG && this.modelId != null && input.key() == 294 && input.hasControlDown()) {
            this.minecraft.setScreen((Screen)new ConfigureHotReloadScreen(this.modelId, (Screen)this));
            return true;
        }
        return super.keyPressed(input);
    }
}

