/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.component;

import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.UISounds;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DropdownComponent
extends FlowLayout {
    protected static final ResourceLocation ICONS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"textures/gui/dropdown_icons.png");
    protected final FlowLayout entries;
    protected boolean closeWhenNotHovered = false;
    private static final Map<Screen, List<Consumer<MouseButtonEvent>>> componentHook = new HashMap<Screen, List<Consumer<MouseButtonEvent>>>();

    protected DropdownComponent(Sizing horizontalSizing) {
        super(Sizing.content(), Sizing.content(), FlowLayout.Algorithm.HORIZONTAL);
        this.entries = Containers.verticalFlow(horizontalSizing, Sizing.content());
        this.entries.padding(Insets.of(1));
        this.entries.allowOverflow(true);
        this.entries.surface(Surface.flat(-956301312).and(Surface.blur(3.0f, 5.0f)).and(Surface.outline(-15592942)));
        this.child(this.entries);
    }

    public static <R extends ParentComponent> DropdownComponent openContextMenu(Screen screen, R rootComponent, BiConsumer<R, DropdownComponent> mountFunction, double mouseX, double mouseY, Consumer<DropdownComponent> builder) {
        DropdownComponent dropdown = new DropdownComponent(Sizing.content());
        builder.accept(dropdown);
        mountFunction.accept(rootComponent, dropdown);
        int xLocation = (int)mouseX - rootComponent.x();
        int yLocation = (int)mouseY - rootComponent.y();
        if (xLocation + dropdown.width() > screen.width) {
            xLocation -= xLocation + dropdown.width() - screen.width;
        }
        if (yLocation + dropdown.height() > screen.height) {
            yLocation -= yLocation + dropdown.height() - screen.height;
        }
        dropdown.positioning(Positioning.absolute(xLocation, yLocation));
        MutableBoolean dismounted = new MutableBoolean(false);
        componentHook.computeIfAbsent(screen, screen1 -> new ArrayList()).add(click -> {
            if (dismounted.isTrue() || dropdown.isInBoundingBox(click.x(), click.y())) {
                return;
            }
            rootComponent.removeChild(dropdown);
            dismounted.setTrue();
        });
        return dropdown;
    }

    @Override
    public ParentComponent surface(Surface surface) {
        this.entries.surface(surface);
        return this;
    }

    @Override
    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        super.draw(context, mouseX, mouseY, partialTicks, delta);
        if (this.closeWhenNotHovered && !this.isInBoundingBox(mouseX, mouseY)) {
            this.queue(() -> {
                this.closeWhenNotHovered(false);
                this.parent.removeChild(this);
            });
        }
    }

    @Override
    public void layout(Size space) {
        super.layout(space);
        List<io.wispforest.owo.ui.core.Component> entries = this.entries.children();
        for (int i = 0; i < entries.size(); ++i) {
            io.wispforest.owo.ui.core.Component entry = entries.get(i);
            if (!(entry instanceof ResizeableComponent)) continue;
            ResizeableComponent sizeable = (ResizeableComponent)((Object)entry);
            sizeable.setWidth(this.entries.width() - ((Insets)this.entries.padding().get()).horizontal() - ((Insets)entry.margins().get()).horizontal());
        }
    }

    public DropdownComponent divider() {
        this.entries.child(new Divider());
        return this;
    }

    public DropdownComponent text(Component text) {
        this.entries.child(Components.label(text).color(Color.ofFormatting(ChatFormatting.GRAY)).margins(Insets.of(2)));
        return this;
    }

    public DropdownComponent button(Component text, Consumer<DropdownComponent> onClick) {
        this.entries.child(new Button(this, text, onClick).margins(Insets.of(2)));
        return this;
    }

    public DropdownComponent checkbox(Component text, boolean state, Consumer<Boolean> onClick) {
        this.entries.child(new Checkbox(this, text, state, onClick).margins(Insets.of(2)));
        return this;
    }

    public DropdownComponent nested(Component text, Sizing horizontalSizing, Consumer<DropdownComponent> builder) {
        DropdownComponent nested = new DropdownComponent(horizontalSizing);
        builder.accept(nested);
        this.entries.child(new NestEntry(this, text, nested).margins(Insets.of(2)));
        return this;
    }

    @Override
    public FlowLayout removeChild(io.wispforest.owo.ui.core.Component child) {
        if (child == this.entries) {
            this.queue(() -> {
                this.closeWhenNotHovered(false);
                this.parent.removeChild(this);
            });
        }
        return super.removeChild(child);
    }

    public DropdownComponent closeWhenNotHovered(boolean closeWhenNotHovered) {
        this.closeWhenNotHovered = closeWhenNotHovered;
        return this;
    }

    public boolean closeWhenNotHovered() {
        return this.closeWhenNotHovered;
    }

    @Override
    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, "entries", Function.identity(), this::parseAndApplyEntries);
        UIParsing.apply(children, "close-when-not-hovered", UIParsing::parseBool, this::closeWhenNotHovered);
    }

    protected void parseAndApplyEntries(Element container) {
        for (Node node : UIParsing.allChildrenOfType(container, (short)1)) {
            Element entry = (Element)node;
            switch (entry.getNodeName()) {
                case "divider": {
                    this.divider();
                    break;
                }
                case "text": {
                    this.text(UIParsing.parseText(entry));
                    break;
                }
                case "button": {
                    Map<String, Element> children = UIParsing.childElements(entry);
                    UIParsing.expectChildren(entry, children, "text");
                    Component text = UIParsing.parseText(children.get("text"));
                    this.button(text, dropdownComponent -> {});
                    break;
                }
                case "checkbox": {
                    Map<String, Element> children = UIParsing.childElements(entry);
                    UIParsing.expectChildren(entry, children, "text", "checked");
                    Component text = UIParsing.parseText(children.get("text"));
                    boolean checked = UIParsing.parseBool(children.get("checked"));
                    this.checkbox(text, checked, aBoolean -> {});
                    break;
                }
                case "nested": {
                    MutableComponent text = entry.getAttribute("translate").equals("true") ? Component.translatable((String)entry.getAttribute("name")) : Component.literal((String)entry.getAttribute("name"));
                    this.nested((Component)text, Sizing.content(), dropdownComponent -> dropdownComponent.parseAndApplyEntries(entry));
                }
            }
        }
    }

    protected static void drawIconFromTexture(OwoUIDrawContext context, ParentComponent dropdown, int y, int u, int v) {
        context.blit(RenderPipelines.GUI_TEXTURED, ICONS_TEXTURE, dropdown.x() + dropdown.width() - ((Insets)dropdown.padding().get()).right() - 10, y, u, v, 9, 9, 32, 32);
    }

    static {
        NeoForge.EVENT_BUS.addListener(event -> componentHook.remove(event.getScreen()));
        NeoForge.EVENT_BUS.addListener(event -> componentHook.getOrDefault(event.getScreen(), List.of()).forEach(consumer -> consumer.accept(event.getMouseButtonEvent())));
    }

    protected static interface ResizeableComponent {
        public void setWidth(int var1);
    }

    protected static class Divider
    extends BaseComponent
    implements ResizeableComponent {
        public Divider() {
            this.sizing(Sizing.fixed(1));
        }

        @Override
        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            Insets margins = (Insets)this.margins.get();
            context.fill(this.x - margins.left(), this.y - margins.top(), this.x + this.width + margins.right(), this.y + this.height + margins.bottom(), -15592942);
        }

        @Override
        public void setWidth(int width) {
            this.width = width;
        }
    }

    protected static class Button
    extends LabelComponent
    implements ResizeableComponent {
        protected final DropdownComponent parentDropdown;
        protected Consumer<DropdownComponent> onClick;

        protected Button(DropdownComponent parentDropdown, Component text, Consumer<DropdownComponent> onClick) {
            super(text);
            this.onClick = onClick;
            this.parentDropdown = parentDropdown;
            this.margins(Insets.vertical(1));
            this.cursorStyle(CursorStyle.HAND);
        }

        @Override
        public void setWidth(int width) {
            this.width = width;
        }

        @Override
        public boolean onMouseDown(MouseButtonEvent click, boolean doubled) {
            super.onMouseDown(click, doubled);
            this.onClick.accept(this.parentDropdown);
            this.playInteractionSound();
            return true;
        }

        @Override
        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            if (this.isInBoundingBox(mouseX, mouseY)) {
                Insets margins = (Insets)this.margins.get();
                context.fill(this.x - margins.left(), this.y - margins.top(), this.x + this.width + margins.right(), this.y + this.height + margins.bottom(), 0x44FFFFFF);
            }
            super.draw(context, mouseX, mouseY, partialTicks, delta);
        }

        protected void playInteractionSound() {
            UISounds.playButtonSound();
        }
    }

    protected static class Checkbox
    extends Button {
        protected boolean state;

        public Checkbox(DropdownComponent parentDropdown, Component text, boolean state, Consumer<Boolean> onClick) {
            super(parentDropdown, text, dropdownComponent -> {});
            this.state = state;
            this.onClick = dropdownComponent -> {
                this.state = !this.state;
                onClick.accept(this.state);
            };
        }

        @Override
        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            super.draw(context, mouseX, mouseY, partialTicks, delta);
            DropdownComponent.drawIconFromTexture(context, this.parent, this.y, this.state ? 16 : 0, 0);
        }

        @Override
        protected int determineHorizontalContentSize(Sizing sizing) {
            return super.determineHorizontalContentSize(sizing) + 17;
        }

        @Override
        protected void playInteractionSound() {
            UISounds.playInteractionSound();
        }
    }

    protected static class NestEntry
    extends LabelComponent {
        private final DropdownComponent child;

        protected NestEntry(DropdownComponent parentDropdown, Component text, DropdownComponent child) {
            super(text);
            this.child = child;
            this.mouseEnter().subscribe(() -> {
                child.margins(Insets.top(this.y - parentDropdown.y));
                parentDropdown.queue(() -> {
                    parentDropdown.removeChild(child);
                    parentDropdown.child(child);
                });
            });
        }

        @Override
        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            super.draw(context, mouseX, mouseY, partialTicks, delta);
            DropdownComponent.drawIconFromTexture(context, this.parent, this.y, 0, 16);
            this.child.closeWhenNotHovered(!PositionedRectangle.of(this.x, this.y, this.parent.width(), this.height).isInBoundingBox(mouseX, mouseY));
        }

        @Override
        protected int determineHorizontalContentSize(Sizing sizing) {
            return super.determineHorizontalContentSize(sizing) + 17;
        }
    }
}

