/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.component;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.math.Axis;
import io.wispforest.owo.Owo;
import io.wispforest.owo.mixin.ui.access.EntityRendererAccessor;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.renderstate.EntityElementRenderState;
import java.time.Duration;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.client.multiplayer.LevelLoadTracker;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.telemetry.TelemetryEventSender;
import net.minecraft.client.telemetry.WorldSessionTelemetryManager;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerLinks;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.w3c.dom.Element;

public class EntityComponent<E extends Entity>
extends BaseComponent {
    protected final EntityRenderDispatcher manager;
    protected final MultiBufferSource.BufferSource entityBuffers;
    protected final E entity;
    protected float mouseRotation = 0.0f;
    protected float scale = 1.0f;
    protected boolean lookAtCursor = false;
    protected boolean allowMouseRotation = false;
    protected boolean scaleToFit = false;
    protected boolean showNametag = false;
    protected Consumer<Matrix4f> transform;

    protected EntityComponent(Sizing sizing, E entity) {
        this.transform = matrixStack -> {};
        Minecraft client = Minecraft.getInstance();
        this.manager = client.getEntityRenderDispatcher();
        this.entityBuffers = client.renderBuffers().bufferSource();
        this.entity = entity;
        this.sizing(sizing);
    }

    protected EntityComponent(Sizing sizing, EntityType<E> type, @Nullable CompoundTag nbt) {
        this.transform = matrixStack -> {};
        Minecraft client = Minecraft.getInstance();
        this.manager = client.getEntityRenderDispatcher();
        this.entityBuffers = client.renderBuffers().bufferSource();
        this.entity = type.create((Level)client.level, EntitySpawnReason.BREEDING);
        if (nbt != null) {
            this.entity.load(TagValueInput.create((ProblemReporter)new ProblemReporter.ScopedCollector(Owo.LOGGER), (HolderLookup.Provider)client.level.registryAccess(), (CompoundTag)nbt));
        }
        this.entity.absSnapTo(client.player.getX(), client.player.getY(), client.player.getZ());
        this.sizing(sizing);
    }

    @Override
    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        Matrix4f matrix = new Matrix4f();
        matrix.scale(75.0f * this.scale * (float)this.width / 64.0f, -75.0f * this.scale * (float)this.height / 64.0f, -75.0f * this.scale);
        matrix.translate(0.0f, this.entity.getBbHeight() / 2.0f, 0.0f);
        this.transform.accept(matrix);
        if (this.lookAtCursor) {
            float xRotation = (float)Math.toDegrees(Math.atan(((float)(mouseY - this.y) - (float)this.height / 2.0f) / 40.0f));
            float yRotation = (float)Math.toDegrees(Math.atan(((float)(mouseX - this.x) - (float)this.width / 2.0f) / 40.0f));
            E e = this.entity;
            if (e instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)e;
                living.yHeadRotO = -yRotation;
            }
            ((Entity)this.entity).yRotO = -yRotation;
            ((Entity)this.entity).xRotO = xRotation * 0.65f;
            if (xRotation == 0.0f) {
                xRotation = 0.1f;
            }
            matrix.rotate((Quaternionfc)Axis.XP.rotationDegrees(xRotation * 0.15f));
            matrix.rotate((Quaternionfc)Axis.YP.rotationDegrees(yRotation * 0.15f));
        } else {
            matrix.rotate((Quaternionfc)Axis.XP.rotationDegrees(35.0f));
            matrix.rotate((Quaternionfc)Axis.YP.rotationDegrees(-45.0f + this.mouseRotation));
        }
        EntityRenderState entityState = this.manager.extractEntity(this.entity, partialTicks);
        EntityRenderer renderer = this.manager.getRenderer(this.entity);
        if (this.showNametag) {
            entityState.nameTag = ((EntityRendererAccessor)renderer).owo$getDisplayName(this.entity);
            entityState.nameTagAttachment = this.entity.getAttachments().getNullable(EntityAttachment.NAME_TAG, 0, this.entity.getYRot(partialTicks));
        } else {
            entityState.nameTag = null;
            entityState.nameTagAttachment = null;
        }
        context.guiRenderState.submitPicturesInPictureState((PictureInPictureRenderState)new EntityElementRenderState(entityState, matrix, new ScreenRectangle(this.x, this.y, this.width, this.height), context.scissorStack.peek()));
    }

    @Override
    public boolean onMouseDrag(MouseButtonEvent click, double deltaX, double deltaY) {
        if (this.allowMouseRotation && click.button() == 0) {
            this.mouseRotation = (float)((double)this.mouseRotation + deltaX);
            super.onMouseDrag(click, deltaX, deltaY);
            return true;
        }
        return super.onMouseDrag(click, deltaX, deltaY);
    }

    public E entity() {
        return this.entity;
    }

    public EntityComponent<E> allowMouseRotation(boolean allowMouseRotation) {
        this.allowMouseRotation = allowMouseRotation;
        return this;
    }

    public boolean allowMouseRotation() {
        return this.allowMouseRotation;
    }

    public EntityComponent<E> lookAtCursor(boolean lookAtCursor) {
        this.lookAtCursor = lookAtCursor;
        return this;
    }

    public boolean lookAtCursor() {
        return this.lookAtCursor;
    }

    public EntityComponent<E> scale(float scale) {
        this.scale = scale;
        return this;
    }

    public float scale() {
        return this.scale;
    }

    public EntityComponent<E> scaleToFit(boolean scaleToFit) {
        this.scaleToFit = scaleToFit;
        if (scaleToFit) {
            float xScale = 0.5f / this.entity.getBbWidth();
            float yScale = 0.5f / this.entity.getBbHeight();
            this.scale(Math.min(xScale, yScale));
        }
        return this;
    }

    public boolean scaleToFit() {
        return this.scaleToFit;
    }

    public EntityComponent<E> transform(Consumer<Matrix4f> transform) {
        this.transform = transform;
        return this;
    }

    public Consumer<Matrix4f> transform() {
        return this.transform;
    }

    public EntityComponent<E> showNametag(boolean showNametag) {
        this.showNametag = showNametag;
        return this;
    }

    public boolean showNametag() {
        return this.showNametag;
    }

    @Override
    public boolean canFocus(Component.FocusSource source) {
        return source == Component.FocusSource.MOUSE_CLICK;
    }

    public static RenderablePlayerEntity createRenderablePlayer(GameProfile profile) {
        return new RenderablePlayerEntity(profile);
    }

    @Override
    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, "scale", UIParsing::parseFloat, this::scale);
        UIParsing.apply(children, "look-at-cursor", UIParsing::parseBool, this::lookAtCursor);
        UIParsing.apply(children, "mouse-rotation", UIParsing::parseBool, this::allowMouseRotation);
        UIParsing.apply(children, "scale-to-fit", UIParsing::parseBool, this::scaleToFit);
    }

    public static EntityComponent<?> parse(Element element) {
        UIParsing.expectAttributes(element, "type");
        ResourceLocation entityId = UIParsing.parseIdentifier(element.getAttributeNode("type"));
        EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.getOptional(entityId).orElseThrow(() -> new UIModelParsingException("Unknown entity type " + String.valueOf(entityId)));
        CompoundTag nbt = null;
        if (element.hasAttribute("nbt")) {
            try {
                nbt = TagParser.parseCompoundFully((String)element.getAttribute("nbt"));
            }
            catch (CommandSyntaxException cse) {
                throw new UIModelParsingException("Invalid NBT compound", cse);
            }
        }
        return new EntityComponent(Sizing.content(), entityType, nbt);
    }

    public static class RenderablePlayerEntity
    extends LocalPlayer {
        protected PlayerSkin skinTextures;

        protected RenderablePlayerEntity(GameProfile profile) {
            super(Minecraft.getInstance(), Minecraft.getInstance().level, new ClientPacketListener(Minecraft.getInstance(), new Connection(PacketFlow.CLIENTBOUND), new CommonListenerCookie(new LevelLoadTracker(0L), profile, new WorldSessionTelemetryManager(TelemetryEventSender.DISABLED, false, Duration.ZERO, ""), Minecraft.getInstance().level.registryAccess().freeze(), Minecraft.getInstance().level.enabledFeatures(), "Wisp Forest Enterprises", null, null, Map.of(), null, Map.of(), ServerLinks.EMPTY, Map.of(), true)), null, null, Input.EMPTY, false);
            this.skinTextures = DefaultPlayerSkin.get((GameProfile)profile);
            Util.backgroundExecutor().execute(() -> {
                GameProfile completeProfile = Minecraft.getInstance().services().profileResolver().fetchById(profile.id()).orElse(profile);
                this.skinTextures = DefaultPlayerSkin.get((GameProfile)completeProfile);
                this.minecraft.getSkinManager().get(completeProfile).thenAccept(textures -> textures.ifPresent($ -> {
                    this.skinTextures = $;
                }));
            });
        }

        public PlayerSkin getSkin() {
            return this.skinTextures;
        }

        public boolean isModelPartShown(PlayerModelPart part) {
            return true;
        }

        @Nullable
        protected PlayerInfo getPlayerInfo() {
            return null;
        }
    }
}

