/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.renderstate;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.FeatureRenderDispatcher;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public record BlockElementRenderState(BlockState state, @Nullable BlockEntityRenderState entity, ScreenRectangle bounds, ScreenRectangle scissorArea) implements PictureInPictureRenderState
{
    private final ScreenRectangle bounds;

    public int x0() {
        return this.bounds.left();
    }

    public int x1() {
        return this.bounds.right();
    }

    public int y0() {
        return this.bounds.top();
    }

    public int y1() {
        return this.bounds.bottom();
    }

    public float scale() {
        return 1.0f;
    }

    @Nullable
    public ScreenRectangle bounds() {
        return this.scissorArea != null ? this.scissorArea.intersection(this.bounds) : this.bounds;
    }

    public static class Renderer
    extends PictureInPictureRenderer<BlockElementRenderState> {
        public Renderer(MultiBufferSource.BufferSource vertexConsumers) {
            super(vertexConsumers);
        }

        public Class<BlockElementRenderState> getRenderStateClass() {
            return BlockElementRenderState.class;
        }

        protected void render(BlockElementRenderState state, PoseStack matrices) {
            BlockEntityRenderer \u043c\u0435\u0434\u0432\u0435\u0434\u044c;
            Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ENTITY_IN_UI);
            int width = state.bounds.width();
            int height = state.bounds.height();
            matrices.translate(0.0f, (float)(-height) / 2.0f, 100.0f);
            matrices.scale((float)(40 * width) / 64.0f, (float)(-40 * height) / 64.0f, -40.0f);
            matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(30.0f));
            matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(225.0f));
            matrices.translate(-0.5, -0.5, -0.5);
            if (state.state.getRenderShape() != RenderShape.INVISIBLE) {
                Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state.state, matrices, (MultiBufferSource)this.bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY);
            }
            if (state.entity != null && (\u043c\u0435\u0434\u0432\u0435\u0434\u044c = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(state.entity)) != null) {
                FeatureRenderDispatcher dispatcher = Minecraft.getInstance().gameRenderer.getFeatureRenderDispatcher();
                \u043c\u0435\u0434\u0432\u0435\u0434\u044c.submit(state.entity, matrices, (SubmitNodeCollector)dispatcher.getSubmitNodeStorage(), new CameraRenderState());
                dispatcher.renderAllFeatures();
            }
        }

        protected String getTextureLabel() {
            return "owo-ui_block";
        }
    }
}

