package io.wispforest.owo.mixin.ext;

import io.wispforest.owo.ext.DerivedComponentMap;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(ItemStack.class)
public class ItemStackMixin {
    @Shadow @Final
    PatchedDataComponentMap components;

    @Unique private DerivedComponentMap owo$derivedMap;

    @Inject(method = "<init>(Lnet/minecraft/item/ItemConvertible;ILnet/minecraft/component/MergedComponentMap;)V", at = @At("TAIL"))
    private void injectDerivedComponentMap(ItemLike item, int count, PatchedDataComponentMap components, CallbackInfo ci) {
        var base = ((MergedComponentMapAccessor)(Object) this.components).owo$getBaseComponents();

        if (base instanceof DerivedComponentMap derived) {
            owo$derivedMap = derived;
        } else {
            owo$derivedMap = new DerivedComponentMap(base);
            ((MergedComponentMapAccessor)(Object) this.components).owo$setBaseComponents(owo$derivedMap);
        }
    }

    @Inject(method = "applyChanges", at = @At(value = "INVOKE", target = "Lnet/minecraft/component/MergedComponentMap;applyChanges(Lnet/minecraft/component/ComponentChanges;)V", shift = At.Shift.AFTER))
    private void deriveComponents2(DataComponentPatch changes, CallbackInfo ci) {
        if (owo$derivedMap == null) return;
        owo$derivedMap.derive((ItemStack)(Object) this);
    }

    @Inject(method = "applyUnvalidatedChanges", at = @At(value = "INVOKE", target = "Lnet/minecraft/component/MergedComponentMap;applyChanges(Lnet/minecraft/component/ComponentChanges;)V", shift = At.Shift.AFTER))
    private void deriveComponents3(DataComponentPatch changes, CallbackInfo ci) {
        if (owo$derivedMap == null) return;
        owo$derivedMap.derive((ItemStack)(Object) this);
    }

    @Inject(method = "applyComponentsFrom", at = @At(value = "INVOKE", target = "Lnet/minecraft/component/MergedComponentMap;setAll(Lnet/minecraft/component/ComponentMap;)V", shift = At.Shift.AFTER))
    private void deriveComponents4(DataComponentMap components, CallbackInfo ci) {
        if (owo$derivedMap == null) return;
        owo$derivedMap.derive((ItemStack)(Object) this);
    }
}
