/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.renderdoc;

import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.renderdoc.RenderDoc;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.CheckboxComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.util.CommandOpenedScreen;
import java.util.EnumSet;
import net.minecraft.class_11908;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderdocScreen
extends BaseOwoScreen<FlowLayout>
implements CommandOpenedScreen {
    private int ticks = 0;
    private boolean setCaptureKey = false;
    @Nullable
    private RenderDoc.Key scheduledKey = null;
    private ButtonComponent captureKeyButton = null;
    private LabelComponent captureLabel = null;

    @Override
    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create(this, Containers::verticalFlow);
    }

    @Override
    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT);
        EnumSet<RenderDoc.OverlayOption> overlayState = RenderDoc.getOverlayOptions();
        this.captureKeyButton = Components.button(class_2561.method_30163((String)"Capture Hotkey"), button -> {
            button.field_22763 = false;
            button.method_25355(class_2561.method_30163((String)"Press..."));
            this.setCaptureKey = true;
        });
        this.captureLabel = Components.label(this.createCapturesText());
        rootComponent.child(Containers.verticalFlow(Sizing.content(), Sizing.content()).child(Components.label((class_2561)class_2561.method_43470((String)"RenderDoc Controls")).shadow(true).margins(Insets.top(5).withBottom(10))).child(Containers.grid(Sizing.content(), Sizing.content(), 2, 2).child((Component)((Object)RenderdocScreen.overlayControl(class_2561.method_30163((String)"Enabled"), overlayState, RenderDoc.OverlayOption.ENABLED)), 0, 0).child((Component)((Object)RenderdocScreen.overlayControl(class_2561.method_30163((String)"Capture List"), overlayState, RenderDoc.OverlayOption.CAPTURE_LIST)), 0, 1).child((Component)((Object)RenderdocScreen.overlayControl(class_2561.method_30163((String)"Frame Rate"), overlayState, RenderDoc.OverlayOption.FRAME_RATE)), 1, 0).child((Component)((Object)RenderdocScreen.overlayControl(class_2561.method_30163((String)"Frame Number"), overlayState, RenderDoc.OverlayOption.FRAME_NUMBER)), 1, 1)).child(Components.box(Sizing.fixed(175), Sizing.fixed(1)).color(Color.ofFormatting(class_124.field_1063)).fill(true).margins(Insets.vertical(5))).child(Containers.grid(Sizing.content(), Sizing.content(), 2, 2).child(Components.button(class_2561.method_30163((String)"Launch UI"), button -> RenderDoc.launchReplayUI(true)).horizontalSizing(Sizing.fixed(90)).margins(Insets.of(2)), 0, 0).child(this.captureKeyButton.horizontalSizing(Sizing.fixed(90)).margins(Insets.of(2)), 1, 0).child(Components.button(class_2561.method_30163((String)"Capture Frame"), button -> RenderDoc.triggerCapture()).horizontalSizing(Sizing.fixed(90)).margins(Insets.of(2)), 0, 1).child(this.captureLabel, 1, 1).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER)).horizontalAlignment(HorizontalAlignment.CENTER).padding(Insets.of(5)).surface(Surface.flat(0x77000000).and(Surface.outline(0x77000000)))).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER);
    }

    public void method_25393() {
        super.method_25393();
        if (++this.ticks % 10 != 0) {
            return;
        }
        if (this.scheduledKey != null) {
            RenderDoc.setCaptureKeys(this.scheduledKey);
            this.scheduledKey = null;
        }
        this.captureLabel.text(this.createCapturesText());
    }

    @Override
    public boolean method_25404(class_11908 input) {
        if (this.setCaptureKey) {
            this.captureKeyButton.field_22763 = true;
            this.captureKeyButton.method_25355(class_2561.method_30163((String)"Capture Hotkey"));
            this.setCaptureKey = false;
            RenderDoc.Key key = RenderDoc.Key.fromGLFW(input.comp_4795());
            if (key != null) {
                this.ticks = 0;
                this.scheduledKey = key;
                return true;
            }
        }
        return super.method_25404(input);
    }

    private class_2561 createCapturesText() {
        return TextOps.withColor("Captures: \u00a7" + RenderDoc.getNumCaptures(), TextOps.color(class_124.field_1068), 55295);
    }

    private static CheckboxComponent overlayControl(class_2561 name, EnumSet<RenderDoc.OverlayOption> state, RenderDoc.OverlayOption option) {
        CheckboxComponent checkbox = Components.checkbox(name);
        checkbox.margins(Insets.of(3)).horizontalSizing(Sizing.fixed(100));
        checkbox.checked(state.contains((Object)option));
        checkbox.onChanged(enabled -> {
            if (enabled.booleanValue()) {
                RenderDoc.enableOverlayOptions(option);
            } else {
                RenderDoc.disableOverlayOptions(option);
            }
        });
        return checkbox;
    }
}

