/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.core;

import io.wispforest.owo.ui.core.AnimatableProperty;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.event.CharTyped;
import io.wispforest.owo.ui.event.FocusGained;
import io.wispforest.owo.ui.event.FocusLost;
import io.wispforest.owo.ui.event.KeyPress;
import io.wispforest.owo.ui.event.MouseDown;
import io.wispforest.owo.ui.event.MouseDrag;
import io.wispforest.owo.ui.event.MouseEnter;
import io.wispforest.owo.ui.event.MouseLeave;
import io.wispforest.owo.ui.event.MouseScroll;
import io.wispforest.owo.ui.event.MouseUp;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.FocusHandler;
import io.wispforest.owo.util.EventSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public interface Component
extends PositionedRectangle {
    public void draw(OwoUIDrawContext var1, int var2, int var3, float var4, float var5);

    default public void drawTooltip(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        if (!this.shouldDrawTooltip(mouseX, mouseY)) {
            return;
        }
        context.drawTooltip(class_310.method_1551().field_1772, mouseX, mouseY, this.tooltip());
    }

    default public void drawFocusHighlight(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        context.drawRectOutline(this.x(), this.y(), this.width(), this.height(), -1);
    }

    @Contract(pure=true)
    @Nullable
    public ParentComponent parent();

    @Contract(pure=true)
    @Nullable
    public FocusHandler focusHandler();

    public Component positioning(Positioning var1);

    @Contract(pure=true)
    public AnimatableProperty<Positioning> positioning();

    public Component margins(Insets var1);

    @Contract(pure=true)
    public AnimatableProperty<Insets> margins();

    default public Component sizing(Sizing horizontalSizing, Sizing verticalSizing) {
        this.horizontalSizing(horizontalSizing);
        this.verticalSizing(verticalSizing);
        return this;
    }

    default public Component sizing(Sizing sizing) {
        this.sizing(sizing, sizing);
        return this;
    }

    public Component horizontalSizing(Sizing var1);

    @Contract(pure=true)
    public AnimatableProperty<Sizing> horizontalSizing();

    public Component verticalSizing(Sizing var1);

    @Contract(pure=true)
    public AnimatableProperty<Sizing> verticalSizing();

    public Component id(@Nullable String var1);

    @Nullable
    public String id();

    public Component tooltip(@Nullable List<class_5684> var1);

    default public Component tooltip(@NotNull Collection<class_2561> tooltip) {
        ArrayList<class_5684> components = new ArrayList<class_5684>();
        for (class_2561 line : tooltip) {
            components.add(class_5684.method_32662((class_5481)line.method_30937()));
        }
        this.tooltip((List<class_5684>)components);
        return this;
    }

    default public Component tooltip(@NotNull class_2561 tooltip) {
        ArrayList<class_5684> components = new ArrayList<class_5684>();
        for (class_5481 line : class_310.method_1551().field_1772.method_1728((class_5348)tooltip, Integer.MAX_VALUE)) {
            components.add(class_5684.method_32662((class_5481)line));
        }
        this.tooltip((List<class_5684>)components);
        return this;
    }

    @Contract(pure=true)
    @Nullable
    public List<class_5684> tooltip();

    default public boolean shouldDrawTooltip(double mouseX, double mouseY) {
        return this.tooltip() != null && !this.tooltip().isEmpty() && this.isInBoundingBox(mouseX, mouseY);
    }

    public void inflate(Size var1);

    public void mount(ParentComponent var1, int var2, int var3);

    public void dismount(DismountReason var1);

    public <C extends Component> C configure(Consumer<C> var1);

    @Contract(pure=true)
    default public boolean hasParent() {
        return this.parent() != null;
    }

    default public ParentComponent root() {
        ParentComponent root = this.parent();
        if (root == null) {
            return null;
        }
        while (root.hasParent()) {
            root = root.parent();
        }
        return root;
    }

    default public void remove() {
        if (!this.hasParent()) {
            return;
        }
        this.parent().queue(() -> this.parent().removeChild(this));
    }

    public boolean onMouseDown(class_11909 var1, boolean var2);

    public EventSource<MouseDown> mouseDown();

    public boolean onMouseUp(class_11909 var1);

    public EventSource<MouseUp> mouseUp();

    public boolean onMouseScroll(double var1, double var3, double var5);

    public EventSource<MouseScroll> mouseScroll();

    public boolean onMouseDrag(class_11909 var1, double var2, double var4);

    public EventSource<MouseDrag> mouseDrag();

    public boolean onKeyPress(class_11908 var1);

    public EventSource<KeyPress> keyPress();

    public boolean onCharTyped(class_11905 var1);

    public EventSource<CharTyped> charTyped();

    default public boolean canFocus(FocusSource source) {
        return false;
    }

    public void onFocusGained(FocusSource var1);

    public EventSource<FocusGained> focusGained();

    public void onFocusLost();

    public EventSource<FocusLost> focusLost();

    public EventSource<MouseEnter> mouseEnter();

    public EventSource<MouseLeave> mouseLeave();

    public CursorStyle cursorStyle();

    public Component cursorStyle(CursorStyle var1);

    default public void update(float delta, int mouseX, int mouseY) {
        this.margins().update(delta);
        this.positioning().update(delta);
        this.horizontalSizing().update(delta);
        this.verticalSizing().update(delta);
    }

    @Override
    default public boolean isInBoundingBox(double x, double y) {
        return PositionedRectangle.super.isInBoundingBox(x, y);
    }

    default public Size fullSize() {
        Insets margins = (Insets)this.margins().get();
        return Size.of(this.width() + margins.horizontal(), this.height() + margins.vertical());
    }

    default public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        if (!element.getAttribute("id").isBlank()) {
            this.id(element.getAttribute("id").strip());
        }
        UIParsing.apply(children, "margins", Insets::parse, this::margins);
        UIParsing.apply(children, "positioning", Positioning::parse, this::positioning);
        UIParsing.apply(children, "cursor-style", UIParsing.parseEnum(CursorStyle.class), this::cursorStyle);
        UIParsing.apply(children, "tooltip-text", UIParsing::parseText, this::tooltip);
        if (children.containsKey("sizing")) {
            Map<String, Element> sizingValues = UIParsing.childElements(children.get("sizing"));
            UIParsing.apply(sizingValues, "vertical", Sizing::parse, this::verticalSizing);
            UIParsing.apply(sizingValues, "horizontal", Sizing::parse, this::horizontalSizing);
        }
    }

    @Override
    @Contract(pure=true)
    public int width();

    @Override
    @Contract(pure=true)
    public int height();

    @Override
    @Contract(pure=true)
    public int x();

    default public int baseX() {
        return this.x();
    }

    public void updateX(int var1);

    @Override
    @Contract(pure=true)
    public int y();

    default public int baseY() {
        return this.y();
    }

    public void updateY(int var1);

    default public void moveTo(int x, int y) {
        this.updateX(x);
        this.updateY(y);
    }

    default public class_5250 inspectorDescriptor() {
        Insets margins = (Insets)this.margins().get();
        return class_2561.method_43470((String)(this.x() + "," + this.y() + " (" + this.width() + "," + this.height() + ")")).method_10852((class_2561)class_2561.method_43470((String)(" <" + margins.top() + "," + margins.bottom() + "," + margins.left() + "," + margins.right() + ">")).method_10862(class_2583.field_24360.method_10977(class_124.field_1054)));
    }

    public static enum DismountReason {
        LAYOUT_INFLATION,
        REMOVED;

    }

    public static enum FocusSource {
        MOUSE_CLICK,
        KEYBOARD_CYCLE;

    }
}

