/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.core;

import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.renderstate.BlurQuadElementRenderState;
import io.wispforest.owo.ui.renderstate.CubeMapElementRenderState;
import io.wispforest.owo.ui.util.NinePatchTexture;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_11244;
import net.minecraft.class_11256;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_766;
import net.minecraft.class_8002;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.w3c.dom.Element;

public interface Surface {
    public static final Surface BLANK = (context, component) -> {};
    public static final Surface PANEL = (context, component) -> context.drawPanel(component.x(), component.y(), component.width(), component.height(), false);
    public static final Surface DARK_PANEL = (context, component) -> context.drawPanel(component.x(), component.y(), component.width(), component.height(), true);
    public static final Surface PANEL_INSET = (context, component) -> NinePatchTexture.draw(OwoUIDrawContext.PANEL_INSET_NINE_PATCH_TEXTURE, context, component);
    public static final Surface VANILLA_TRANSLUCENT = (context, component) -> context.drawGradientRect(component.x(), component.y(), component.width(), component.height(), -1072689136, -1072689136, -804253680, -804253680);
    public static final Surface TOOLTIP = Surface.tooltip(null);

    public static Surface tooltip(@Nullable class_2960 texture) {
        return (context, component) -> class_8002.method_47946((class_332)context, (int)(component.x() + 4), (int)(component.y() + 4), (int)(component.width() - 8), (int)(component.height() - 8), (class_2960)texture);
    }

    public static Surface blur(float quality, float size) {
        return (context, component) -> context.field_59826.method_70919((class_11244)new BlurQuadElementRenderState(new Matrix3x2f((Matrix3x2fc)context.method_51448()), new class_8030(component.x(), component.y(), component.width(), component.height()), context.field_44659.method_70863(), 16, quality, size));
    }

    public static Surface optionsBackground() {
        return Surface.vanillaPanorama(false).and(Surface.blur(5.0f, 10.0f));
    }

    public static Surface vanillaPanorama(boolean alwaysVisible) {
        return Surface.panorama(class_310.method_1551().field_1773.method_71649(), alwaysVisible);
    }

    public static Surface panorama(class_766 renderer, boolean alwaysVisible) {
        return (context, component) -> {
            if (!alwaysVisible && class_310.method_1551().field_1687 != null) {
                return;
            }
            context.field_59826.method_70922((class_11256)new CubeMapElementRenderState(renderer, true, new class_8030(component.x(), component.y(), component.width(), component.height()), context.field_44659.method_70863()));
        };
    }

    public static Surface flat(int color) {
        return (context, component) -> context.method_25294(component.x(), component.y(), component.x() + component.width(), component.y() + component.height(), color);
    }

    public static Surface outline(int color) {
        return (context, component) -> context.drawRectOutline(component.x(), component.y(), component.width(), component.height(), color);
    }

    public static Surface tiled(class_2960 texture, int textureWidth, int textureHeight) {
        return (context, component) -> context.method_25290(class_10799.field_56883, texture, component.x(), component.y(), 0.0f, 0.0f, component.width(), component.height(), textureWidth, textureHeight);
    }

    public static Surface panelWithInset(int insetWidth) {
        return PANEL.and((context, component) -> NinePatchTexture.draw(OwoUIDrawContext.PANEL_INSET_NINE_PATCH_TEXTURE, context, component.x() + insetWidth, component.y() + insetWidth, component.width() - insetWidth * 2, component.height() - insetWidth * 2));
    }

    public void draw(OwoUIDrawContext var1, ParentComponent var2);

    default public Surface and(Surface surface) {
        return (context, component) -> {
            this.draw(context, component);
            surface.draw(context, component);
        };
    }

    public static Surface parse(Element surfaceElement) {
        List<Element> children = UIParsing.allChildrenOfType(surfaceElement, (short)1);
        Surface surface = BLANK;
        for (Element child : children) {
            surface = switch (child.getNodeName()) {
                case "panel" -> surface.and(child.getAttribute("dark").equalsIgnoreCase("true") ? DARK_PANEL : PANEL);
                case "tiled" -> {
                    UIParsing.expectAttributes(child, "texture-width", "texture-height");
                    yield surface.and(Surface.tiled(UIParsing.parseIdentifier(child), UIParsing.parseUnsignedInt(child.getAttributeNode("texture-width")), UIParsing.parseUnsignedInt(child.getAttributeNode("texture-height"))));
                }
                case "blur" -> {
                    UIParsing.expectAttributes(child, "size", "quality");
                    yield surface.and(Surface.blur(UIParsing.parseFloat(child.getAttributeNode("quality")), UIParsing.parseFloat(child.getAttributeNode("size"))));
                }
                case "panel-with-inset" -> surface.and(Surface.panelWithInset(UIParsing.parseUnsignedInt(child)));
                case "options-background" -> surface.and(Surface.optionsBackground());
                case "vanilla-translucent" -> surface.and(VANILLA_TRANSLUCENT);
                case "panel-inset" -> surface.and(PANEL_INSET);
                case "tooltip" -> surface.and(TOOLTIP);
                case "outline" -> surface.and(Surface.outline(Color.parseAndPack(child)));
                case "flat" -> surface.and(Surface.flat(Color.parseAndPack(child)));
                default -> throw new UIModelParsingException("Unknown surface type '" + child.getNodeName() + "'");
            };
        }
        return surface;
    }
}

