/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.renderstate;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import io.wispforest.owo.ui.core.Color;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_4588;
import net.minecraft.class_8029;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;

public final class RingElementRenderState
extends Record
implements class_11244 {
    private final RenderPipeline pipeline;
    private final Matrix3x2f pose;
    private final class_8030 scissorArea;
    private final int centerX;
    private final int centerY;
    private final double angleFrom;
    private final double angleTo;
    private final int segments;
    private final double innerRadius;
    private final double outerRadius;
    private final Color innerColor;
    private final Color outerColor;

    public RingElementRenderState(RenderPipeline pipeline, Matrix3x2f pose, class_8030 scissorArea, int centerX, int centerY, double angleFrom, double angleTo, int segments, double innerRadius, double outerRadius, Color innerColor, Color outerColor) {
        this.pipeline = pipeline;
        this.pose = pose;
        this.scissorArea = scissorArea;
        this.centerX = centerX;
        this.centerY = centerY;
        this.angleFrom = angleFrom;
        this.angleTo = angleTo;
        this.segments = segments;
        this.innerRadius = innerRadius;
        this.outerRadius = outerRadius;
        this.innerColor = innerColor;
        this.outerColor = outerColor;
    }

    public void method_70917(class_4588 vertices) {
        double angleStep = Math.toRadians(this.angleTo - this.angleFrom) / (double)this.segments;
        int inColor = this.innerColor.argb();
        int outColor = this.outerColor.argb();
        for (int i = 0; i <= this.segments; ++i) {
            double theta = Math.toRadians(this.angleFrom) + (double)i * angleStep;
            vertices.method_70815(this.pose, (float)((double)this.centerX - Math.cos(theta) * this.outerRadius), (float)((double)this.centerY - Math.sin(theta) * this.outerRadius)).method_39415(outColor);
            vertices.method_70815(this.pose, (float)((double)this.centerX - Math.cos(theta) * this.innerRadius), (float)((double)this.centerY - Math.sin(theta) * this.innerRadius)).method_39415(inColor);
        }
    }

    public RenderPipeline comp_4055() {
        return this.pipeline;
    }

    public class_11231 comp_4056() {
        return class_11231.method_70899();
    }

    @Nullable
    public class_8030 comp_4069() {
        return this.scissorArea;
    }

    public class_8030 comp_4274() {
        class_8030 screenRect = new class_8030(new class_8029((int)((double)this.centerX - this.outerRadius), (int)((double)this.centerY - this.outerRadius)), (int)Math.ceil(this.outerRadius * 2.0), (int)Math.ceil(this.outerRadius * 2.0)).method_71523(this.pose);
        return this.scissorArea != null ? this.scissorArea.method_49701(screenRect) : screenRect;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{RingElementRenderState.class, "pipeline;pose;scissorArea;centerX;centerY;angleFrom;angleTo;segments;innerRadius;outerRadius;innerColor;outerColor", "pipeline", "pose", "scissorArea", "centerX", "centerY", "angleFrom", "angleTo", "segments", "innerRadius", "outerRadius", "innerColor", "outerColor"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RingElementRenderState.class, "pipeline;pose;scissorArea;centerX;centerY;angleFrom;angleTo;segments;innerRadius;outerRadius;innerColor;outerColor", "pipeline", "pose", "scissorArea", "centerX", "centerY", "angleFrom", "angleTo", "segments", "innerRadius", "outerRadius", "innerColor", "outerColor"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RingElementRenderState.class, "pipeline;pose;scissorArea;centerX;centerY;angleFrom;angleTo;segments;innerRadius;outerRadius;innerColor;outerColor", "pipeline", "pose", "scissorArea", "centerX", "centerY", "angleFrom", "angleTo", "segments", "innerRadius", "outerRadius", "innerColor", "outerColor"}, this, o);
    }

    public Matrix3x2f pose() {
        return this.pose;
    }

    public int centerX() {
        return this.centerX;
    }

    public int centerY() {
        return this.centerY;
    }

    public double angleFrom() {
        return this.angleFrom;
    }

    public double angleTo() {
        return this.angleTo;
    }

    public int segments() {
        return this.segments;
    }

    public double innerRadius() {
        return this.innerRadius;
    }

    public double outerRadius() {
        return this.outerRadius;
    }

    public Color innerColor() {
        return this.innerColor;
    }

    public Color outerColor() {
        return this.outerColor;
    }
}

