/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.particles.systems;

import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.ReflectiveEndecBuilder;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.network.NetworkException;
import io.wispforest.owo.network.OwoHandshake;
import io.wispforest.owo.particles.systems.ParticleSystem;
import io.wispforest.owo.particles.systems.ParticleSystemExecutor;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import io.wispforest.owo.util.OwoFreezer;
import io.wispforest.owo.util.ReflectionUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.jetbrains.annotations.ApiStatus;

public class ParticleSystemController {
    @ApiStatus.Internal
    public static final Map<class_2960, ParticleSystemController> REGISTERED_CONTROLLERS = new HashMap<class_2960, ParticleSystemController>();
    @ApiStatus.Internal
    public final Int2ObjectMap<ParticleSystem<?>> systemsByIndex = new Int2ObjectOpenHashMap();
    public final class_2960 channelId;
    private final class_8710.class_9154<ParticleSystemPayload> payloadId;
    private int maxIndex = 0;
    private final String ownerClassName;
    private final ReflectiveEndecBuilder builder;

    public ParticleSystemController(class_2960 channelId) {
        OwoFreezer.checkRegister("Particle system controllers");
        this.builder = MinecraftEndecs.addDefaults(new ReflectiveEndecBuilder());
        if (REGISTERED_CONTROLLERS.containsKey(channelId)) {
            throw new IllegalStateException("Controller with id '" + String.valueOf(channelId) + "' was already registered from class '" + ParticleSystemController.REGISTERED_CONTROLLERS.get((Object)channelId).ownerClassName + "'");
        }
        this.channelId = channelId;
        this.payloadId = new class_8710.class_9154(channelId);
        this.ownerClassName = ReflectionUtils.getCallingClassName(2);
        StructEndec instanceEndec = Endec.dispatched(index -> {
            ParticleSystem system = (ParticleSystem)this.systemsByIndex.get(index);
            return system.endec.xmap(x -> new ParticleSystemInstance<Object>(system, x), x -> x.data);
        }, instance -> instance.system.index, (Endec)Endec.VAR_INT);
        StructEndec endec = StructEndecBuilder.of((StructField)MinecraftEndecs.VEC3D.fieldOf("pos", ParticleSystemPayload::pos), (StructField)instanceEndec.fieldOf("instance", ParticleSystemPayload::instance), (pos, instance) -> new ParticleSystemPayload(this.payloadId, (class_243)pos, (ParticleSystemInstance<?>)instance));
        PayloadTypeRegistry.playS2C().register(this.payloadId, CodecUtils.toPacketCodec(endec));
        OwoHandshake.enable();
        OwoHandshake.requireHandshake();
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientPlayNetworking.registerGlobalReceiver(this.payloadId, new Client()::handler);
        }
        REGISTERED_CONTROLLERS.put(channelId, this);
    }

    public ReflectiveEndecBuilder endecBuilder() {
        return this.builder;
    }

    public <T> ParticleSystem<T> register(Class<T> dataClass, Endec<T> endec, ParticleSystemExecutor<T> executor) {
        int index = this.maxIndex++;
        ParticleSystem<T> system = new ParticleSystem<T>(this, dataClass, index, endec, executor);
        this.systemsByIndex.put(index, system);
        return system;
    }

    public <T> ParticleSystem<T> register(Class<T> dataClass, ParticleSystemExecutor<T> executor) {
        return this.register(dataClass, this.builder.get(dataClass), executor);
    }

    public <T> ParticleSystem<T> registerDeferred(Class<T> dataClass, Endec<T> endec) {
        int index = this.maxIndex++;
        ParticleSystem<T> system = new ParticleSystem<T>(this, dataClass, index, endec, null);
        this.systemsByIndex.put(index, system);
        return system;
    }

    public <T> ParticleSystem<T> registerDeferred(Class<T> dataClass) {
        return this.registerDeferred(dataClass, this.builder.get(dataClass));
    }

    <T> void sendPacket(ParticleSystem<T> particleSystem, class_3218 world, class_243 pos, T data) {
        ParticleSystemPayload payload = new ParticleSystemPayload(this.payloadId, pos, new ParticleSystemInstance<T>(particleSystem, data));
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)class_2338.method_49638((class_2374)pos))) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        }
    }

    private void verify() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            for (ParticleSystem system : this.systemsByIndex.values()) {
                if (system.handler != null) continue;
                throw new NetworkException("Some particle systems of " + String.valueOf(this.channelId) + " don't have handlers registered");
            }
        }
    }

    static {
        OwoFreezer.registerFreezeCallback(() -> {
            for (ParticleSystemController controller : REGISTERED_CONTROLLERS.values()) {
                controller.verify();
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    private static class Client {
        private Client() {
        }

        private void handler(ParticleSystemPayload payload, ClientPlayNetworking.Context context) {
            payload.instance.execute((class_1937)context.client().field_1687, payload.pos);
        }
    }

    private record ParticleSystemPayload(class_8710.class_9154<ParticleSystemPayload> id, class_243 pos, ParticleSystemInstance<?> instance) implements class_8710
    {
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return this.id;
        }
    }

    private record ParticleSystemInstance<T>(ParticleSystem<T> system, T data) {
        public void execute(class_1937 world, class_243 pos) {
            this.system.handler.executeParticleSystem(world, pos, this.data);
        }
    }
}

