/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.component;

import io.wispforest.owo.Owo;
import io.wispforest.owo.mixin.ui.access.EditBoxAccessor;
import io.wispforest.owo.mixin.ui.access.EditBoxWidgetAccessor;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.util.EventSource;
import io.wispforest.owo.util.EventStream;
import io.wispforest.owo.util.Observable;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7529;
import net.minecraft.class_7530;
import net.minecraft.class_7533;
import org.joml.Matrix3x2fStack;
import org.w3c.dom.Element;

public class TextAreaComponent
extends class_7529 {
    protected final Observable<String> textValue = Observable.of("");
    protected final EventStream<OnChanged> changedEvents = OnChanged.newStream();
    protected final class_7530 editBox;
    protected final Observable<Boolean> displayCharCount = Observable.of(false);
    protected final Observable<Integer> maxLines = Observable.of(-1);

    protected TextAreaComponent(Sizing horizontalSizing, Sizing verticalSizing) {
        super(class_310.method_1551().field_1772, 0, 0, 0, 0, (class_2561)class_2561.method_43473(), (class_2561)class_2561.method_43473(), Color.WHITE.argb(), false, Color.WHITE.argb(), true, true);
        this.editBox = ((EditBoxWidgetAccessor)((Object)this)).owo$getEditBox();
        this.sizing(horizontalSizing, verticalSizing);
        this.textValue.observe(this.changedEvents.sink()::onChanged);
        Observable.observeAll(this.widgetWrapper()::notifyParentIfMounted, this.displayCharCount, this.maxLines);
        super.method_44401(s -> {
            this.textValue.set((String)s);
            if (this.maxLines.get() < 0) {
                return;
            }
            this.widgetWrapper().notifyParentIfMounted();
        });
    }

    @Deprecated(forRemoval=true)
    public void method_44401(Consumer<String> changeListener) {
        Owo.debugWarn(Owo.LOGGER, "setChangeListener stub on TextAreaComponent invoked");
    }

    public void update(float delta, int mouseX, int mouseY) {
        super.update(delta, mouseX, mouseY);
        this.cursorStyle(this.method_44392() && mouseX >= this.method_46426() + this.field_22758 - 9 ? CursorStyle.NONE : CursorStyle.TEXT);
    }

    protected void method_44384(class_332 context) {
        --this.field_22759;
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        matrices.translate(-9.0f, 1.0f);
        int previousMaxLength = this.editBox.method_44409();
        this.editBox.method_44411(Integer.MAX_VALUE);
        super.method_44384(context);
        this.editBox.method_44411(previousMaxLength);
        matrices.popMatrix();
        ++this.field_22759;
        if (this.displayCharCount.get().booleanValue()) {
            class_5250 text = this.editBox.method_44418() ? class_2561.method_43469((String)"gui.multiLineEditBox.character_limit", (Object[])new Object[]{this.editBox.method_44421().length(), this.editBox.method_44409()}) : class_2561.method_43470((String)String.valueOf(this.editBox.method_44421().length()));
            class_327 textRenderer = class_310.method_1551().field_1772;
            context.method_27535(textRenderer, (class_2561)text, this.method_46426() + this.field_22758 - textRenderer.method_27525((class_5348)text), this.method_46427() + this.field_22759 + 3, 0xA0A0A0);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.field_22758 -= 9;
        boolean result = super.method_25402(mouseX, mouseY, button);
        this.field_22758 += 9;
        return result;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean result = super.method_25404(keyCode, scanCode, modifiers);
        if (keyCode == 258) {
            this.editBox.method_44420("    ");
            return true;
        }
        return result;
    }

    public void inflate(Size space) {
        super.inflate(space);
        int cursor = this.editBox.method_44424();
        int selection = ((EditBoxAccessor)this.editBox).owo$getSelectionEnd();
        ((EditBoxAccessor)this.editBox).owo$setWidth(this.width() - this.method_65512() - 9);
        this.editBox.method_44414(this.method_44405(), false);
        super.inflate(space);
        this.editBox.method_44414(this.method_44405(), false);
        this.editBox.method_44412(class_7533.field_39535, cursor);
        ((EditBoxAccessor)this.editBox).owo$setSelectionEnd(selection);
    }

    public EventSource<OnChanged> onChanged() {
        return this.changedEvents.source();
    }

    public TextAreaComponent maxLines(int maxLines) {
        this.maxLines.set(maxLines);
        return this;
    }

    public int maxLines() {
        return this.maxLines.get();
    }

    public TextAreaComponent displayCharCount(boolean displayCharCount) {
        this.displayCharCount.set(displayCharCount);
        return this;
    }

    public boolean displayCharCount() {
        return this.displayCharCount.get();
    }

    public TextAreaComponent text(String text) {
        this.method_44400(text);
        return this;
    }

    public int heightOffset() {
        return this.displayCharCount.get() != false ? -12 : 0;
    }

    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, "display-char-count", UIParsing::parseBool, this::displayCharCount);
        UIParsing.apply(children, "max-length", UIParsing::parseUnsignedInt, arg_0 -> ((TextAreaComponent)this).method_44402(arg_0));
        UIParsing.apply(children, "max-lines", UIParsing::parseUnsignedInt, this::maxLines);
        UIParsing.apply(children, "text", $ -> $.getTextContent().strip(), this::text);
    }

    public static interface OnChanged {
        public void onChanged(String var1);

        public static EventStream<OnChanged> newStream() {
            return new EventStream<OnChanged>(subscribers -> value -> {
                for (OnChanged subscriber : subscribers) {
                    subscriber.onChanged(value);
                }
            });
        }
    }
}

