package com.p1nero.invincible.gameassets;

import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.p1nero.invincible.InvincibleMod;
import com.p1nero.invincible.skill.ChargeDemo;
import com.p1nero.invincible.skill.SimpleCustomInnateSkill;
import com.p1nero.invincible.skill.data.ComboJsonLoader;
import com.p1nero.invincible.gameassets.combos.ComboDemo;
import com.p1nero.invincible.skill.ComboBasicAttack;
import com.p1nero.invincible.skill.data.SkillJsonLoader;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import yesman.epicfight.registry.EpicFightRegistries;
import yesman.epicfight.registry.entries.EpicFightConditions;
import yesman.epicfight.skill.Skill;

import java.io.*;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;

/**
 * 注册技能，然后在{@link InvincibleDemoWeaponCapabilityPresets}中使用
 * 预设的Condition可以参考 {@link EpicFightConditions} 和 {@link InvincibleConditions}
 */
public class InvincibleSkills {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Skill> REGISTRY = DeferredRegister.create(EpicFightRegistries.Keys.SKILL, InvincibleMod.MOD_ID);
    public static final DeferredHolder<Skill, ComboBasicAttack> COMBO_ATTACKS = REGISTRY.register("combo_attacks",
            (key) -> ComboBasicAttack.createComboBasicAttack(ChargeDemo::new)
                    .setCombo(ComboDemo.demo())
                    .setMaxProtectTime(22)
                    .setMaxPressTime(20)
                    .setReserveTime(16)
                    .setShouldDrawGui(true)
                    .build(key, ChargeDemo.class));

    @ApiStatus.Internal
    public static void registerJsonCombos() {
        Path invincibleCombos = FMLPaths.CONFIGDIR.get().resolve("invincible_combos");
        if(!Files.exists(invincibleCombos)){
            try {
                Files.createDirectory(invincibleCombos);

                return;
            } catch (IOException e){
                LOGGER.error("Failed to create invincible_combos folder!", e);
            }
        }
        try (Stream<Path> subDirs = Files.list(invincibleCombos)) {
            subDirs.filter(path -> path.getFileName().toString().toLowerCase().endsWith(".json")).forEach(comboFile -> {
                try {
                    InputStream inputStream = new FileInputStream(comboFile.toFile());
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                    InputStreamReader reader = new InputStreamReader(bufferedInputStream, StandardCharsets.UTF_8);
                    JsonReader jsonReader = new JsonReader(reader);
                    jsonReader.setLenient(true);
                    JsonObject combo = Streams.parse(jsonReader).getAsJsonObject();
                    reader.close();
                    ComboBasicAttack.Builder skillBuilder = ComboJsonLoader.loadCombos(combo);
                    String skillName = combo.get("name").getAsString();
                    REGISTRY.register(skillName, (key) -> {
                        ComboBasicAttack skill = skillBuilder.build(key, ComboBasicAttack.class);
                        CompoundTag params = new CompoundTag();
                        if (combo.has("consumption")) {
                            params.putFloat("consumption", combo.get("consumption").getAsFloat());
                        }
                        if (combo.has("max_stacks")) {
                            params.putInt("max_stacks", combo.get("max_stacks").getAsInt());
                        }
                        skill.loadDatapackParameters(params);
                        return skill;
                    });

                    LOGGER.info("LOAD ADDITIONAL SKILL >> {}", InvincibleMod.MOD_ID + ":" + skillName);
                } catch (IOException | CommandSyntaxException e) {
                    throw new RuntimeException(e);
                }
            });
        } catch (Exception e) {
            LOGGER.error("error when loading combos", e);
            throw new RuntimeException(e);
        }
    }

    @ApiStatus.Internal
    public static void registerJsonSkills() {
        Path invincibleCombos = FMLPaths.CONFIGDIR.get().resolve("invincible_skills");
        if(!Files.exists(invincibleCombos)){
            try {
                Files.createDirectory(invincibleCombos);

                return;
            } catch (IOException e){
                LOGGER.error("Failed to create invincible_skills folder!", e);
            }
        }
        try (Stream<Path> subDirs = Files.list(invincibleCombos)) {
            subDirs.filter(path -> path.getFileName().toString().toLowerCase().endsWith(".json")).forEach(comboFile -> {
                try {
                    InputStream inputStream = new FileInputStream(comboFile.toFile());
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                    InputStreamReader reader = new InputStreamReader(bufferedInputStream, StandardCharsets.UTF_8);
                    JsonReader jsonReader = new JsonReader(reader);
                    jsonReader.setLenient(true);
                    JsonObject combo = Streams.parse(jsonReader).getAsJsonObject();
                    reader.close();
                    SimpleCustomInnateSkill.Builder skillBuilder = SkillJsonLoader.loadSkill(combo);
                    String skillName = combo.get("name").getAsString();
                    REGISTRY.register(skillName, (key) -> {
                        SimpleCustomInnateSkill skill = skillBuilder.build(key, SimpleCustomInnateSkill.class);
                        CompoundTag params = new CompoundTag();
                        if (combo.has("consumption")) {
                            params.putFloat("consumption", combo.get("consumption").getAsFloat());
                        }
                        if (combo.has("max_stacks")) {
                            params.putInt("max_stacks", combo.get("max_stacks").getAsInt());
                        }
                        skill.loadDatapackParameters(params);
                        return skill;
                    });

                    LOGGER.info("LOAD ADDITIONAL SKILL >> {}", InvincibleMod.MOD_ID + ":" + skillName);
                } catch (IOException | CommandSyntaxException e) {
                    throw new RuntimeException(e);
                }
            });
        } catch (Exception e) {
            LOGGER.error("error when loading skills", e);
            throw new RuntimeException(e);
        }
    }

}
