/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.api;

import com.p1nero.invincible.api.events.BaseEvent;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;

public interface EventPresets {
    public static BaseEvent consumeStamina(float consume) {
        return BaseEvent.createServerEvent((playerPatch, entity, invinciblePlayer) -> playerPatch.setStamina(playerPatch.getStamina() - consume));
    }

    public static BaseEvent setStamina(float value) {
        return BaseEvent.createServerEvent((playerPatch, entity, invinciblePlayer) -> playerPatch.setStamina(value));
    }

    public static BaseEvent setStack(int value) {
        return EventPresets.setStack(value, (SkillSlot)SkillSlots.WEAPON_INNATE);
    }

    public static BaseEvent setStack(int value, SkillSlot slot) {
        return BaseEvent.createServerEvent((playerPatch, entity, invinciblePlayer) -> playerPatch.getSkill(slot).getSkill().setStackSynchronize(playerPatch.getSkill(slot), value));
    }

    public static BaseEvent consumeStack(int consume) {
        return EventPresets.consumeStack(consume, (SkillSlot)SkillSlots.WEAPON_INNATE);
    }

    public static BaseEvent consumeStack(int consume, SkillSlot slot) {
        return BaseEvent.createServerEvent((playerPatch, entity, invinciblePlayer) -> {
            SkillContainer container = playerPatch.getSkill(slot);
            container.getSkill().setStackSynchronize(container, Math.max(0, container.getStack() - consume));
        });
    }

    public static BaseEvent addMobEffect(Supplier<Holder<MobEffect>> mobEffectSupplier, int duration, int amplifier, boolean onTarget) {
        return BaseEvent.createServerEvent((playerPatch, entity, invinciblePlayer) -> {
            LivingEntity living = onTarget ? (LivingEntity)playerPatch.getOriginal() : playerPatch.getTarget();
            ((Player)playerPatch.getOriginal()).addEffect(new MobEffectInstance((Holder)mobEffectSupplier.get(), duration, amplifier));
        });
    }

    public static BaseEvent setPhase(int phase) {
        return BaseEvent.create((playerPatch, target, invinciblePlayer) -> invinciblePlayer.setPhase(phase));
    }

    public static BaseEvent resetPhase() {
        return BaseEvent.create((playerPatch, target, invinciblePlayer) -> invinciblePlayer.resetPhase());
    }
}

