/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.api.animation.types;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.p1nero.invincible.attachment.InvincibleAttachments;
import com.p1nero.invincible.attachment.InvincibleEntity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.entity.PartEntity;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.neoevent.playerpatch.AttackPhaseEndEvent;
import yesman.epicfight.api.neoevent.playerpatch.PlayerPatchEvent;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.HitEntityList;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;

public class MultiPhaseAttackAnimation
extends AttackAnimation {
    public MultiPhaseAttackAnimation(float transitionTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends AttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, antic, preDelay, contact, recovery, collider, colliderJoint, accessor, armature);
    }

    public MultiPhaseAttackAnimation(float transitionTime, float antic, float preDelay, float contact, float recovery, InteractionHand hand, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends AttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, antic, preDelay, contact, recovery, hand, collider, colliderJoint, accessor, armature);
    }

    public MultiPhaseAttackAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends AttackAnimation> accessor, AssetAccessor<? extends Armature> armature, AttackAnimation.Phase ... phases) {
        super(transitionTime, accessor, armature, phases);
    }

    public MultiPhaseAttackAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, InteractionHand hand, @Nullable Collider collider, Joint colliderJoint, String path, AssetAccessor<? extends Armature> armature) {
        super(convertTime, antic, preDelay, contact, recovery, hand, collider, colliderJoint, path, armature);
    }

    public void begin(LivingEntityPatch<?> entityPatch) {
        super.begin(entityPatch);
        InvincibleAttachments.getEntity((LivingEntity)entityPatch.getOriginal()).clearMap();
    }

    public void end(LivingEntityPatch<?> entityPatch, AssetAccessor<? extends DynamicAnimation> nextAnimation, boolean isEnd) {
        super.end(entityPatch, nextAnimation, isEnd);
        InvincibleAttachments.getEntity((LivingEntity)entityPatch.getOriginal()).clearMap();
    }

    protected void attackTick(LivingEntityPatch<?> entityPatch, AssetAccessor<? extends DynamicAnimation> animation) {
        AnimationPlayer player = entityPatch.getAnimator().getPlayerFor(animation);
        float elapsedTime = player.getElapsedTime();
        float prevElapsedTime = player.getPrevElapsedTime();
        EntityState state = this.getState(entityPatch, elapsedTime);
        EntityState prevState = this.getState(entityPatch, prevElapsedTime);
        for (AttackAnimation.Phase phase : this.phases) {
            if (elapsedTime > phase.end && prevElapsedTime < phase.end) {
                if (!(entityPatch instanceof ServerPlayerPatch)) continue;
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entityPatch;
                PlayerPatchEvent.postAndFireSkillListeners((PlayerPatchEvent)new AttackPhaseEndEvent(serverPlayerPatch, this.getAccessor(), phase, this.getPhaseOrderByTime(elapsedTime)));
                continue;
            }
            if (elapsedTime < phase.antic || elapsedTime > phase.contact || !prevState.attacking() && !state.attacking() && (prevState.getLevel() >= 2 || state.getLevel() <= 2)) continue;
            if (elapsedTime > phase.antic && !InvincibleAttachments.getEntity((LivingEntity)entityPatch.getOriginal()).isPhaseUsed(phase)) {
                this.onPhaseStart(entityPatch, animation, phase, elapsedTime);
                InvincibleAttachments.getEntity((LivingEntity)entityPatch.getOriginal()).setPhaseUsed(phase);
            }
            this.hurtCollidingEntities(entityPatch, prevElapsedTime, elapsedTime, prevState, state, phase);
        }
    }

    protected void onPhaseStart(LivingEntityPatch<?> entityPatch, AssetAccessor<? extends DynamicAnimation> animation, AttackAnimation.Phase phase, float elapsedTime) {
        entityPatch.onStrike((AttackAnimation)this, phase.hand);
        entityPatch.playSound(this.getSwingSound(entityPatch, phase), 0.0f, 0.0f);
        entityPatch.removeHurtEntities();
    }

    protected void hurtCollidingEntities(LivingEntityPatch<?> entityPatch, float prevElapsedTime, float elapsedTime, EntityState prevState, EntityState state, AttackAnimation.Phase phase) {
        float poseTime;
        float prevPoseTime = prevState.attacking() ? prevElapsedTime : phase.preDelay;
        List list = phase.getCollidingEntities(entityPatch, (AttackAnimation)this, prevPoseTime, poseTime = state.attacking() ? elapsedTime : phase.contact, this.getPlaySpeed(entityPatch, (DynamicAnimation)this));
        if (!list.isEmpty()) {
            HitEntityList hitEntities = new HitEntityList(entityPatch, list, phase.getProperty(AnimationProperty.AttackPhaseProperty.HIT_PRIORITY).orElse(HitEntityList.Priority.DISTANCE));
            while (hitEntities.next()) {
                Entity hit = hitEntities.getEntity();
                LivingEntity trueEntity = this.getTrueEntity(hit);
                InvincibleEntity invincibleEntity = InvincibleAttachments.getEntity((LivingEntity)entityPatch.getOriginal());
                if (trueEntity == null || !trueEntity.isAlive() || invincibleEntity.getCurrentlyHurtEntities(phase).contains(trueEntity) || trueEntity.is(entityPatch.getOriginal()) || !(hit instanceof LivingEntity) && !(hit instanceof PartEntity)) continue;
                EpicFightDamageSource source = this.getEpicFightDamageSource(entityPatch, hit, phase);
                int prevInvulTime = hit.invulnerableTime;
                hit.invulnerableTime = 0;
                AttackResult attackResult = entityPatch.attack(source, hit, phase.hand);
                hit.invulnerableTime = prevInvulTime;
                if (attackResult.resultType.dealtDamage()) {
                    hit.level().playSound(null, hit.getX(), hit.getY(), hit.getZ(), this.getHitSound(entityPatch, phase), hit.getSoundSource(), 1.0f, 1.0f);
                    this.spawnHitParticle((ServerLevel)hit.level(), entityPatch, hit, phase);
                }
                invincibleEntity.getCurrentlyHurtEntities(phase).add((Entity)trueEntity);
                if (!attackResult.resultType.shouldCount()) continue;
                entityPatch.getCurrentlyAttackTriedEntities().add(trueEntity);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderDebugging(PoseStack poseStack, MultiBufferSource buffer, LivingEntityPatch<?> entityPatch, float playbackTime, float partialTicks) {
        AnimationPlayer animPlayer = entityPatch.getAnimator().getPlayerFor((AssetAccessor)this.getAccessor());
        float prevElapsedTime = animPlayer.getPrevElapsedTime();
        float elapsedTime = animPlayer.getElapsedTime();
        for (AttackAnimation.Phase phase : this.phases) {
            Iterator iterator = Arrays.stream(phase.colliders).iterator();
            while (iterator.hasNext()) {
                Pair colliderInfo = (Pair)iterator.next();
                Collider collider = (Collider)colliderInfo.getSecond();
                if (collider == null) {
                    collider = entityPatch.getColliderMatching(phase.hand);
                }
                collider.draw(poseStack, buffer, entityPatch, (AttackAnimation)this, (Joint)colliderInfo.getFirst(), prevElapsedTime, elapsedTime, partialTicks, this.getPlaySpeed(entityPatch, (DynamicAnimation)this));
            }
        }
    }
}

