/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.api.animation.types;

import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.HitEntityList;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class ScanAttackAnimation
extends AttackAnimation {
    public ScanAttackAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, InteractionHand hand, @Nullable Collider collider, Joint colliderJoint, String path, AssetAccessor<? extends Armature> armature) {
        super(convertTime, antic, preDelay, contact, recovery, hand, collider, colliderJoint, path, armature);
    }

    public ScanAttackAnimation(float convertTime, String path, AssetAccessor<? extends Armature> armature, AttackAnimation.Phase ... phases) {
        super(convertTime, path, armature, phases);
    }

    public ScanAttackAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends AttackAnimation> accessor, AssetAccessor<? extends Armature> armature, AttackAnimation.Phase ... phases) {
        super(transitionTime, accessor, armature, phases);
    }

    public ScanAttackAnimation(float transitionTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends AttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, antic, preDelay, contact, recovery, collider, colliderJoint, accessor, armature);
    }

    public ScanAttackAnimation(float transitionTime, float antic, float preDelay, float contact, float recovery, InteractionHand hand, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends AttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, antic, preDelay, contact, recovery, hand, collider, colliderJoint, accessor, armature);
    }

    public void begin(LivingEntityPatch<?> entitypatch) {
        entitypatch.removeHurtEntities();
        super.begin(entitypatch);
    }

    protected Vec3 getCoordVector(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> dynamicAnimation) {
        Vec3 vec3 = super.getCoordVector(entitypatch, dynamicAnimation);
        if (entitypatch.shouldBlockMoving() && this.getProperty((AnimationProperty)AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE).orElse(false).booleanValue()) {
            vec3 = vec3.scale(0.0);
        }
        return vec3;
    }

    protected void attackTick(LivingEntityPatch<?> entityPatch, AssetAccessor<? extends DynamicAnimation> animation) {
        AnimationPlayer player = entityPatch.getAnimator().getPlayerFor((AssetAccessor)this.getAccessor());
        if (player == null) {
            return;
        }
        float prevElapsedTime = player.getPrevElapsedTime();
        float elapsedTime = player.getElapsedTime();
        EntityState prevState = ((DynamicAnimation)animation.get()).getState(entityPatch, prevElapsedTime);
        EntityState state = ((DynamicAnimation)animation.get()).getState(entityPatch, elapsedTime);
        AttackAnimation.Phase phase = this.getPhaseByTime(((DynamicAnimation)animation.get()).isLinkAnimation() ? 0.0f : elapsedTime);
        LivingEntity target = entityPatch.getTarget();
        if (target == null) {
            target = ScanAttackAnimation.getNearestScannedTarget(entityPatch);
        }
        if (target != null && elapsedTime < phase.contact) {
            Vec3 playerPosition = ((LivingEntity)entityPatch.getOriginal()).position();
            Vec3 targetPosition = target.position();
            float yaw = (float)MathUtils.getYRotOfVector((Vec3)targetPosition.subtract(playerPosition));
            entityPatch.setYRot(yaw);
        }
        if (prevState.attacking() || state.attacking() || prevState.getLevel() <= 2 && state.getLevel() > 2) {
            if (!prevState.attacking() || phase != this.getPhaseByTime(prevElapsedTime) && (state.attacking() || prevState.getLevel() <= 2 && state.getLevel() > 2)) {
                entityPatch.onStrike((AttackAnimation)this, phase.hand);
                entityPatch.removeHurtEntities();
            }
            this.searchNearestEntity(entityPatch, prevElapsedTime, elapsedTime, prevState, state, phase);
        }
    }

    @Nullable
    public static LivingEntity getTarget(LivingEntityPatch<?> entityPatch) {
        if (entityPatch.getTarget() != null) {
            return entityPatch.getTarget();
        }
        return ScanAttackAnimation.getNearestScannedTarget(entityPatch);
    }

    @Nullable
    public static LivingEntity getNearestScannedTarget(LivingEntityPatch<?> entityPatch) {
        LivingEntity living;
        if (entityPatch.getCurrentlyAttackTriedEntities().isEmpty()) {
            return null;
        }
        Entity entity = (Entity)entityPatch.getCurrentlyAttackTriedEntities().get(0);
        return entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
    }

    protected void searchNearestEntity(LivingEntityPatch<?> entityPatch, float prevElapsedTime, float elapsedTime, EntityState prevState, EntityState state, AttackAnimation.Phase phase) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        float prevPoseTime = prevState.attacking() ? prevElapsedTime : phase.preDelay;
        float poseTime = state.attacking() ? elapsedTime : phase.contact;
        List list = this.getPhaseByTime(elapsedTime).getCollidingEntities(entityPatch, (AttackAnimation)this, prevPoseTime, poseTime, this.getPlaySpeed(entityPatch, (DynamicAnimation)this));
        if (!list.isEmpty()) {
            HitEntityList hitEntities = new HitEntityList(entityPatch, list, phase.getProperty(AnimationProperty.AttackPhaseProperty.HIT_PRIORITY).orElse(HitEntityList.Priority.DISTANCE));
            while (hitEntities.next()) {
                Entity target = hitEntities.getEntity();
                LivingEntity trueEntity = this.getTrueEntity(target);
                if (trueEntity == null || !trueEntity.isAlive() || entityPatch.getCurrentlyAttackTriedEntities().contains(trueEntity) || entityPatch.isTargetInvulnerable(target) || !(target instanceof LivingEntity) && !(target instanceof PartEntity) || !entity.hasLineOfSight(target)) continue;
                entityPatch.getCurrentlyAttackTriedEntities().add(trueEntity);
                entityPatch.getCurrentlyAttackTriedEntities().sort((e1, e2) -> Float.compare(e1.distanceTo((Entity)entity), e2.distanceTo((Entity)entity)));
            }
        }
    }
}

