/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.api.events;

import com.p1nero.invincible.api.events.BaseConsumer;
import com.p1nero.invincible.attachment.InvincibleAttachments;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class TimeStampedEvent
implements Comparable<TimeStampedEvent> {
    private final float time;
    private final BaseConsumer event;
    private boolean executed = false;

    public boolean isExecuted() {
        return this.executed;
    }

    public void resetExecuted() {
        this.executed = false;
    }

    public TimeStampedEvent(float time, BaseConsumer event) {
        this.time = time;
        this.event = event;
    }

    @Deprecated
    public TimeStampedEvent(float time, Consumer<PlayerPatch<?>> event) {
        this.time = time;
        this.event = (playerPatch, target, invinciblePlayer) -> event.accept(playerPatch);
    }

    public void testAndExecute(PlayerPatch<?> playerPatch, float prevElapsed, float elapsed) {
        if (this.time >= prevElapsed && this.time < elapsed && !playerPatch.isLogicalClient()) {
            this.event.accept(playerPatch, (Entity)playerPatch.getTarget(), InvincibleAttachments.getPlayer((Player)playerPatch.getOriginal()));
            this.executed = true;
        }
    }

    public static TimeStampedEvent createTimeCommandEvent(float time, String command, boolean isTarget) {
        BaseConsumer event = (entityPatch, target, invinciblePlayer) -> {
            Level server = ((Player)entityPatch.getOriginal()).level();
            CommandSourceStack css = ((Player)entityPatch.getOriginal()).createCommandSourceStack().withPermission(2).withSuppressedOutput();
            if (isTarget && entityPatch.getTarget() != null) {
                css = css.withEntity((Entity)entityPatch.getTarget());
            }
            if (server.getServer() != null && entityPatch.getOriginal() != null) {
                server.getServer().getCommands().performPrefixedCommand(css, command);
            }
        };
        return new TimeStampedEvent(time, event);
    }

    @Override
    public int compareTo(@NotNull TimeStampedEvent event) {
        if (this.time == event.time) {
            return 0;
        }
        return this.time > event.time ? 1 : -1;
    }
}

