/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.api.neoforgeevent;

import com.p1nero.invincible.mixin.AnimationManagerAccessor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.event.IModBusEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;

public class DuplicateAnimationRegistryEvent
extends Event
implements IModBusEvent {
    private final List<DuplicateAnimationBuilder> builders = new ArrayList<DuplicateAnimationBuilder>();
    private final Set<String> namespaces = new HashSet<String>();

    public void newBuilder(String namespace, Consumer<DuplicateAnimationBuilder> build) {
        if (this.namespaces.contains(namespace)) {
            throw new IllegalArgumentException("Animation builder namespace '" + namespace + "' already exists!");
        }
        this.namespaces.add(namespace);
        this.builders.add(new DuplicateAnimationBuilder(namespace, build));
    }

    public List<DuplicateAnimationBuilder> getBuilders() {
        return this.builders;
    }

    public static AnimationManagerAccessor getInstance() {
        return (AnimationManagerAccessor)AnimationManager.getInstance();
    }

    public record DuplicateAnimationBuilder(String namespace, Consumer<DuplicateAnimationBuilder> task) {
        public <T extends StaticAnimation> AnimationManager.AnimationAccessor<T> nextAccessor(AnimationManager.AnimationAccessor<?> original, Function<AnimationManager.AnimationAccessor<T>, T> onLoad) {
            ResourceLocation selfName = ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)original.registryName().getPath());
            AnimationManager.AnimationAccessor<T> accessor = DuplicateAnimationAccessorImpl.create(original.registryName(), selfName, DuplicateAnimationRegistryEvent.getInstance().getAnimations().size() + 1, true, onLoad);
            DuplicateAnimationRegistryEvent.getInstance().getAnimationById().put(accessor.id(), accessor);
            DuplicateAnimationRegistryEvent.getInstance().getAnimationByName().put(selfName, accessor);
            DuplicateAnimationRegistryEvent.getInstance().getAnimations().put(accessor, null);
            return accessor;
        }
    }

    public record DuplicateAnimationAccessorImpl<A extends StaticAnimation>(ResourceLocation originalAnimationName, ResourceLocation registryName, int id, boolean inRegistry, Function<AnimationManager.AnimationAccessor<A>, A> onLoad) implements AnimationManager.AnimationAccessor<A>
    {
        private static <A extends StaticAnimation> AnimationManager.AnimationAccessor<A> create(ResourceLocation originalAnimationName, ResourceLocation registryName, int id, boolean inRegistry, Function<AnimationManager.AnimationAccessor<A>, A> onLoad) {
            return new DuplicateAnimationAccessorImpl<A>(originalAnimationName, registryName, id, inRegistry, onLoad);
        }

        public A get() {
            if (!DuplicateAnimationRegistryEvent.getInstance().getAnimations().containsKey(this)) {
                StaticAnimation anim = (StaticAnimation)this.onLoad.apply(this);
                anim.setResourceLocation(this.originalAnimationName.getNamespace(), this.originalAnimationName.getPath());
                DuplicateAnimationRegistryEvent.getInstance().getAnimations().put(this, anim);
            }
            return (A)DuplicateAnimationRegistryEvent.getInstance().getAnimations().get(this);
        }

        @Override
        public String toString() {
            return this.registryName.toString();
        }

        @Override
        public int hashCode() {
            return this.registryName.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof AnimationManager.AnimationAccessor) {
                AnimationManager.AnimationAccessor armatureAccessor = (AnimationManager.AnimationAccessor)obj;
                return this.registryName.equals((Object)armatureAccessor.registryName());
            }
            if (obj instanceof ResourceLocation) {
                ResourceLocation rl = (ResourceLocation)obj;
                return this.registryName.equals((Object)rl);
            }
            if (obj instanceof String) {
                String name = (String)obj;
                return this.registryName.toString().equals(name);
            }
            return false;
        }
    }
}

