/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.attachment;

import com.google.common.collect.ImmutableList;
import com.p1nero.invincible.api.combo.ComboNode;
import com.p1nero.invincible.api.combo.ComboNodeManager;
import com.p1nero.invincible.api.events.BaseEvent;
import com.p1nero.invincible.api.events.TimeStampedEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.world.damagesource.StunType;

public class InvinciblePlayer
implements INBTSerializable<CompoundTag> {
    private ComboNode currentNode = null;
    private ImmutableList<TimeStampedEvent> timeStampedEvents = null;
    private final Map<ItemStack, Integer> cooldownMap = new HashMap<ItemStack, Integer>();
    @Nullable
    private ImmutableList<BaseEvent> dodgeSuccessEvents = null;
    @Nullable
    private ImmutableList<BaseEvent> hitSuccessEvents = null;
    @Nullable
    private ImmutableList<BaseEvent> hurtEvents = null;
    private float playSpeedMultiplier;
    private ValueModifier damageMultiplier;
    private float armorNegation;
    private float impactMultiplier = 1.0f;
    private float hurtDamageMultiplier;
    private StunType stunTypeModifier = null;
    private boolean notCharge;
    private boolean canBeInterrupt = true;
    private int phase;

    public void setItemCooldown(ItemStack item, int cooldown) {
        this.cooldownMap.put(item, cooldown);
    }

    public boolean isItemInCooldown(ItemStack item) {
        if (!this.cooldownMap.containsKey(item)) {
            return false;
        }
        return this.cooldownMap.get(item) >= 0;
    }

    public int getItemCooldown(ItemStack item) {
        if (!this.cooldownMap.containsKey(item)) {
            return 0;
        }
        return this.cooldownMap.get(item);
    }

    public float getArmorNegation() {
        return this.armorNegation;
    }

    public void setArmorNegation(float armorNegation) {
        this.armorNegation = armorNegation;
    }

    public float getHurtDamageMultiplier() {
        return this.hurtDamageMultiplier;
    }

    public void setHurtDamageMultiplier(float hurtDamageMultiplier) {
        this.hurtDamageMultiplier = hurtDamageMultiplier;
    }

    public ValueModifier getDamageMultiplier() {
        return this.damageMultiplier;
    }

    public void setDamageMultiplier(ValueModifier damageMultiplier) {
        this.damageMultiplier = damageMultiplier;
    }

    public float getImpactMultiplier() {
        return this.impactMultiplier;
    }

    public void setImpactMultiplier(float impactMultiplier) {
        this.impactMultiplier = impactMultiplier;
    }

    public StunType getStunTypeModifier() {
        return this.stunTypeModifier;
    }

    public void setStunTypeModifier(StunType stunTypeModifier) {
        this.stunTypeModifier = stunTypeModifier;
    }

    public boolean isCanBeInterrupt() {
        return this.canBeInterrupt;
    }

    public void setCanBeInterrupt(boolean canBeInterrupt) {
        this.canBeInterrupt = canBeInterrupt;
    }

    public void setPhase(int phase) {
        if (phase != 0) {
            this.phase = phase;
        }
    }

    public void resetPhase() {
        this.phase = 0;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setNotCharge(boolean notCharge) {
        this.notCharge = notCharge;
    }

    public boolean isNotCharge() {
        return this.notCharge;
    }

    public void setPlaySpeedMultiplier(float playSpeedMultiplier) {
        this.playSpeedMultiplier = playSpeedMultiplier;
    }

    public float getPlaySpeedMultiplier() {
        return this.playSpeedMultiplier;
    }

    public List<TimeStampedEvent> getTimeEventList() {
        return this.timeStampedEvents;
    }

    @Nullable
    public ImmutableList<BaseEvent> getDodgeSuccessEvents() {
        return this.dodgeSuccessEvents;
    }

    @Nullable
    public ImmutableList<BaseEvent> getHurtEvents() {
        return this.hurtEvents;
    }

    @Nullable
    public ImmutableList<BaseEvent> getHitSuccessEvents() {
        return this.hitSuccessEvents;
    }

    public void setDodgeSuccessEvents(@Nullable ImmutableList<BaseEvent> dodgeSuccessEvents) {
        this.dodgeSuccessEvents = dodgeSuccessEvents;
    }

    public void setHitSuccessEvents(@Nullable ImmutableList<BaseEvent> hitSuccessEvents) {
        this.hitSuccessEvents = hitSuccessEvents;
    }

    public void setHurtEvents(@Nullable ImmutableList<BaseEvent> hurtEvents) {
        this.hurtEvents = hurtEvents;
    }

    public void setTimeStampedEvents(ImmutableList<TimeStampedEvent> event) {
        this.timeStampedEvents = event;
    }

    public void resetTimeEvents() {
        this.timeStampedEvents = null;
    }

    public ComboNode getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(ComboNode currentNode) {
        this.currentNode = currentNode;
    }

    public void clear() {
        this.playSpeedMultiplier = 0.0f;
        this.damageMultiplier = null;
        this.impactMultiplier = 0.0f;
        this.hurtDamageMultiplier = 0.0f;
        this.stunTypeModifier = null;
        this.canBeInterrupt = true;
        this.notCharge = false;
        this.timeStampedEvents = null;
        this.dodgeSuccessEvents = null;
        this.hitSuccessEvents = null;
        this.hurtEvents = null;
    }

    public CompoundTag saveNBTData(CompoundTag tag) {
        tag.putBoolean("notCharge", this.notCharge);
        tag.putFloat("playSpeed", this.playSpeedMultiplier);
        if (this.currentNode != null) {
            tag.putInt("currentNodeId", this.currentNode.getId());
        }
        return tag;
    }

    public void loadNBTData(CompoundTag tag) {
        this.notCharge = tag.getBoolean("notCharge");
        this.playSpeedMultiplier = tag.getFloat("playSpeed");
        int id = tag.getInt("currentNodeId");
        if (id != 0) {
            this.currentNode = ComboNodeManager.get(id);
        }
    }

    public void copyFrom(InvinciblePlayer old) {
        this.currentNode = old.currentNode;
    }

    public void tick() {
    }

    public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveNBTData(tag);
        return tag;
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, @NotNull CompoundTag compoundTag) {
        this.loadNBTData(compoundTag);
    }
}

