/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.client;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.p1nero.invincible.InvincibleConfig;
import com.p1nero.invincible.api.Side;
import com.p1nero.invincible.api.combo.ComboNode;
import com.p1nero.invincible.api.combo.ComboType;
import com.p1nero.invincible.attachment.InvincibleAttachments;
import com.p1nero.invincible.attachment.InvinciblePlayer;
import com.p1nero.invincible.client.InvincibleKeyMappings;
import com.p1nero.invincible.compat.controlify.ControlifyCompat;
import com.p1nero.invincible.compat.controlify.ControlifyModAvailability;
import com.p1nero.invincible.gameassets.InvincibleSkillDataKeys;
import com.p1nero.invincible.skill.ComboBasicAttack;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.api.bind.InputBindingSupplier;
import dev.isxander.controlify.controller.ControllerEntity;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.api.neoevent.playerpatch.SkillCastEvent;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPSkillRequest;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

@EventBusSubscriber(modid="invincible", value={Dist.CLIENT})
public class InputManager {
    private static int reserveCounter;
    private static long lastInputTime;
    private static long inputInterval;
    private static final BiMap<ComboType, @NotNull KeyMapping> TYPE_KEY_MAP;
    private static BiMap<KeyMapping, ComboType> KEY_TYPE_MAP;
    private static final Map<Integer, Integer> KEY_STATE_CACHE;
    private static final Queue<Integer> INPUT_QUEUE;
    private static final List<CPSkillRequest> ON_PRESS_PACKETS;
    private static ComboNode currentNode;

    public static ComboNode getCurrentNode() {
        return currentNode;
    }

    public static void init() {
        InputManager.register(ComboNode.ComboTypes.KEY_1, InvincibleKeyMappings.KEY1);
        InputManager.register(ComboNode.ComboTypes.KEY_2, InvincibleKeyMappings.KEY2);
        InputManager.register(ComboNode.ComboTypes.KEY_3, InvincibleKeyMappings.KEY3);
        InputManager.register(ComboNode.ComboTypes.KEY_4, InvincibleKeyMappings.KEY4);
        InputManager.register(ComboNode.ComboTypes.DODGE, EpicFightKeyMappings.DODGE);
        InputManager.register(ComboNode.ComboTypes.WEAPON_INNATE, EpicFightKeyMappings.WEAPON_INNATE_SKILL);
    }

    public static void register(ComboType type, KeyMapping keyMapping) {
        TYPE_KEY_MAP.put((Object)type, (Object)keyMapping);
        KEY_STATE_CACHE.put(keyMapping.getKey().getValue(), 0);
        KEY_TYPE_MAP = TYPE_KEY_MAP.inverse();
    }

    public static int getPressedTickFor(ComboType comboType) {
        return InputManager.testPressedTime(comboType);
    }

    @Nullable
    public static ComboBasicAttack getComboBasicSkill() {
        LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
        if (localPlayerPatch == null) {
            return null;
        }
        Skill skill = localPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getSkill();
        if (skill instanceof ComboBasicAttack) {
            ComboBasicAttack comboBasicAttack = (ComboBasicAttack)skill;
            return comboBasicAttack;
        }
        return null;
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        InputManager.handleKeyBinds();
        InputManager.maybeHandleControlifyRelease();
        LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
        if (localPlayerPatch != null && InputManager.shouldHandleInput()) {
            if (reserveCounter > 0) {
                if (InputManager.tryRequestSkillExecute(false) || --reserveCounter == 0) {
                    InputManager.clearReservedKeys();
                    InputManager.clearKeyCache();
                }
            } else {
                InputManager.handlePressing();
            }
            if (localPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getSkill() instanceof ComboBasicAttack) {
                Options options = Minecraft.getInstance().options;
                SkillDataManager manager = InputManager.getDataManager(localPlayerPatch);
                InputManager.checkDirectionKeyDown(manager, InvincibleSkillDataKeys.UP, options.keyUp);
                InputManager.checkDirectionKeyDown(manager, InvincibleSkillDataKeys.DOWN, options.keyDown);
                InputManager.checkDirectionKeyDown(manager, InvincibleSkillDataKeys.LEFT, options.keyLeft);
                InputManager.checkDirectionKeyDown(manager, InvincibleSkillDataKeys.RIGHT, options.keyRight);
                AtomicBoolean flag = new AtomicBoolean(false);
                KEY_STATE_CACHE.forEach((key, time) -> {
                    if (time != 0) {
                        flag.set(true);
                    }
                });
                if (flag.get() != ((Boolean)manager.getDataValue(InvincibleSkillDataKeys.ANY_KEY_DOWN)).booleanValue()) {
                    manager.setDataSync(InvincibleSkillDataKeys.ANY_KEY_DOWN, (Object)flag.get());
                }
            }
            if (!localPlayerPatch.getEntityState().inaction()) {
                ON_PRESS_PACKETS.forEach(x$0 -> EpicFightNetworkManager.sendToServer((CustomPacketPayload)x$0, (CustomPacketPayload[])new CustomPacketPayload[0]));
                ON_PRESS_PACKETS.clear();
            }
        }
        while (INPUT_QUEUE.size() > 2) {
            Integer keyId = INPUT_QUEUE.poll();
            if (INPUT_QUEUE.contains(keyId)) continue;
            KEY_STATE_CACHE.put(keyId, 0);
        }
    }

    public static SkillDataManager getDataManager(@NotNull LocalPlayerPatch localPlayerPatch) {
        return localPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager();
    }

    private static void checkDirectionKeyDown(SkillDataManager manager, DeferredHolder<SkillDataKey<?>, ? extends SkillDataKey<Boolean>> skillDataKey, KeyMapping key) {
        LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
        if (((Boolean)manager.getDataValue(skillDataKey)).booleanValue() != key.isDown() && localPlayerPatch != null) {
            manager.setDataSync(skillDataKey, (Object)key.isDown());
        }
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseButton.Pre event) {
        InputManager.onVanillaMouseOrKeyInput(event.getAction(), event.getButton());
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        InputManager.onVanillaMouseOrKeyInput(event.getAction(), event.getKey());
    }

    private static void onVanillaMouseOrKeyInput(int action, int key) {
        if (action == 0 && INPUT_QUEUE.contains(key)) {
            InputManager.handleRelease();
        }
    }

    private static void maybeHandleControlifyRelease() {
        if (!ControlifyModAvailability.isModInstalled()) {
            return;
        }
        Optional maybeController = ControlifyApi.get().getCurrentController();
        if (maybeController.isEmpty()) {
            return;
        }
        ControllerEntity controller = (ControllerEntity)maybeController.get();
        for (KeyMapping keyMapping : TYPE_KEY_MAP.values()) {
            InputBindingSupplier inputBindingSupplier = ControlifyCompat.getInputBindingFromKeyMapping(keyMapping);
            if (inputBindingSupplier == null || !inputBindingSupplier.on(controller).justReleased()) continue;
            InputManager.handleRelease();
        }
    }

    private static void handleRelease() {
        if (InputManager.shouldHandleInput()) {
            InputManager.tryRequestSkillExecute(true);
        }
    }

    private static boolean shouldHandleInput() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.screen != null || minecraft.isPaused()) {
            return false;
        }
        LocalPlayerPatch playerPatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerPatch == null) {
            return false;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        ItemStack mainHandItem = ((LocalPlayer)playerPatch.getOriginal()).getMainHandItem();
        EpicFightCapabilities.getItemCapability((ItemStack)mainHandItem).ifPresent(capabilityItem -> atomicBoolean.set(capabilityItem.getInnateSkill((PlayerPatch)playerPatch, mainHandItem) instanceof ComboBasicAttack));
        if (!atomicBoolean.get()) {
            InputManager.clearKeyCache();
            InputManager.clearReservedKeys();
        }
        return atomicBoolean.get();
    }

    private static void handleKeyBinds() {
        for (KeyMapping keyMapping : TYPE_KEY_MAP.values()) {
            int keyId = keyMapping.getKey().getValue();
            while (keyMapping.consumeClick()) {
                if (!InputManager.shouldHandleInput()) continue;
                InputManager.handleOnPress(keyMapping);
                if (!INPUT_QUEUE.contains(keyId)) {
                    INPUT_QUEUE.add(keyId);
                }
                if (KEY_STATE_CACHE.getOrDefault(keyId, 0) <= 0) {
                    KEY_STATE_CACHE.put(keyId, 1);
                }
                InputManager.clearReservedKeys();
            }
        }
    }

    private static void handleOnPress(KeyMapping keyMapping) {
        ComboType type = (ComboType)KEY_TYPE_MAP.get((Object)keyMapping);
        CPSkillRequest packet = new CPSkillRequest((SkillSlot)SkillSlots.WEAPON_INNATE, new CompoundTag());
        if (type == null || packet.arguments() == null) {
            return;
        }
        packet.arguments().putInt("type_id", type.universalOrdinal());
        packet.arguments().putBoolean("on_press", true);
        ON_PRESS_PACKETS.add(packet);
    }

    private static void handlePressing() {
        AtomicBoolean shouldExecute = new AtomicBoolean(false);
        int maxPressTick = (Integer)InvincibleConfig.MAX_PRESS_TICK.get();
        ComboBasicAttack comboBasicAttack = InputManager.getComboBasicSkill();
        if (comboBasicAttack != null) {
            maxPressTick = comboBasicAttack.getMaxPressTime();
        }
        int finalMaxPressTick = maxPressTick;
        KEY_STATE_CACHE.forEach((keyId, integer) -> {
            if (integer > 0) {
                KEY_STATE_CACHE.put((Integer)keyId, integer + 1);
                if (integer > finalMaxPressTick) {
                    shouldExecute.set(true);
                }
            }
        });
        if (shouldExecute.get()) {
            InputManager.tryRequestSkillExecute(true);
        }
    }

    public static void clearKeyCache() {
        KEY_STATE_CACHE.forEach((keyId, aInt) -> KEY_STATE_CACHE.put((Integer)keyId, 0));
        INPUT_QUEUE.clear();
    }

    public static void clearReservedKeys() {
        reserveCounter = -1;
    }

    public static void setReserveCounter(int reserveCounter) {
        InputManager.reserveCounter = reserveCounter;
    }

    public static void setReserve(SkillSlot reserve) {
        reserveCounter = (Integer)InvincibleConfig.RESERVE_TICK.get();
        ComboBasicAttack comboBasicAttack = InputManager.getComboBasicSkill();
        if (comboBasicAttack != null) {
            reserveCounter = comboBasicAttack.getMaxReserveTime();
        }
    }

    public static boolean tryRequestSkillExecute(boolean shouldReserve) {
        SkillSlots slot = SkillSlots.WEAPON_INNATE;
        LocalPlayerPatch executor = ClientEngine.getInstance().getPlayerPatch();
        if (executor != null && executor.getPlayerMode() == PlayerPatch.PlayerMode.EPICFIGHT) {
            if (InputManager.sendExecuteRequest(executor, executor.getSkill((SkillSlot)slot)).shouldReserveKey()) {
                if (shouldReserve) {
                    InputManager.setReserve((SkillSlot)slot);
                }
                return false;
            }
            InputManager.clearKeyCache();
            return true;
        }
        return false;
    }

    public static SkillCastEvent sendExecuteRequest(LocalPlayerPatch executor, SkillContainer container) {
        SkillCastEvent event = new SkillCastEvent((PlayerPatch)executor, container, new CompoundTag());
        InvinciblePlayer invinciblePlayer = InvincibleAttachments.getPlayer((Player)executor.getOriginal());
        currentNode = invinciblePlayer.getCurrentNode();
        if (container.canUse((PlayerPatch)executor, event)) {
            for (CPSkillRequest packet : InputManager.getAvailablePackets(container)) {
                EpicFightNetworkManager.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        return event;
    }

    public static List<CPSkillRequest> getAvailablePackets(SkillContainer container) {
        ArrayList<CPSkillRequest> list = new ArrayList<CPSkillRequest>();
        ArrayList<ComboType> typeList = new ArrayList<ComboType>(ComboType.ENUM_MANAGER.universalValues().stream().toList());
        typeList.sort(Comparator.comparingInt(comboType -> -1 * comboType.getSubTypes().size()));
        for (ComboType comboType2 : typeList) {
            int pressedTime = InputManager.testPressedTime(comboType2);
            if (pressedTime <= 0 || !InputManager.testClientConditions(comboType2)) continue;
            inputInterval = System.currentTimeMillis() - lastInputTime;
            list.add(InputManager.getExecutePacket(container.getSlot(), comboType2, pressedTime, inputInterval));
            if (comboType2.getSubTypes().isEmpty()) continue;
            break;
        }
        if (!list.isEmpty()) {
            lastInputTime = System.currentTimeMillis();
        }
        return list;
    }

    public static CPSkillRequest getExecutePacket(SkillSlot slot, ComboType comboType, int pressedTime, long inputInterval) {
        CPSkillRequest packet = new CPSkillRequest(slot, new CompoundTag());
        packet.arguments().putInt("type_id", comboType.universalOrdinal());
        packet.arguments().putInt("pressed_time", pressedTime);
        packet.arguments().putLong("pressed_interval", inputInterval);
        return packet;
    }

    public static int testPressedTime(ComboType comboType) {
        if (comboType.getSubTypes().isEmpty()) {
            KeyMapping keyMapping = (KeyMapping)TYPE_KEY_MAP.get((Object)comboType);
            if (keyMapping == null || !KEY_STATE_CACHE.containsKey(keyMapping.getKey().getValue())) {
                return 0;
            }
            int pressedTime = KEY_STATE_CACHE.getOrDefault(keyMapping.getKey().getValue(), 0);
            return Math.max(pressedTime, 0);
        }
        int maxPressedTime = 0;
        for (ComboType subType : comboType.getSubTypes()) {
            int currentPressedTime = InputManager.testPressedTime(subType);
            if (currentPressedTime == 0) {
                return 0;
            }
            if (currentPressedTime <= maxPressedTime) continue;
            maxPressedTime = currentPressedTime;
        }
        return maxPressedTime;
    }

    public static boolean testClientConditions(ComboType comboType) {
        if (currentNode == null) {
            return false;
        }
        ComboNode next = currentNode.getNext(comboType);
        if (next == null) {
            return false;
        }
        for (Condition condition : next.getConditions(Side.CLIENT, Side.LOCAL_CLIENT, Side.BOTH)) {
            LocalPlayerPatch localPlayerPatch;
            if (condition.predicate((Object)(localPlayerPatch = ClientEngine.getInstance().getPlayerPatch()))) continue;
            return false;
        }
        return true;
    }

    static {
        TYPE_KEY_MAP = HashBiMap.create();
        KEY_TYPE_MAP = HashBiMap.create();
        KEY_STATE_CACHE = new HashMap<Integer, Integer>();
        INPUT_QUEUE = new ArrayDeque<Integer>();
        ON_PRESS_PACKETS = new ArrayList<CPSkillRequest>();
    }
}

