/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.utils.LevelUtil;
import yesman.epicfight.registry.entries.EpicFightParticles;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;

public class EffectCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"invincible").then(((LiteralArgumentBuilder)Commands.literal((String)"entityAfterImage").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entities()).executes(context -> {
            for (Entity entity : EntityArgument.getEntities((CommandContext)context, (String)"entity")) {
                EntityPatch entityPatch = EpicFightCapabilities.getEntityPatch((Entity)entity, EntityPatch.class);
                if (entityPatch == null) continue;
                ((CommandSourceStack)context.getSource()).getLevel().sendParticles((ParticleOptions)((SimpleParticleType)EpicFightParticles.ENTITY_AFTER_IMAGE.get()), entity.getX(), entity.getY(), entity.getZ(), 1, (double)entity.getId(), 1.0, 1.0, (double)entity.getId());
            }
            return 0;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"groundSlam").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(Commands.argument((String)"entity", (ArgumentType)EntityArgument.entity()).then(Commands.argument((String)"radius", (ArgumentType)DoubleArgumentType.doubleArg()).then(Commands.argument((String)"noSound", (ArgumentType)BoolArgumentType.bool()).then(Commands.argument((String)"noParticle", (ArgumentType)BoolArgumentType.bool()).then(((RequiredArgumentBuilder)Commands.argument((String)"hurtEntities", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            LivingEntity livingEntity;
            Entity entity = EntityArgument.getEntity((CommandContext)context, (String)"entity");
            LevelUtil.circleSlamFracture((LivingEntity)(entity instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : null), (Level)entity.level(), (Vec3)entity.position().add(0.0, -1.0, 0.0), (double)DoubleArgumentType.getDouble((CommandContext)context, (String)"radius"), (boolean)BoolArgumentType.getBool((CommandContext)context, (String)"noSound"), (boolean)BoolArgumentType.getBool((CommandContext)context, (String)"noParticle"), (boolean)BoolArgumentType.getBool((CommandContext)context, (String)"hurtEntities"));
            return 0;
        })).then(Commands.argument((String)"position", (ArgumentType)Vec3Argument.vec3()).executes(context -> {
            LivingEntity livingEntity;
            Entity entity = EntityArgument.getEntity((CommandContext)context, (String)"entity");
            LevelUtil.circleSlamFracture((LivingEntity)(entity instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : null), (Level)entity.level(), (Vec3)Vec3Argument.getVec3((CommandContext)context, (String)"position"), (double)DoubleArgumentType.getDouble((CommandContext)context, (String)"radius"), (boolean)BoolArgumentType.getBool((CommandContext)context, (String)"noSound"), (boolean)BoolArgumentType.getBool((CommandContext)context, (String)"noParticle"), (boolean)BoolArgumentType.getBool((CommandContext)context, (String)"hurtEntities"));
            return 0;
        })))))))));
    }
}

