/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.command;

import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.p1nero.invincible.skill.ComboBasicAttack;
import com.p1nero.invincible.skill.SimpleCustomInnateSkill;
import com.p1nero.invincible.skill.data.ComboJsonLoader;
import com.p1nero.invincible.skill.data.SkillJsonLoader;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLPaths;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import yesman.epicfight.skill.Skill;

public class ReloadCommands {
    public static final Logger LOGGER = LogUtils.getLogger();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
    }

    @ApiStatus.Internal
    public static void reregisterJsonCombos(MappedRegistry<Skill> registry) {
        Path invincibleCombos = FMLPaths.CONFIGDIR.get().resolve("invincible_combos");
        if (!Files.exists(invincibleCombos, new LinkOption[0])) {
            try {
                Files.createDirectory(invincibleCombos, new FileAttribute[0]);
                return;
            }
            catch (IOException e) {
                LOGGER.error("Failed to create invincible_combos folder!", (Throwable)e);
            }
        }
        try (Stream<Path> subDirs = Files.list(invincibleCombos);){
            subDirs.filter(path -> path.getFileName().toString().toLowerCase().endsWith(".json")).forEach(comboFile -> {
                try {
                    FileInputStream inputStream = new FileInputStream(comboFile.toFile());
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                    InputStreamReader reader = new InputStreamReader((InputStream)bufferedInputStream, StandardCharsets.UTF_8);
                    JsonReader jsonReader = new JsonReader((Reader)reader);
                    jsonReader.setLenient(true);
                    JsonObject combo = Streams.parse((JsonReader)jsonReader).getAsJsonObject();
                    reader.close();
                    ComboBasicAttack.Builder skillBuilder = ComboJsonLoader.loadCombos(combo);
                    String skillName = combo.get("name").getAsString();
                    ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)"invincible", (String)skillName);
                    ComboBasicAttack skill = (ComboBasicAttack)skillBuilder.build(key, ComboBasicAttack.class);
                    CompoundTag params = new CompoundTag();
                    if (combo.has("consumption")) {
                        params.putFloat("consumption", combo.get("consumption").getAsFloat());
                    }
                    if (combo.has("max_stacks")) {
                        params.putInt("max_stacks", combo.get("max_stacks").getAsInt());
                    }
                    skill.loadDatapackParameters(params);
                    Registry.register((Registry)registry, (ResourceLocation)key, (Object)((Object)skill));
                    LOGGER.info("LOAD ADDITIONAL SKILL >> {}", (Object)("invincible:" + skillName));
                }
                catch (CommandSyntaxException | IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("error when loading combos", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @ApiStatus.Internal
    public static void reregisterJsonSkills(MappedRegistry<Skill> registry) {
        Path invincibleCombos = FMLPaths.CONFIGDIR.get().resolve("invincible_skills");
        if (!Files.exists(invincibleCombos, new LinkOption[0])) {
            try {
                Files.createDirectory(invincibleCombos, new FileAttribute[0]);
                return;
            }
            catch (IOException e) {
                LOGGER.error("Failed to create invincible_skills folder!", (Throwable)e);
            }
        }
        try (Stream<Path> subDirs = Files.list(invincibleCombos);){
            subDirs.filter(path -> path.getFileName().toString().toLowerCase().endsWith(".json")).forEach(comboFile -> {
                try {
                    FileInputStream inputStream = new FileInputStream(comboFile.toFile());
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                    InputStreamReader reader = new InputStreamReader((InputStream)bufferedInputStream, StandardCharsets.UTF_8);
                    JsonReader jsonReader = new JsonReader((Reader)reader);
                    jsonReader.setLenient(true);
                    JsonObject combo = Streams.parse((JsonReader)jsonReader).getAsJsonObject();
                    reader.close();
                    SimpleCustomInnateSkill.Builder skillBuilder = SkillJsonLoader.loadSkill(combo);
                    String skillName = combo.get("name").getAsString();
                    ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)"invincible", (String)skillName);
                    SimpleCustomInnateSkill skill = (SimpleCustomInnateSkill)skillBuilder.build(key, SimpleCustomInnateSkill.class);
                    CompoundTag params = new CompoundTag();
                    if (combo.has("consumption")) {
                        params.putFloat("consumption", combo.get("consumption").getAsFloat());
                    }
                    if (combo.has("max_stacks")) {
                        params.putInt("max_stacks", combo.get("max_stacks").getAsInt());
                    }
                    skill.loadDatapackParameters(params);
                    Registry.register((Registry)registry, (ResourceLocation)key, (Object)((Object)skill));
                    LOGGER.info("LOAD ADDITIONAL SKILL >> {}", (Object)("invincible:" + skillName));
                }
                catch (CommandSyntaxException | IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("error when loading skills", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

