/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.compat.controlify;

import com.p1nero.invincible.InvincibleMod;
import com.p1nero.invincible.client.InvincibleKeyMappings;
import com.p1nero.invincible.compat.controlify.ControlifyModAvailability;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.api.bind.ControlifyBindApi;
import dev.isxander.controlify.api.bind.InputBindingSupplier;
import dev.isxander.controlify.api.entrypoint.ControlifyEntrypoint;
import dev.isxander.controlify.api.entrypoint.InitContext;
import dev.isxander.controlify.api.entrypoint.PreInitContext;
import dev.isxander.controlify.bindings.BindContext;
import dev.isxander.controlify.bindings.RadialIcons;
import dev.isxander.controlify.utils.render.Blit;
import dev.isxander.controlify.utils.render.CGuiPose;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.client.ClientEngine;

public class ControlifyCompat
implements ControlifyEntrypoint {
    private static InputBindingSupplier primaryAction;
    private static InputBindingSupplier secondaryAction;
    private static InputBindingSupplier specialAbility1;
    private static InputBindingSupplier specialAbility2;
    private static final BindContext IN_GAME_EPIC_FIGHT_CONTEXT;

    @Nullable
    public static InputBindingSupplier getInputBindingFromKeyMapping(@NotNull KeyMapping keyMapping) {
        if (keyMapping == InvincibleKeyMappings.KEY1) {
            return primaryAction;
        }
        if (keyMapping == InvincibleKeyMappings.KEY2) {
            return secondaryAction;
        }
        if (keyMapping == InvincibleKeyMappings.KEY3) {
            return specialAbility1;
        }
        if (keyMapping == InvincibleKeyMappings.KEY4) {
            return specialAbility2;
        }
        return null;
    }

    public void onControllersDiscovered(ControlifyApi controlify) {
    }

    public void onControlifyInit(InitContext context) {
    }

    public void onControlifyPreInit(PreInitContext context) {
        ControlifyModAvailability.setIsModInstalled(true);
        ControlifyBindApi registrar = ControlifyBindApi.get();
        ControlifyCompat.registerCustomRadialIcons();
        registrar.registerBindContext(IN_GAME_EPIC_FIGHT_CONTEXT);
        ControlifyCompat.registerInputBindings(registrar);
    }

    private static void registerInputBindings(ControlifyBindApi registrar) {
        primaryAction = registrar.registerBinding(builder -> builder.id(InvincibleMod.rl("primary_action")).category(ComponentConstants.COMMON_CATEGORY).allowedContexts(new BindContext[]{IN_GAME_EPIC_FIGHT_CONTEXT}).name(ComponentConstants.PRIMARY_ACTION).description(ComponentConstants.PRIMARY_ACTION_DESCRIPTION).addKeyCorrelation(InvincibleKeyMappings.KEY1).keyEmulation(InvincibleKeyMappings.KEY1));
        secondaryAction = registrar.registerBinding(builder -> builder.id(InvincibleMod.rl("secondary_action")).category(ComponentConstants.COMMON_CATEGORY).allowedContexts(new BindContext[]{IN_GAME_EPIC_FIGHT_CONTEXT}).name(ComponentConstants.SECONDARY_ACTION).description(ComponentConstants.SECONDARY_ACTION_DESCRIPTION).addKeyCorrelation(InvincibleKeyMappings.KEY2).keyEmulation(InvincibleKeyMappings.KEY2));
        specialAbility1 = registrar.registerBinding(builder -> builder.id(InvincibleMod.rl("special_ability_1")).category(ComponentConstants.COMMON_CATEGORY).allowedContexts(new BindContext[]{IN_GAME_EPIC_FIGHT_CONTEXT}).name(ComponentConstants.SPECIAL_ABILITY_1).description(ComponentConstants.SPECIAL_ABILITY_1_DESCRIPTION).addKeyCorrelation(InvincibleKeyMappings.KEY3).keyEmulation(InvincibleKeyMappings.KEY3).radialCandidate(InvincibleRadialIcons.COMBO_ATTACKS.getId()));
        specialAbility2 = registrar.registerBinding(builder -> builder.id(InvincibleMod.rl("special_ability_2")).category(ComponentConstants.COMMON_CATEGORY).allowedContexts(new BindContext[]{IN_GAME_EPIC_FIGHT_CONTEXT}).name(ComponentConstants.SPECIAL_ABILITY_2).description(ComponentConstants.SPECIAL_ABILITY_2_DESCRIPTION).addKeyCorrelation(InvincibleKeyMappings.KEY4).keyEmulation(InvincibleKeyMappings.KEY4).radialCandidate(InvincibleRadialIcons.COMBO_ATTACKS.getId()));
    }

    private static void registerCustomRadialIcons() {
        for (InvincibleRadialIcons icon : InvincibleRadialIcons.values()) {
            ResourceLocation location = icon.getId();
            RadialIcons.registerIcon((ResourceLocation)location, (graphics, x, y, tickDelta) -> {
                CGuiPose pose = CGuiPose.ofPush((GuiGraphics)graphics);
                pose.translate((float)x, (float)y);
                pose.scale(0.5f, 0.5f);
                Blit.tex((GuiGraphics)graphics, (ResourceLocation)location, (int)0, (int)0, (int)0, (int)0, (int)32, (int)32, (int)32, (int)32);
                pose.pop();
            });
        }
    }

    static {
        IN_GAME_EPIC_FIGHT_CONTEXT = new BindContext(InvincibleMod.rl("epicfight_combat"), mc -> {
            boolean isInGame = mc.screen == null && mc.level != null && mc.player != null;
            return isInGame && ClientEngine.getInstance().isEpicFightMode();
        });
    }

    private static enum InvincibleRadialIcons {
        COMBO_ATTACKS(InvincibleMod.rl("textures/gui/skills/weapon_innate/combo_attacks.png"));

        @NotNull
        private final ResourceLocation id;

        private InvincibleRadialIcons(ResourceLocation id) {
            this.id = id;
        }

        @NotNull
        public ResourceLocation getId() {
            return this.id;
        }
    }

    private static class ComponentConstants {
        private static final Component COMMON_CATEGORY = Component.translatable((String)"key.invincible.category");
        private static final Component PRIMARY_ACTION = Component.translatable((String)"key.invincible.key1");
        private static final Component SECONDARY_ACTION = Component.translatable((String)"key.invincible.key2");
        private static final Component SPECIAL_ABILITY_1 = Component.translatable((String)"key.invincible.key3");
        private static final Component SPECIAL_ABILITY_2 = Component.translatable((String)"key.invincible.key4");
        private static final Component PRIMARY_ACTION_DESCRIPTION = Component.translatable((String)"key.invincible.key1.description");
        private static final Component SECONDARY_ACTION_DESCRIPTION = Component.translatable((String)"key.invincible.key2.description");
        private static final Component SPECIAL_ABILITY_1_DESCRIPTION = Component.translatable((String)"key.invincible.key3.description");
        private static final Component SPECIAL_ABILITY_2_DESCRIPTION = Component.translatable((String)"key.invincible.key4.description");

        private ComponentConstants() {
        }
    }
}

