/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.conditions;

import com.p1nero.invincible.gameassets.InvincibleSkillDataKeys;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class CooldownCondition
implements Condition<ServerPlayerPatch> {
    private boolean inCooldown;

    public CooldownCondition(boolean inCooldown) {
        this.inCooldown = inCooldown;
    }

    public CooldownCondition() {
    }

    public Condition<ServerPlayerPatch> read(CompoundTag compoundTag) {
        if (!compoundTag.contains("in_cooldown")) {
            throw new IllegalArgumentException("custom cooldown condition error: in_cooldown not specified!");
        }
        this.inCooldown = compoundTag.getBoolean("in_cooldown");
        return this;
    }

    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("in_cooldown", this.inCooldown);
        return tag;
    }

    public boolean predicate(ServerPlayerPatch serverPlayerPatch) {
        SkillDataManager manager = serverPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager();
        return this.inCooldown == (Integer)manager.getDataValue(InvincibleSkillDataKeys.COOLDOWN) > 0;
    }

    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        return null;
    }
}

