/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.conditions;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class EnchantmentCondition
implements Condition<ServerPlayerPatch> {
    private boolean isMainHand;
    private ResourceKey<Enchantment> effectKey;
    private int min;
    private int max;

    public EnchantmentCondition() {
    }

    public EnchantmentCondition(boolean isMainHand, ResourceLocation effectKey, int min, int max) {
        this.isMainHand = isMainHand;
        this.effectKey = EnchantmentCondition.createKey(effectKey);
        this.min = min;
        this.max = max;
    }

    public EnchantmentCondition(boolean isMainHand, ResourceLocation effectKey, int level) {
        this.isMainHand = isMainHand;
        this.effectKey = EnchantmentCondition.createKey(effectKey);
        this.min = level;
        this.max = level;
    }

    private static ResourceKey<Enchantment> createKey(ResourceLocation resourceLocation) {
        return ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)resourceLocation);
    }

    public Condition<ServerPlayerPatch> read(CompoundTag compoundTag) {
        this.isMainHand = compoundTag.getBoolean("is_main_hand");
        this.effectKey = EnchantmentCondition.createKey(ResourceLocation.parse((String)compoundTag.getString("enchantment")));
        this.min = compoundTag.getInt("min");
        this.max = compoundTag.getInt("max");
        return this;
    }

    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("is_main_hand", this.isMainHand);
        tag.putString("enchantment", this.effectKey.toString());
        tag.putInt("min", this.min);
        tag.putInt("max", this.max);
        return tag;
    }

    public boolean predicate(ServerPlayerPatch serverPlayerPatch) {
        RegistryAccess registryAccess = serverPlayerPatch.getLevel().registryAccess();
        int level = EnchantmentHelper.getTagEnchantmentLevel((Holder)registryAccess.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(this.effectKey), (ItemStack)(this.isMainHand ? ((ServerPlayer)serverPlayerPatch.getOriginal()).getMainHandItem() : ((ServerPlayer)serverPlayerPatch.getOriginal()).getOffhandItem()));
        return level >= this.min && level <= this.max;
    }

    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        return null;
    }
}

