/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.conditions;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class MobEffectCondition
implements Condition<ServerPlayerPatch> {
    private boolean isTarget;
    private Holder<MobEffect> effectSupplier;
    private int min;
    private int max;

    public MobEffectCondition() {
    }

    public MobEffectCondition(boolean isTarget, Holder<MobEffect> effectSupplier, int min, int max) {
        this.isTarget = isTarget;
        this.effectSupplier = effectSupplier;
        this.min = min;
        this.max = max;
    }

    public MobEffectCondition(boolean isTarget, Holder<MobEffect> effectSupplier, int level) {
        this.isTarget = isTarget;
        this.effectSupplier = effectSupplier;
        this.min = level;
        this.max = level;
    }

    public Condition<ServerPlayerPatch> read(CompoundTag compoundTag) {
        this.isTarget = compoundTag.getBoolean("is_target");
        this.effectSupplier = (Holder)BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.parse((String)compoundTag.getString("effect"))).orElseThrow();
        this.min = compoundTag.getInt("min");
        this.max = compoundTag.getInt("max");
        return this;
    }

    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("is_target", this.isTarget);
        tag.putString("effect", Objects.requireNonNull(BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)this.effectSupplier.value()))).toString());
        tag.putInt("min", this.min);
        tag.putInt("max", this.max);
        return tag;
    }

    public boolean predicate(ServerPlayerPatch serverPlayerPatch) {
        if (this.isTarget) {
            if (serverPlayerPatch.getTarget() == null) {
                return false;
            }
            return this.test(serverPlayerPatch.getTarget());
        }
        return this.test((LivingEntity)serverPlayerPatch.getOriginal());
    }

    public boolean test(LivingEntity livingEntity) {
        if (!livingEntity.hasEffect(this.effectSupplier)) {
            return false;
        }
        int level = livingEntity.getEffect(this.effectSupplier).getAmplifier();
        return level >= this.min && level <= this.max;
    }

    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        return null;
    }
}

