/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.conditions;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class PressedTimeCondition
implements Condition<ServerPlayerPatch> {
    private int min;
    private int max = Integer.MAX_VALUE;

    public PressedTimeCondition(int min) {
        this.min = min;
    }

    public PressedTimeCondition(int minTicks, int maxTicks) {
        this.min = minTicks;
        this.max = maxTicks;
    }

    public PressedTimeCondition() {
    }

    public Condition<ServerPlayerPatch> read(CompoundTag compoundTag) {
        if (!compoundTag.contains("min") || !compoundTag.contains("max")) {
            throw new IllegalArgumentException("custom condition error: 'min' or 'max' not specified!");
        }
        this.min = compoundTag.getInt("min");
        this.max = compoundTag.getInt("max");
        return this;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public CompoundTag serializePredicate() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putInt("min", this.min);
        compoundTag.putInt("max", this.max);
        return compoundTag;
    }

    public boolean predicate(ServerPlayerPatch serverPlayerPatch) {
        throw new IllegalCallerException();
    }

    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        return null;
    }
}

