/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.conditions;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class StackCondition
implements Condition<ServerPlayerPatch> {
    private int min;
    private int max;

    public StackCondition(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public StackCondition() {
        this.min = 1;
        this.max = 1;
    }

    public Condition<ServerPlayerPatch> read(CompoundTag compoundTag) {
        if (!compoundTag.contains("min") && !compoundTag.contains("max")) {
            throw new IllegalArgumentException("custom player stack condition error: min or max not specified!");
        }
        this.min = compoundTag.getInt("min");
        this.max = compoundTag.getInt("max");
        return this;
    }

    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("min", this.min);
        tag.putInt("max", this.max);
        return tag;
    }

    public boolean predicate(ServerPlayerPatch serverPlayerPatch) {
        int stack = serverPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getStack();
        return stack >= this.min && stack <= this.max;
    }

    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        return null;
    }
}

