/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.conditions;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class VehicleCondition
implements Condition<ServerPlayerPatch> {
    private boolean hasVehicle;

    public VehicleCondition() {
    }

    public VehicleCondition(boolean hasVehicle) {
        this.hasVehicle = hasVehicle;
    }

    public Condition<ServerPlayerPatch> read(CompoundTag compoundTag) {
        if (!compoundTag.contains("has_vehicle")) {
            throw new IllegalArgumentException("custom vehicle condition error: has_vehicle not specified!");
        }
        this.hasVehicle = compoundTag.getBoolean("has_vehicle");
        return this;
    }

    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("has_vehicle", this.hasVehicle);
        return tag;
    }

    public boolean predicate(ServerPlayerPatch serverPlayerPatch) {
        return this.hasVehicle == ((ServerPlayer)serverPlayerPatch.getOriginal()).isPassenger();
    }

    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        return null;
    }
}

