/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.skill;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import com.p1nero.invincible.InvincibleConfig;
import com.p1nero.invincible.api.Side;
import com.p1nero.invincible.api.combo.ComboNode;
import com.p1nero.invincible.api.combo.ComboType;
import com.p1nero.invincible.api.events.BaseEvent;
import com.p1nero.invincible.api.events.HitEvent;
import com.p1nero.invincible.api.events.TimeStampedEvent;
import com.p1nero.invincible.attachment.InvincibleAttachments;
import com.p1nero.invincible.attachment.InvinciblePlayer;
import com.p1nero.invincible.conditions.PressIntervalCondition;
import com.p1nero.invincible.conditions.PressedTimeCondition;
import com.p1nero.invincible.gameassets.InvincibleSkillDataKeys;
import com.p1nero.invincible.item.InvincibleItems;
import com.p1nero.invincible.skill.AbstractInvincibleSkill;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.Input;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.neoevent.playerpatch.DealDamageEvent;
import yesman.epicfight.api.neoevent.playerpatch.DodgeSuccessEvent;
import yesman.epicfight.api.neoevent.playerpatch.SkillCastEvent;
import yesman.epicfight.api.neoevent.playerpatch.TakeDamageEvent;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPSkillFeedback;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillEvent;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;

public class ComboBasicAttack
extends AbstractInvincibleSkill {
    public static final Logger LOGGER = LogUtils.getLogger();
    @OnlyIn(value=Dist.CLIENT)
    protected boolean isWalking;
    protected boolean shouldDrawGui;
    protected List<String> translationKeys;
    protected final int maxPressTime;
    protected final int maxReserveTime;
    protected final int maxProtectTime;
    @Nullable
    protected AnimationManager.AnimationAccessor<? extends StaticAnimation> walkBegin;
    @Nullable
    protected AnimationManager.AnimationAccessor<? extends StaticAnimation> walkEnd;
    protected ComboNode root;
    @Nullable
    protected ResourceLocation skillTextureLocation;
    private static final Vec2f[] CLOCK_POS = new Vec2f[]{new Vec2f(0.5f, 0.5f), new Vec2f(0.5f, 0.0f), new Vec2f(0.0f, 0.0f), new Vec2f(0.0f, 1.0f), new Vec2f(1.0f, 1.0f), new Vec2f(1.0f, 0.0f)};

    public ComboBasicAttack(Builder builder) {
        super(builder);
        this.shouldDrawGui = builder.shouldDrawGui;
        this.root = builder.root;
        this.walkBegin = builder.walkBegin;
        this.walkEnd = builder.walkEnd;
        this.translationKeys = builder.translationKeys;
        this.maxPressTime = builder.maxPressTime;
        this.maxReserveTime = builder.maxReserveTime;
        this.maxProtectTime = builder.maxProtectTime;
        this.skillTextureLocation = builder.skillTextureLocation;
    }

    public static Builder createComboBasicAttack(Function<Builder, ComboBasicAttack> constructor) {
        return new Builder(constructor).setCategory((SkillCategory)SkillCategories.WEAPON_INNATE).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.NONE);
    }

    public ComboNode getCurrentNode(SkillContainer container) {
        return InvincibleAttachments.getPlayer((Player)container.getExecutor().getOriginal()).getCurrentNode();
    }

    public boolean canExecute(SkillContainer container) {
        if (container.getExecutor().isLogicalClient()) {
            return super.canExecute(container);
        }
        ItemStack itemstack = ((Player)container.getExecutor().getOriginal()).getMainHandItem();
        return super.canExecute(container) && EpicFightCapabilities.getItemStackCapability((ItemStack)itemstack).getInnateSkill(container.getExecutor(), itemstack) == this && ((Player)container.getExecutor().getOriginal()).getVehicle() == null;
    }

    public boolean isExecutableState(PlayerPatch<?> executor) {
        return executor.getEntityState().canBasicAttack() && !((Player)executor.getOriginal()).isSpectator();
    }

    public void executeOnServer(SkillContainer container, CompoundTag args) {
        if (!args.contains("type_id")) {
            return;
        }
        ComboType type = (ComboType)ComboType.ENUM_MANAGER.get(args.getInt("type_id"));
        if (args.getBoolean("on_press")) {
            this.onPress(container, container.getServerExecutor(), type);
        } else {
            this.executeOnServer(container, type, args.getInt("pressed_time"), args.getLong("pressed_interval"));
        }
    }

    public void onPress(SkillContainer container, ServerPlayerPatch serverPlayerPatch, ComboType comboType) {
    }

    public void executeOnServer(SkillContainer container, ComboType type, int pressedTime, long inputInterval) {
        ComboNode current;
        boolean debugMode;
        if (pressedTime > this.getMaxProtectTime() || pressedTime == 0) {
            return;
        }
        boolean bl = debugMode = ((Player)container.getExecutor().getOriginal()).getMainHandItem().is((Item)InvincibleItems.DEBUG.get()) || ((Player)container.getExecutor().getOriginal()).getMainHandItem().is((Item)InvincibleItems.CUSTOM_COMBO_DEMO.get());
        if (debugMode) {
            LOGGER.debug("{} {} : pressed {} ticks. Interval: {} ms.", new Object[]{((Player)container.getExecutor().getOriginal()).getMainHandItem().getDescriptionId(), type, pressedTime, inputInterval});
        }
        InvinciblePlayer invinciblePlayer = InvincibleAttachments.getPlayer((Player)container.getExecutor().getOriginal());
        ComboNode last = invinciblePlayer.getCurrentNode();
        boolean hasPressedTimeCondition = false;
        if (last == null) {
            return;
        }
        ComboNode next = current = last.getNext(type);
        if (current == null) {
            ComboType subType;
            Iterator<Object> iterator = type.getSubTypes().iterator();
            while (iterator.hasNext() && (current = last.getNext(subType = iterator.next())) == null) {
            }
        }
        if (current != null) {
            AnimationManager.AnimationAccessor<? extends StaticAnimation> animationAccessor;
            if (current.getAnimationAccessor() == null || !current.getConditionAnimations().isEmpty()) {
                if (current.getConditionAnimations().isEmpty()) {
                    return;
                }
                current.getConditionAnimations().sort(Comparator.comparingInt(ComboNode::getPriority).reversed());
                for (ComboNode conditionAnimation : current.getConditionAnimations()) {
                    boolean canExecute = true;
                    for (Condition condition : conditionAnimation.getConditions(Side.BOTH, Side.SERVER)) {
                        if (condition instanceof PressedTimeCondition) {
                            PressedTimeCondition pressedTimeCondition = (PressedTimeCondition)condition;
                            if (pressedTime >= pressedTimeCondition.getMin() && pressedTime <= pressedTimeCondition.getMax()) continue;
                            canExecute = false;
                            break;
                        }
                        if (condition instanceof PressIntervalCondition) {
                            PressIntervalCondition pressIntervalCondition = (PressIntervalCondition)condition;
                            if (inputInterval >= pressIntervalCondition.getMin() && inputInterval <= pressIntervalCondition.getMax()) continue;
                            canExecute = false;
                            break;
                        }
                        if (condition.predicate((Object)container.getExecutor())) continue;
                        canExecute = false;
                        break;
                    }
                    if (!canExecute) continue;
                    current = conditionAnimation;
                    if (conditionAnimation.hasNext()) {
                        next = conditionAnimation;
                    }
                    break;
                }
            } else {
                for (Condition condition : current.getConditions(new Side[0])) {
                    PressIntervalCondition pressIntervalCondition;
                    if (condition instanceof PressedTimeCondition) {
                        PressedTimeCondition pressedTimeCondition = (PressedTimeCondition)condition;
                        hasPressedTimeCondition = true;
                        if (pressedTime >= pressedTimeCondition.getMin() && pressedTime <= pressedTimeCondition.getMax()) continue;
                        return;
                    }
                    if (!(condition instanceof PressIntervalCondition ? inputInterval < (pressIntervalCondition = (PressIntervalCondition)condition).getMin() || inputInterval > pressIntervalCondition.getMax() : !condition.predicate((Object)container.getExecutor()))) continue;
                    return;
                }
                if (!hasPressedTimeCondition && pressedTime > 20) {
                    return;
                }
            }
            if ((animationAccessor = current.getAnimationAccessor()) == null) {
                return;
            }
            float convertTime = current.getConvertTime();
            if (debugMode) {
                LOGGER.debug("animationAccessor: {}", animationAccessor);
            }
            container.getExecutor().playAnimationSynchronized(animationAccessor, convertTime);
            current.getOnBeginEvents().forEach(event -> event.testAndExecute(container.getExecutor(), (Entity)container.getExecutor().getTarget(), invinciblePlayer));
            this.initPlayer(container, invinciblePlayer, current);
            if (current.isRepeatNode()) {
                next = current.getParentNode();
            }
            invinciblePlayer.setCurrentNode(next);
            ComboBasicAttack.sendFeedback(next, container, invinciblePlayer);
        } else {
            invinciblePlayer.setCurrentNode(this.root);
            ComboBasicAttack.sendFeedback(this.root, container, invinciblePlayer);
        }
    }

    public static void syncNode(ComboNode node, ServerPlayer serverPlayer) {
        SkillContainer container = ((ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)serverPlayer, ServerPlayerPatch.class)).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
        InvinciblePlayer invinciblePlayer = InvincibleAttachments.getPlayer((Player)serverPlayer);
        ComboBasicAttack.sendFeedback(node, container, invinciblePlayer);
    }

    public static void sendFeedback(ComboNode node, SkillContainer container, InvinciblePlayer invinciblePlayer) {
        if (node == null) {
            return;
        }
        SPSkillFeedback feedbackPacket = SPSkillFeedback.executed((SkillSlot)container.getSlot());
        feedbackPacket.arguments().put("invincible_player_nbt", (Tag)invinciblePlayer.saveNBTData(new CompoundTag()));
        EpicFightNetworkManager.sendToPlayer((CustomPacketPayload)feedbackPacket, (ServerPlayer)((ServerPlayer)container.getExecutor().getOriginal()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void executeOnServer(ServerPlayer serverPlayer, ComboType type) {
        ComboBasicAttack.executeOnServer(serverPlayer, type, 1, 0L);
    }

    public static void executeOnServer(ServerPlayer serverPlayer, ComboType type, int pressedTime, long inputInterval) {
        ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)serverPlayer, ServerPlayerPatch.class);
        Skill skill = serverPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getSkill();
        if (skill instanceof ComboBasicAttack) {
            ComboBasicAttack comboBasicAttack = (ComboBasicAttack)skill;
            comboBasicAttack.executeOnServer(serverPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE), type, pressedTime, inputInterval);
        }
    }

    private void initPlayer(SkillContainer container, InvinciblePlayer invinciblePlayer, ComboNode next) {
        invinciblePlayer.resetTimeEvents();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TimeStampedEvent event : next.getTimeEvents()) {
            event.resetExecuted();
            builder.add((Object)event);
        }
        invinciblePlayer.setTimeStampedEvents((ImmutableList<TimeStampedEvent>)builder.build());
        invinciblePlayer.setHurtEvents((ImmutableList<BaseEvent>)ImmutableList.copyOf(next.getHurtEvents()));
        invinciblePlayer.setHitSuccessEvents((ImmutableList<BaseEvent>)ImmutableList.copyOf(next.getHitEvents()));
        invinciblePlayer.setDodgeSuccessEvents((ImmutableList<BaseEvent>)ImmutableList.copyOf(next.getDodgeSuccessEvents()));
        invinciblePlayer.setCanBeInterrupt(next.isCanBeInterrupt());
        invinciblePlayer.setPlaySpeedMultiplier(next.getPlaySpeed());
        invinciblePlayer.setNotCharge(next.isNotCharge());
        invinciblePlayer.setPhase(next.getNewPhase());
        if (next.getCooldown() > 0) {
            container.getDataManager().setDataSync(InvincibleSkillDataKeys.COOLDOWN, (Object)next.getCooldown());
            invinciblePlayer.setItemCooldown(((Player)container.getExecutor().getOriginal()).getMainHandItem(), next.getCooldown());
        }
        invinciblePlayer.setArmorNegation(next.getArmorNegation());
        invinciblePlayer.setHurtDamageMultiplier(next.getHurtDamageMultiplier());
        invinciblePlayer.setDamageMultiplier(next.getDamageMultiplier());
        invinciblePlayer.setImpactMultiplier(next.getImpactMultiplier());
        invinciblePlayer.setStunTypeModifier(next.getStunTypeModifier());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void executeOnClient(SkillContainer container, CompoundTag args) {
        if (args.contains("invincible_player_nbt")) {
            CompoundTag tag = args.getCompound("invincible_player_nbt");
            InvinciblePlayer invinciblePlayer = InvincibleAttachments.getPlayer((Player)container.getExecutor().getOriginal());
            invinciblePlayer.loadNBTData(tag);
            ComboNode current = invinciblePlayer.getCurrentNode();
            if (current != null) {
                invinciblePlayer.getCurrentNode().getOnBeginEvents().forEach(event -> event.testAndExecute(container.getExecutor(), (Entity)container.getExecutor().getTarget(), invinciblePlayer));
            }
        }
    }

    @SkillEvent(side=SkillEvent.Side.SERVER)
    public void onDodgeSuccess(DodgeSuccessEvent event, SkillContainer container) {
        InvinciblePlayer invinciblePlayer = InvincibleAttachments.getPlayer((Player)container.getExecutor().getOriginal());
        ImmutableList<BaseEvent> dodgeSuccessEvents = InvincibleAttachments.getPlayer((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).getDodgeSuccessEvents();
        if (dodgeSuccessEvents != null) {
            dodgeSuccessEvents.forEach(dodgeEvent -> dodgeEvent.testAndExecute(event.getPlayerPatch(), (Entity)((ServerPlayerPatch)event.getPlayerPatch()).getTarget(), invinciblePlayer));
        }
        container.getDataManager().setDataSync(InvincibleSkillDataKeys.DODGE_SUCCESS_TIMER, (Object)((Integer)InvincibleConfig.EFFECT_TICK.get()));
    }

    @SkillEvent(side=SkillEvent.Side.SERVER)
    public void onHurtEventPre(TakeDamageEvent.Pre event, SkillContainer container) {
        InvinciblePlayer invinciblePlayer = InvincibleAttachments.getPlayer((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
        DamageSource damageSource = event.getDamageSource();
        if (damageSource instanceof EpicFightDamageSource) {
            EpicFightDamageSource epicFightDamageSource = (EpicFightDamageSource)damageSource;
            if (!invinciblePlayer.isCanBeInterrupt()) {
                epicFightDamageSource.setStunType(StunType.NONE);
            }
        }
        if (invinciblePlayer.getHurtDamageMultiplier() != 0.0f) {
            event.attachValueModifier(ValueModifier.multiplier((float)invinciblePlayer.getHurtDamageMultiplier()));
        }
    }

    @SkillEvent(side=SkillEvent.Side.SERVER)
    public void onHurtEventIncome(TakeDamageEvent.Income event, SkillContainer container) {
        if (event.isParried()) {
            container.getDataManager().setDataSync(InvincibleSkillDataKeys.PARRY_TIMER, (Object)((Integer)InvincibleConfig.EFFECT_TICK.get()));
        }
    }

    @SkillEvent(side=SkillEvent.Side.SERVER)
    public void onHurtEventPost(TakeDamageEvent.Post event, SkillContainer container) {
        InvinciblePlayer invinciblePlayer = InvincibleAttachments.getPlayer((Player)container.getExecutor().getOriginal());
        ImmutableList<BaseEvent> hurtEvents = InvincibleAttachments.getPlayer((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).getHurtEvents();
        if (hurtEvents != null) {
            hurtEvents.forEach(hurtEvent -> hurtEvent.testAndExecute(event.getPlayerPatch(), (Entity)((ServerPlayerPatch)event.getPlayerPatch()).getTarget(), invinciblePlayer));
        }
    }

    @SkillEvent(side=SkillEvent.Side.SERVER)
    public void onDealDamageEventPre(DealDamageEvent.Pre event, SkillContainer container) {
        InvinciblePlayer invinciblePlayer = InvincibleAttachments.getPlayer((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
        if (invinciblePlayer.getStunTypeModifier() != null) {
            event.getDamageSource().setStunType(invinciblePlayer.getStunTypeModifier());
        }
        if (invinciblePlayer.getImpactMultiplier() != 1.0f) {
            event.getDamageSource().setBaseImpact(event.getDamageSource().getBaseImpact() * invinciblePlayer.getImpactMultiplier());
        }
        if (invinciblePlayer.getArmorNegation() != 0.0f) {
            event.getDamageSource().setBaseArmorNegation(invinciblePlayer.getArmorNegation());
        }
        if (invinciblePlayer.getDamageMultiplier() != null) {
            event.getDamageSource().attachDamageModifier(invinciblePlayer.getDamageMultiplier());
        }
    }

    @SkillEvent(side=SkillEvent.Side.SERVER)
    public void onDealDamageEventPost(DealDamageEvent.Post event, SkillContainer container) {
        if (!InvincibleAttachments.getPlayer((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).isNotCharge()) {
            float value;
            PlayerPatch playerPatch = event.getPlayerPatch();
            ItemStack mainHandItem = ((Player)playerPatch.getOriginal()).getMainHandItem();
            CapabilityItem capabilityItem = EpicFightCapabilities.getItemStackCapability((ItemStack)mainHandItem);
            if (capabilityItem == null || !(capabilityItem.getInnateSkill(playerPatch, mainHandItem) instanceof ComboBasicAttack)) {
                return;
            }
            if (!container.isFull() && (value = container.getResource() + ((LivingDamageEvent.Post)event.getNeoForgeEvent()).getNewDamage()) > 0.0f) {
                this.setConsumptionSynchronize(container, value);
            }
        }
        InvinciblePlayer invinciblePlayer = InvincibleAttachments.getPlayer((Player)container.getExecutor().getOriginal());
        ImmutableList<BaseEvent> hitEvents = InvincibleAttachments.getPlayer((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).getHitSuccessEvents();
        if (hitEvents != null) {
            LivingEntity target = event.getTarget() == null ? ((ServerPlayerPatch)event.getPlayerPatch()).getTarget() : event.getTarget();
            AnimationPlayer animationPlayer = ((ServerPlayerPatch)event.getPlayerPatch()).getAnimator().getPlayerFor(null);
            hitEvents.forEach(arg_0 -> ComboBasicAttack.lambda$onDealDamageEventPost$4(animationPlayer, event, (Entity)target, invinciblePlayer, arg_0));
        }
    }

    @SkillEvent(side=SkillEvent.Side.BOTH)
    public void onSkillExecute(SkillCastEvent event, SkillContainer container) {
        ItemStack mainHandItem = ((Player)event.getPlayerPatch().getOriginal()).getMainHandItem();
        if (mainHandItem.isEmpty() || EpicFightCapabilities.getItemCapability((ItemStack)mainHandItem).isEmpty()) {
            return;
        }
        CapabilityItem capabilityItem = EpicFightCapabilities.getItemStackCapability((ItemStack)mainHandItem);
        if (capabilityItem == null || capabilityItem.getInnateSkill(event.getPlayerPatch(), mainHandItem) == null) {
            return;
        }
        SkillCategory skillCategory = event.getSkillContainer().getSkill().getCategory();
        if (skillCategory.equals((Object)SkillCategories.BASIC_ATTACK) && !((Player)event.getPlayerPatch().getOriginal()).isPassenger()) {
            event.setCanceled(true);
        }
    }

    @SkillEvent(side=SkillEvent.Side.CLIENT)
    public void onMovementInput(MovementInputUpdateEvent event, SkillContainer container) {
        Input input = event.getInput();
        boolean isUp = input.up;
        if (isUp && !this.isWalking) {
            if (this.walkBegin != null) {
                container.getExecutor().playAnimationSynchronized(this.walkBegin, 0.15f);
            }
            this.isWalking = true;
        }
        if (!isUp && this.isWalking) {
            if (this.walkEnd != null) {
                container.getExecutor().playAnimationSynchronized(this.walkEnd, 0.15f);
            }
            this.isWalking = false;
        }
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        this.resetCombo(container, container.getExecutor(), this.root);
        InvincibleAttachments.getPlayer((Player)container.getExecutor().getOriginal()).resetPhase();
        container.getDataManager().setData(InvincibleSkillDataKeys.COOLDOWN, (Object)0);
    }

    public void updateContainer(SkillContainer container) {
        PlayerPatch playerPatch;
        super.updateContainer(container);
        InvinciblePlayer invinciblePlayer = InvincibleAttachments.getPlayer((Player)container.getExecutor().getOriginal());
        SkillDataManager manager = container.getDataManager();
        if (!container.getExecutor().isLogicalClient() && container.getExecutor().getTickSinceLastAction() > (Integer)InvincibleConfig.RESET_TICK.get()) {
            this.resetCombo(container, (PlayerPatch<?>)container.getServerExecutor(), this.root);
        }
        if (manager.hasData(InvincibleSkillDataKeys.DODGE_SUCCESS_TIMER)) {
            manager.setData(InvincibleSkillDataKeys.DODGE_SUCCESS_TIMER, (Object)Math.max((Integer)manager.getDataValue(InvincibleSkillDataKeys.DODGE_SUCCESS_TIMER) - 1, 0));
        }
        if (manager.hasData(InvincibleSkillDataKeys.PARRY_TIMER)) {
            manager.setData(InvincibleSkillDataKeys.PARRY_TIMER, (Object)Math.max((Integer)manager.getDataValue(InvincibleSkillDataKeys.PARRY_TIMER) - 1, 0));
        }
        if ((playerPatch = container.getExecutor()) instanceof ServerPlayerPatch) {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)playerPatch;
            ItemStack itemStack = ((ServerPlayer)serverPlayerPatch.getOriginal()).getMainHandItem();
            int currentCooldown = invinciblePlayer.getItemCooldown(itemStack);
            if (currentCooldown > 0) {
                invinciblePlayer.setItemCooldown(itemStack, --currentCooldown);
            }
            if (currentCooldown != (Integer)manager.getDataValue(InvincibleSkillDataKeys.COOLDOWN)) {
                manager.setDataSync(InvincibleSkillDataKeys.COOLDOWN, (Object)currentCooldown);
            }
        }
    }

    public void resetCombo(SkillContainer container, PlayerPatch<?> playerPatch, ComboNode root) {
        InvinciblePlayer invinciblePlayer = InvincibleAttachments.getPlayer((Player)playerPatch.getOriginal());
        invinciblePlayer.setCurrentNode(root);
        invinciblePlayer.clear();
        if (!playerPatch.isLogicalClient()) {
            ComboBasicAttack.sendFeedback(root, container, invinciblePlayer);
        }
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerpatch) {
        if (this.translationKeys.isEmpty()) {
            return super.getTooltipOnItem(itemStack, cap, playerpatch);
        }
        ArrayList list = Lists.newArrayList();
        for (String translationKey : this.translationKeys) {
            list.add(Component.translatable((String)translationKey));
        }
        return list;
    }

    public int getMaxPressTime() {
        return this.maxPressTime == 0 ? (Integer)InvincibleConfig.MAX_PRESS_TICK.get() : this.maxPressTime;
    }

    public int getMaxProtectTime() {
        return this.maxProtectTime == 0 ? (Integer)InvincibleConfig.PRESS_PROTECT_TICK.get() : this.maxProtectTime;
    }

    public int getMaxReserveTime() {
        return this.maxReserveTime == 0 ? (Integer)InvincibleConfig.RESERVE_TICK.get() : this.maxReserveTime;
    }

    public boolean shouldDraw(SkillContainer container) {
        return this.shouldDrawGui;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        int stringWidth;
        int j;
        float lastVertexY;
        float lastVertexX;
        float lastTexY;
        float lastTexX;
        int vertexNum;
        boolean creative = ((Player)container.getExecutor().getOriginal()).isCreative();
        boolean fullstack = creative || container.isFull();
        boolean canUse = !container.isDisabled() && container.getSkill().checkExecuteCondition(container);
        float cooldownRatio = fullstack || container.isActivated() ? 1.0f : container.getResource(partialTick);
        float iconSize = 32.0f;
        float bottom = y + iconSize;
        float right = x + iconSize;
        float middle = x + iconSize * 0.5f;
        if (cooldownRatio < 0.125f) {
            vertexNum = 6;
            lastTexX = cooldownRatio / 0.25f;
            lastTexY = 0.0f;
            lastVertexX = middle + iconSize * lastTexX;
            lastVertexY = y;
            lastTexX += 0.5f;
        } else if (cooldownRatio < 0.375f) {
            vertexNum = 5;
            lastTexX = 1.0f;
            lastTexY = (cooldownRatio - 0.125f) / 0.25f;
            lastVertexX = right;
            lastVertexY = y + iconSize * lastTexY;
        } else if (cooldownRatio < 0.625f) {
            vertexNum = 4;
            lastTexX = (cooldownRatio - 0.375f) / 0.25f;
            lastTexY = 1.0f;
            lastVertexX = right - iconSize * lastTexX;
            lastVertexY = bottom;
            lastTexX = 1.0f - lastTexX;
        } else if (cooldownRatio < 0.875f) {
            vertexNum = 3;
            lastTexX = 0.0f;
            lastTexY = (cooldownRatio - 0.625f) / 0.25f;
            lastVertexX = x;
            lastVertexY = bottom - iconSize * lastTexY;
            lastTexY = 1.0f - lastTexY;
        } else {
            vertexNum = 2;
            lastTexX = (cooldownRatio - 0.875f) / 0.25f;
            lastTexY = 0.0f;
            lastVertexX = x + iconSize * lastTexX;
            lastVertexY = y;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)container.getSkill().getSkillTexture());
        if (canUse) {
            if (container.getStack() > 0) {
                RenderSystem.setShaderColor((float)0.0f, (float)0.64f, (float)0.72f, (float)0.8f);
            } else {
                RenderSystem.setShaderColor((float)0.0f, (float)0.5f, (float)0.5f, (float)0.6f);
            }
        } else {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.6f);
        }
        PoseStack poseStack = guiGraphics.pose();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_TEX);
        for (j = 0; j < vertexNum; ++j) {
            bufferbuilder.addVertex(poseStack.last(), x + iconSize * ComboBasicAttack.CLOCK_POS[j].x, y + iconSize * ComboBasicAttack.CLOCK_POS[j].y, 0.0f).setUv(ComboBasicAttack.CLOCK_POS[j].x, ComboBasicAttack.CLOCK_POS[j].y);
        }
        bufferbuilder.addVertex(poseStack.last(), lastVertexX, lastVertexY, 0.0f).setUv(lastTexX, lastTexY);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        if (canUse) {
            RenderSystem.setShaderColor((float)0.08f, (float)0.79f, (float)0.95f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glCullFace((int)1028);
        bufferbuilder = tessellator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_TEX);
        for (j = 0; j < 2; ++j) {
            bufferbuilder.addVertex(poseStack.last(), x + iconSize * ComboBasicAttack.CLOCK_POS[j].x, y + iconSize * ComboBasicAttack.CLOCK_POS[j].y, 0.0f).setUv(ComboBasicAttack.CLOCK_POS[j].x, ComboBasicAttack.CLOCK_POS[j].y);
        }
        for (j = CLOCK_POS.length - 1; j >= vertexNum; --j) {
            bufferbuilder.addVertex(poseStack.last(), x + iconSize * ComboBasicAttack.CLOCK_POS[j].x, y + iconSize * ComboBasicAttack.CLOCK_POS[j].y, 0.0f).setUv(ComboBasicAttack.CLOCK_POS[j].x, ComboBasicAttack.CLOCK_POS[j].y);
        }
        bufferbuilder.addVertex(poseStack.last(), lastVertexX, lastVertexY, 0.0f).setUv(lastTexX, lastTexY);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        GL11.glCullFace((int)1029);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (container.isActivated() && (container.getSkill().getActivateType() == Skill.ActivateType.DURATION || container.getSkill().getActivateType() == Skill.ActivateType.DURATION_INFINITE)) {
            String s = String.format("%.0f", Float.valueOf((float)container.getRemainDuration() / 20.0f));
            stringWidth = (gui.getFont().width(s) - 6) / 3;
            guiGraphics.drawString(gui.getFont(), s, x + 13.0f - (float)stringWidth, y + 13.0f, 0xFFFFFF, true);
        } else if (!fullstack) {
            String s = String.valueOf((int)(cooldownRatio * 100.0f));
            stringWidth = (gui.getFont().width(s) - 6) / 3;
            guiGraphics.drawString(gui.getFont(), s, x + 13.0f - (float)stringWidth, y + 13.0f, 0xFFFFFF, true);
        }
        if (container.getSkill().getMaxStack() > 1) {
            String s = String.valueOf(container.getStack());
            stringWidth = (gui.getFont().width(s) - 6) / 3;
            guiGraphics.drawString(gui.getFont(), s, x + 25.0f - (float)stringWidth, y + 22.0f, 0xFFFFFF, true);
        }
        RenderSystem.disableBlend();
        SkillDataManager manager = container.getDataManager();
        if (!manager.hasData(InvincibleSkillDataKeys.COOLDOWN)) {
            return;
        }
        int cooldown = (Integer)manager.getDataValue(InvincibleSkillDataKeys.COOLDOWN);
        if (cooldown > 0) {
            Vec2i pos = ClientConfig.getWeaponInnatePosition();
            String s = String.format("%.1fs", (double)cooldown / 20.0);
            int stringWidth2 = (gui.getFont().width(s) - 6) / 3;
            guiGraphics.drawString(gui.getFont(), s, pos.x - stringWidth2, pos.y + 22, 0xFFFFFF, true);
        }
    }

    public ResourceLocation getSkillTexture() {
        return this.skillTextureLocation != null ? this.skillTextureLocation : super.getSkillTexture();
    }

    private static /* synthetic */ void lambda$onDealDamageEventPost$4(AnimationPlayer animationPlayer, DealDamageEvent.Post event, Entity target, InvinciblePlayer invinciblePlayer, BaseEvent baseEvent) {
        if (animationPlayer != null && baseEvent instanceof HitEvent) {
            HitEvent hitEvent = (HitEvent)baseEvent;
            Object patt0$temp = animationPlayer.getRealAnimation().get();
            if (patt0$temp instanceof AttackAnimation) {
                AttackAnimation attackAnimation = (AttackAnimation)patt0$temp;
                if (hitEvent.phaseIndex >= 0 && attackAnimation.getPhaseOrderByTime(animationPlayer.getElapsedTime()) != hitEvent.phaseIndex) {
                    return;
                }
            }
        }
        baseEvent.testAndExecute(event.getPlayerPatch(), target, invinciblePlayer);
    }

    public static class Builder
    extends SkillBuilder<Builder> {
        protected ComboNode root;
        protected List<String> translationKeys = List.of();
        @Nullable
        protected AnimationManager.AnimationAccessor<? extends StaticAnimation> walkBegin;
        @Nullable
        protected AnimationManager.AnimationAccessor<? extends StaticAnimation> walkEnd;
        protected boolean shouldDrawGui;
        protected int maxPressTime;
        protected int maxReserveTime;
        protected int maxProtectTime;
        protected ResourceLocation skillTextureLocation;

        public Builder(Function<Builder, ? extends ComboBasicAttack> constructor) {
            super(constructor);
        }

        public Builder setMaxPressTime(int maxPressTime) {
            this.maxPressTime = maxPressTime;
            return this;
        }

        public Builder setMaxProtectTime(int maxProtectTime) {
            this.maxProtectTime = maxProtectTime;
            return this;
        }

        public Builder setReserveTime(int maxReserveTime) {
            this.maxReserveTime = maxReserveTime;
            return this;
        }

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCombo(ComboNode root) {
            this.root = root;
            return this;
        }

        public Builder setShouldDrawGui(boolean shouldDrawGui) {
            this.shouldDrawGui = shouldDrawGui;
            return this;
        }

        public Builder setWalkBeginAnim(AnimationManager.AnimationAccessor<? extends StaticAnimation> walkBegin) {
            this.walkBegin = walkBegin;
            return this;
        }

        public Builder setWalkEndAnim(AnimationManager.AnimationAccessor<? extends StaticAnimation> walkEnd) {
            this.walkEnd = walkEnd;
            return this;
        }

        public Builder addToolTipOnItem(List<String> translationKeys) {
            this.translationKeys = translationKeys;
            return this;
        }

        public Builder setSkillTextureLocation(ResourceLocation skillTextureLocation) {
            this.skillTextureLocation = skillTextureLocation;
            return this;
        }
    }
}

