/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.skill;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.p1nero.invincible.InvincibleConfig;
import com.p1nero.invincible.api.combo.ComboNode;
import com.p1nero.invincible.api.events.BaseEvent;
import com.p1nero.invincible.api.events.TimeStampedEvent;
import com.p1nero.invincible.attachment.InvincibleAttachments;
import com.p1nero.invincible.attachment.InvinciblePlayer;
import com.p1nero.invincible.gameassets.InvincibleSkillDataKeys;
import com.p1nero.invincible.skill.AbstractInvincibleSkill;
import com.p1nero.invincible.skill.ComboBasicAttack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.neoevent.playerpatch.DealDamageEvent;
import yesman.epicfight.api.neoevent.playerpatch.DodgeSuccessEvent;
import yesman.epicfight.api.neoevent.playerpatch.TakeDamageEvent;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillEvent;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;

public class SimpleCustomInnateSkill
extends AbstractInvincibleSkill {
    protected boolean shouldDrawGui;
    protected List<String> translationKeys;
    protected ResourceLocation skillTexture;
    @Nullable
    protected AnimationManager.AnimationAccessor<? extends StaticAnimation> walkBegin;
    @Nullable
    protected AnimationManager.AnimationAccessor<? extends StaticAnimation> walkEnd;
    protected ComboNode node;
    private static final Vec2f[] CLOCK_POS = new Vec2f[]{new Vec2f(0.5f, 0.5f), new Vec2f(0.5f, 0.0f), new Vec2f(0.0f, 0.0f), new Vec2f(0.0f, 1.0f), new Vec2f(1.0f, 1.0f), new Vec2f(1.0f, 0.0f)};

    public SimpleCustomInnateSkill(Builder builder) {
        super(builder);
        this.shouldDrawGui = builder.shouldDrawGui;
        this.skillTexture = builder.skillTextureLocation;
        this.node = builder.root;
        this.translationKeys = builder.translationKeys;
    }

    public static Builder createCustomInnateSkill(Function<Builder, SimpleCustomInnateSkill> constructor) {
        return new Builder(constructor).setCategory((SkillCategory)SkillCategories.WEAPON_INNATE).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.NONE);
    }

    public boolean canExecute(SkillContainer container) {
        if (container.getExecutor().isLogicalClient()) {
            return super.canExecute(container);
        }
        if (container.getStack() == 0 && !((Player)container.getExecutor().getOriginal()).isCreative()) {
            return false;
        }
        ItemStack itemstack = ((Player)container.getExecutor().getOriginal()).getMainHandItem();
        return super.canExecute(container) && EpicFightCapabilities.getItemStackCapability((ItemStack)itemstack).getInnateSkill(container.getExecutor(), itemstack) == this && ((Player)container.getExecutor().getOriginal()).getVehicle() == null;
    }

    public boolean isExecutableState(PlayerPatch<?> executor) {
        return executor.getEntityState().canBasicAttack() && !((Player)executor.getOriginal()).isSpectator();
    }

    public void executeOnServer(SkillContainer container, CompoundTag args) {
        AnimationManager.AnimationAccessor<? extends StaticAnimation> animationAccessor = this.node.getAnimationAccessor();
        if (animationAccessor == null) {
            return;
        }
        float convertTime = this.node.getConvertTime();
        container.getExecutor().playAnimationSynchronized(animationAccessor, convertTime);
        InvinciblePlayer invinciblePlayer = InvincibleAttachments.getPlayer((Player)container.getExecutor().getOriginal());
        this.node.getOnBeginEvents().forEach(event -> event.testAndExecute(container.getExecutor(), (Entity)container.getExecutor().getTarget(), invinciblePlayer));
        this.initPlayer(container, InvincibleAttachments.getPlayer((Player)container.getServerExecutor().getOriginal()), this.node);
        this.setStackSynchronize(container, container.getStack() - 1);
    }

    private void initPlayer(SkillContainer container, InvinciblePlayer invinciblePlayer, ComboNode node) {
        invinciblePlayer.resetTimeEvents();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TimeStampedEvent event : node.getTimeEvents()) {
            event.resetExecuted();
            builder.add((Object)event);
        }
        invinciblePlayer.setTimeStampedEvents((ImmutableList<TimeStampedEvent>)builder.build());
        invinciblePlayer.setHurtEvents((ImmutableList<BaseEvent>)ImmutableList.copyOf(node.getHurtEvents()));
        invinciblePlayer.setHitSuccessEvents((ImmutableList<BaseEvent>)ImmutableList.copyOf(node.getHitEvents()));
        invinciblePlayer.setDodgeSuccessEvents((ImmutableList<BaseEvent>)ImmutableList.copyOf(node.getDodgeSuccessEvents()));
        invinciblePlayer.setCanBeInterrupt(node.isCanBeInterrupt());
        invinciblePlayer.setPlaySpeedMultiplier(node.getPlaySpeed());
        invinciblePlayer.setNotCharge(node.isNotCharge());
        if (node.getCooldown() > 0) {
            container.getDataManager().setDataSync(InvincibleSkillDataKeys.COOLDOWN, (Object)node.getCooldown());
            invinciblePlayer.setItemCooldown(((Player)container.getExecutor().getOriginal()).getMainHandItem(), node.getCooldown());
        }
        invinciblePlayer.setArmorNegation(node.getArmorNegation());
        invinciblePlayer.setHurtDamageMultiplier(node.getHurtDamageMultiplier());
        invinciblePlayer.setDamageMultiplier(node.getDamageMultiplier());
        invinciblePlayer.setImpactMultiplier(node.getImpactMultiplier());
        invinciblePlayer.setStunTypeModifier(node.getStunTypeModifier());
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        this.resetCombo(container.getExecutor(), this.node);
        InvincibleAttachments.getPlayer((Player)container.getExecutor().getOriginal()).resetPhase();
        container.getDataManager().setData(InvincibleSkillDataKeys.COOLDOWN, (Object)0);
    }

    @SkillEvent(side=SkillEvent.Side.SERVER)
    public void onDodgeSuccess(DodgeSuccessEvent event, SkillContainer container) {
        InvinciblePlayer invinciblePlayer = InvincibleAttachments.getPlayer((Player)container.getExecutor().getOriginal());
        ImmutableList<BaseEvent> dodgeSuccessEvents = InvincibleAttachments.getPlayer((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).getDodgeSuccessEvents();
        if (dodgeSuccessEvents != null) {
            dodgeSuccessEvents.forEach(dodgeEvent -> dodgeEvent.testAndExecute(event.getPlayerPatch(), (Entity)((ServerPlayerPatch)event.getPlayerPatch()).getTarget(), invinciblePlayer));
        }
        container.getDataManager().setDataSync(InvincibleSkillDataKeys.DODGE_SUCCESS_TIMER, (Object)((Integer)InvincibleConfig.EFFECT_TICK.get()));
    }

    @SkillEvent(side=SkillEvent.Side.SERVER)
    public void onHurtEventPre(TakeDamageEvent.Pre event, SkillContainer container) {
        InvinciblePlayer invinciblePlayer = InvincibleAttachments.getPlayer((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
        DamageSource damageSource = event.getDamageSource();
        if (damageSource instanceof EpicFightDamageSource) {
            EpicFightDamageSource epicFightDamageSource = (EpicFightDamageSource)damageSource;
            if (!invinciblePlayer.isCanBeInterrupt()) {
                epicFightDamageSource.setStunType(StunType.NONE);
            }
        }
        if (invinciblePlayer.getHurtDamageMultiplier() != 0.0f) {
            event.attachValueModifier(ValueModifier.multiplier((float)invinciblePlayer.getHurtDamageMultiplier()));
        }
    }

    @SkillEvent(side=SkillEvent.Side.SERVER)
    public void onHurtEventIncome(TakeDamageEvent.Income event, SkillContainer container) {
        if (event.isParried()) {
            container.getDataManager().setDataSync(InvincibleSkillDataKeys.PARRY_TIMER, (Object)((Integer)InvincibleConfig.EFFECT_TICK.get()));
        }
    }

    @SkillEvent(side=SkillEvent.Side.SERVER)
    public void onHurtEventPost(TakeDamageEvent.Post event, SkillContainer container) {
        ImmutableList<BaseEvent> hurtEvents = InvincibleAttachments.getPlayer((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).getHurtEvents();
        InvinciblePlayer invinciblePlayer = InvincibleAttachments.getPlayer((Player)container.getExecutor().getOriginal());
        if (hurtEvents != null) {
            hurtEvents.forEach(hurtEvent -> hurtEvent.testAndExecute(event.getPlayerPatch(), (Entity)((ServerPlayerPatch)event.getPlayerPatch()).getTarget(), invinciblePlayer));
        }
    }

    @SkillEvent(side=SkillEvent.Side.SERVER)
    public void onDealDamageEventPre(DealDamageEvent.Pre event, SkillContainer container) {
        InvinciblePlayer invinciblePlayer = InvincibleAttachments.getPlayer((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
        if (invinciblePlayer.getStunTypeModifier() != null) {
            event.getDamageSource().setStunType(invinciblePlayer.getStunTypeModifier());
        }
        if (invinciblePlayer.getImpactMultiplier() != 1.0f) {
            event.getDamageSource().setBaseImpact(event.getDamageSource().getBaseImpact() * invinciblePlayer.getImpactMultiplier());
        }
        if (invinciblePlayer.getArmorNegation() != 0.0f) {
            event.getDamageSource().setBaseArmorNegation(invinciblePlayer.getArmorNegation());
        }
        if (invinciblePlayer.getDamageMultiplier() != null) {
            event.getDamageSource().attachDamageModifier(invinciblePlayer.getDamageMultiplier());
        }
    }

    @SkillEvent(side=SkillEvent.Side.SERVER)
    public void onDealDamageEventPost(DealDamageEvent.Post event, SkillContainer container) {
        if (!InvincibleAttachments.getPlayer((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).isNotCharge()) {
            float value;
            PlayerPatch playerPatch = event.getPlayerPatch();
            ItemStack mainHandItem = ((Player)playerPatch.getOriginal()).getMainHandItem();
            CapabilityItem capabilityItem = EpicFightCapabilities.getItemStackCapability((ItemStack)mainHandItem);
            if (capabilityItem == null || !(capabilityItem.getInnateSkill(playerPatch, mainHandItem) instanceof ComboBasicAttack)) {
                return;
            }
            if (!container.isFull() && (value = container.getResource() + ((LivingDamageEvent.Post)event.getNeoForgeEvent()).getNewDamage()) > 0.0f) {
                this.setConsumptionSynchronize(container, value);
            }
        }
        InvinciblePlayer invinciblePlayer = InvincibleAttachments.getPlayer((Player)container.getExecutor().getOriginal());
        ImmutableList<BaseEvent> hitEvents = InvincibleAttachments.getPlayer((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).getHitSuccessEvents();
        if (hitEvents != null) {
            hitEvents.forEach(hitEvent -> hitEvent.testAndExecute(event.getPlayerPatch(), (Entity)(event.getTarget() == null ? ((ServerPlayerPatch)event.getPlayerPatch()).getTarget() : event.getTarget()), invinciblePlayer));
        }
    }

    public void updateContainer(SkillContainer container) {
        PlayerPatch playerPatch;
        super.updateContainer(container);
        if (!container.getExecutor().isLogicalClient() && container.getExecutor().getTickSinceLastAction() > (Integer)InvincibleConfig.RESET_TICK.get()) {
            this.resetCombo((PlayerPatch<?>)container.getServerExecutor(), this.node);
        }
        InvinciblePlayer invinciblePlayer = InvincibleAttachments.getPlayer((Player)container.getExecutor().getOriginal());
        SkillDataManager manager = container.getDataManager();
        if (manager.hasData(InvincibleSkillDataKeys.DODGE_SUCCESS_TIMER)) {
            manager.setData(InvincibleSkillDataKeys.DODGE_SUCCESS_TIMER, (Object)Math.max((Integer)manager.getDataValue(InvincibleSkillDataKeys.DODGE_SUCCESS_TIMER) - 1, 0));
        }
        if (manager.hasData(InvincibleSkillDataKeys.PARRY_TIMER)) {
            manager.setData(InvincibleSkillDataKeys.PARRY_TIMER, (Object)Math.max((Integer)manager.getDataValue(InvincibleSkillDataKeys.PARRY_TIMER) - 1, 0));
        }
        if ((playerPatch = container.getExecutor()) instanceof ServerPlayerPatch) {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)playerPatch;
            ItemStack itemStack = ((ServerPlayer)serverPlayerPatch.getOriginal()).getMainHandItem();
            int currentCooldown = invinciblePlayer.getItemCooldown(itemStack);
            if (currentCooldown > 0) {
                invinciblePlayer.setItemCooldown(itemStack, --currentCooldown);
            }
            if (currentCooldown != (Integer)manager.getDataValue(InvincibleSkillDataKeys.COOLDOWN)) {
                manager.setDataSync(InvincibleSkillDataKeys.COOLDOWN, (Object)currentCooldown);
            }
        }
    }

    public void resetCombo(PlayerPatch<?> playerPatch, ComboNode root) {
        InvinciblePlayer invinciblePlayer = InvincibleAttachments.getPlayer((Player)playerPatch.getOriginal());
        invinciblePlayer.setCurrentNode(root);
        invinciblePlayer.clear();
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerpatch) {
        if (this.translationKeys.isEmpty()) {
            return super.getTooltipOnItem(itemStack, cap, playerpatch);
        }
        ArrayList list = Lists.newArrayList();
        for (String translationKey : this.translationKeys) {
            list.add(Component.translatable((String)translationKey));
        }
        return list;
    }

    public boolean shouldDraw(SkillContainer container) {
        return this.shouldDrawGui;
    }

    public ResourceLocation getSkillTexture() {
        return this.skillTexture == null ? super.getSkillTexture() : this.skillTexture;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        int stringWidth;
        int j;
        float lastVertexY;
        float lastVertexX;
        float lastTexY;
        float lastTexX;
        int vertexNum;
        boolean creative = ((Player)container.getExecutor().getOriginal()).isCreative();
        boolean fullstack = creative || container.isFull();
        boolean canUse = !container.isDisabled() && container.getSkill().checkExecuteCondition(container);
        float cooldownRatio = fullstack || container.isActivated() ? 1.0f : container.getResource(partialTick);
        float iconSize = 32.0f;
        float bottom = y + iconSize;
        float right = x + iconSize;
        float middle = x + iconSize * 0.5f;
        if (cooldownRatio < 0.125f) {
            vertexNum = 6;
            lastTexX = cooldownRatio / 0.25f;
            lastTexY = 0.0f;
            lastVertexX = middle + iconSize * lastTexX;
            lastVertexY = y;
            lastTexX += 0.5f;
        } else if (cooldownRatio < 0.375f) {
            vertexNum = 5;
            lastTexX = 1.0f;
            lastTexY = (cooldownRatio - 0.125f) / 0.25f;
            lastVertexX = right;
            lastVertexY = y + iconSize * lastTexY;
        } else if (cooldownRatio < 0.625f) {
            vertexNum = 4;
            lastTexX = (cooldownRatio - 0.375f) / 0.25f;
            lastTexY = 1.0f;
            lastVertexX = right - iconSize * lastTexX;
            lastVertexY = bottom;
            lastTexX = 1.0f - lastTexX;
        } else if (cooldownRatio < 0.875f) {
            vertexNum = 3;
            lastTexX = 0.0f;
            lastTexY = (cooldownRatio - 0.625f) / 0.25f;
            lastVertexX = x;
            lastVertexY = bottom - iconSize * lastTexY;
            lastTexY = 1.0f - lastTexY;
        } else {
            vertexNum = 2;
            lastTexX = (cooldownRatio - 0.875f) / 0.25f;
            lastTexY = 0.0f;
            lastVertexX = x + iconSize * lastTexX;
            lastVertexY = y;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)container.getSkill().getSkillTexture());
        if (canUse) {
            if (container.getStack() > 0) {
                RenderSystem.setShaderColor((float)0.0f, (float)0.64f, (float)0.72f, (float)0.8f);
            } else {
                RenderSystem.setShaderColor((float)0.0f, (float)0.5f, (float)0.5f, (float)0.6f);
            }
        } else {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.6f);
        }
        PoseStack poseStack = guiGraphics.pose();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tessellator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_TEX);
        for (j = 0; j < vertexNum; ++j) {
            bufferbuilder.addVertex(poseStack.last(), x + iconSize * SimpleCustomInnateSkill.CLOCK_POS[j].x, y + iconSize * SimpleCustomInnateSkill.CLOCK_POS[j].y, 0.0f).setUv(SimpleCustomInnateSkill.CLOCK_POS[j].x, SimpleCustomInnateSkill.CLOCK_POS[j].y);
        }
        bufferbuilder.addVertex(poseStack.last(), lastVertexX, lastVertexY, 0.0f).setUv(lastTexX, lastTexY);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        if (canUse) {
            RenderSystem.setShaderColor((float)0.08f, (float)0.79f, (float)0.95f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glCullFace((int)1028);
        bufferbuilder = tessellator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_TEX);
        for (j = 0; j < 2; ++j) {
            bufferbuilder.addVertex(poseStack.last(), x + iconSize * SimpleCustomInnateSkill.CLOCK_POS[j].x, y + iconSize * SimpleCustomInnateSkill.CLOCK_POS[j].y, 0.0f).setUv(SimpleCustomInnateSkill.CLOCK_POS[j].x, SimpleCustomInnateSkill.CLOCK_POS[j].y);
        }
        for (j = CLOCK_POS.length - 1; j >= vertexNum; --j) {
            bufferbuilder.addVertex(poseStack.last(), x + iconSize * SimpleCustomInnateSkill.CLOCK_POS[j].x, y + iconSize * SimpleCustomInnateSkill.CLOCK_POS[j].y, 0.0f).setUv(SimpleCustomInnateSkill.CLOCK_POS[j].x, SimpleCustomInnateSkill.CLOCK_POS[j].y);
        }
        bufferbuilder.addVertex(poseStack.last(), lastVertexX, lastVertexY, 0.0f).setUv(lastTexX, lastTexY);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        GL11.glCullFace((int)1029);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (container.isActivated() && (container.getSkill().getActivateType() == Skill.ActivateType.DURATION || container.getSkill().getActivateType() == Skill.ActivateType.DURATION_INFINITE)) {
            String s = String.format("%.0f", Float.valueOf((float)container.getRemainDuration() / 20.0f));
            stringWidth = (gui.getFont().width(s) - 6) / 3;
            guiGraphics.drawString(gui.getFont(), s, x + 13.0f - (float)stringWidth, y + 13.0f, 0xFFFFFF, true);
        } else if (!fullstack) {
            String s = String.valueOf((int)(cooldownRatio * 100.0f));
            stringWidth = (gui.getFont().width(s) - 6) / 3;
            guiGraphics.drawString(gui.getFont(), s, x + 13.0f - (float)stringWidth, y + 13.0f, 0xFFFFFF, true);
        }
        if (container.getSkill().getMaxStack() > 1) {
            String s = String.valueOf(container.getStack());
            stringWidth = (gui.getFont().width(s) - 6) / 3;
            guiGraphics.drawString(gui.getFont(), s, x + 25.0f - (float)stringWidth, y + 22.0f, 0xFFFFFF, true);
        }
        RenderSystem.disableBlend();
        SkillDataManager manager = container.getDataManager();
        if (!manager.hasData(InvincibleSkillDataKeys.COOLDOWN)) {
            return;
        }
        int cooldown = (Integer)manager.getDataValue(InvincibleSkillDataKeys.COOLDOWN);
        if (cooldown > 0) {
            Vec2i pos = ClientConfig.getWeaponInnatePosition();
            String s = String.format("%.1fs", (double)cooldown / 20.0);
            int stringWidth2 = (gui.getFont().width(s) - 6) / 3;
            guiGraphics.drawString(gui.getFont(), s, pos.x - stringWidth2, pos.y + 22, 0xFFFFFF, true);
        }
    }

    public static class Builder
    extends SkillBuilder<Builder> {
        protected ComboNode root;
        protected List<String> translationKeys = List.of();
        protected boolean shouldDrawGui;
        protected ResourceLocation skillTextureLocation;

        public Builder(Function<Builder, ? extends SimpleCustomInnateSkill> constructor) {
            super(constructor);
        }

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCombo(ComboNode root) {
            this.root = root;
            return this;
        }

        public Builder setShouldDrawGui(boolean shouldDrawGui) {
            this.shouldDrawGui = shouldDrawGui;
            return this;
        }

        public Builder addToolTipOnItem(List<String> translationKeys) {
            this.translationKeys = translationKeys;
            return this;
        }

        public Builder setSkillTextureLocation(ResourceLocation skillTextureLocation) {
            this.skillTextureLocation = skillTextureLocation;
            return this;
        }
    }
}

