/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.skill.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.p1nero.invincible.api.combo.ComboNode;
import com.p1nero.invincible.api.events.BaseEvent;
import com.p1nero.invincible.api.events.TimeStampedEvent;
import com.p1nero.invincible.skill.SimpleCustomInnateSkill;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Unique;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.data.reloader.MobPatchReloadListener;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.damagesource.StunType;

public class SkillJsonLoader {
    public static void loadSkill(CompoundTag data) throws CommandSyntaxException {
        SkillJsonLoader.loadSkill(JsonParser.parseString((String)data.toString()).getAsJsonObject());
    }

    public static SimpleCustomInnateSkill.Builder loadSkill(JsonObject skill) throws CommandSyntaxException {
        boolean drawSkillIcon = false;
        ResourceLocation resourceLocation = null;
        if (skill.has("drawSkillIcon")) {
            drawSkillIcon = skill.get("drawSkillIcon").getAsBoolean();
        }
        if (skill.has("skillTextureLocation")) {
            resourceLocation = ResourceLocation.parse((String)skill.get("skillTextureLocation").getAsString());
        }
        ComboNode root = ComboNode.create();
        SkillJsonLoader.deserializeSkill(root, skill);
        ArrayList<String> tipList = new ArrayList<String>();
        if (skill.has("descriptions")) {
            for (JsonElement element : skill.get("descriptions").getAsJsonArray()) {
                tipList.add(element.getAsString());
            }
        }
        return SimpleCustomInnateSkill.createCustomInnateSkill(SimpleCustomInnateSkill::new).setShouldDrawGui(drawSkillIcon).setCombo(root).addToolTipOnItem(tipList).setSkillTextureLocation(resourceLocation);
    }

    @Unique
    public static void deserializeSkill(ComboNode node, JsonObject combo) throws CommandSyntaxException {
        JsonArray commandList;
        String animation = combo.get("animation").getAsString();
        node.setAnimationAccessorSupplier(() -> AnimationManager.byKey((String)animation));
        if (combo.has("speed_multiplier")) {
            node.setPlaySpeed(combo.get("speed_multiplier").getAsFloat());
        }
        if (combo.has("damage_multiplier")) {
            JsonObject valueModifier = combo.getAsJsonObject("damage_multiplier");
            float adder = 0.0f;
            float multiplier = 1.0f;
            float setter = Float.NaN;
            if (valueModifier.has("adder")) {
                adder = valueModifier.get("adder").getAsFloat();
            }
            if (valueModifier.has("multiplier")) {
                multiplier = valueModifier.get("multiplier").getAsFloat();
            }
            if (valueModifier.has("setter")) {
                setter = valueModifier.get("setter").getAsFloat();
            }
            node.setDamageMultiplier((ValueModifier)new ValueModifier.Unified(adder, multiplier, setter));
        }
        if (combo.has("hurt_damage_multiplier")) {
            node.setHurtDamageMultiplier(combo.get("hurt_damage_multiplier").getAsFloat());
        }
        if (combo.has("armor_negation")) {
            node.setArmorNegation(combo.get("armor_negation").getAsFloat());
        }
        if (combo.has("impact_multiplier")) {
            node.setImpactMultiplier(combo.get("impact_multiplier").getAsFloat());
        }
        if (combo.has("can_be_interrupt")) {
            node.setCanBeInterrupt(combo.get("can_be_interrupt").getAsBoolean());
        }
        if (combo.has("stun_type")) {
            node.setStunTypeModifier(StunType.valueOf((String)combo.get("stun_type").getAsString()));
        }
        if (combo.has("convert_time")) {
            node.setConvertTime(combo.get("convert_time").getAsFloat());
        }
        if (combo.has("not_charge")) {
            node.setNotCharge(combo.get("not_charge").getAsBoolean());
        }
        if (combo.has("set_phase")) {
            node.setNewPhase(combo.get("set_phase").getAsInt());
        }
        if (combo.has("cooldown")) {
            node.setCooldown(combo.get("cooldown").getAsInt());
        }
        if (combo.has("conditions")) {
            JsonArray conditionList = combo.getAsJsonArray("conditions");
            for (JsonElement conditionElement : conditionList) {
                JsonObject condition = conditionElement.getAsJsonObject();
                CompoundTag tag = TagParser.parseTag((String)condition.toString());
                if (tag.getString("predicate").isEmpty()) continue;
                Condition predicate = MobPatchReloadListener.deserializeBehaviorPredicate((String)tag.getString("predicate"), (CompoundTag)tag);
                node.addCondition(predicate);
            }
        }
        if (combo.has("time_command_list")) {
            commandList = combo.getAsJsonArray("time_command_list");
            for (JsonElement commandElement : commandList) {
                JsonObject command = commandElement.getAsJsonObject();
                float time = command.get("time").getAsFloat();
                String commandText = command.get("command").getAsString();
                boolean executeAtTarget = command.get("execute_at_target").getAsBoolean();
                node.addTimeEvent(TimeStampedEvent.createTimeCommandEvent(time, commandText, executeAtTarget));
            }
        }
        if (combo.has("hit_command_list")) {
            commandList = combo.getAsJsonArray("hit_command_list");
            for (JsonElement commandElement : commandList) {
                JsonObject command = commandElement.getAsJsonObject();
                String commandText = command.get("command").getAsString();
                boolean executeAtTarget = command.get("execute_at_target").getAsBoolean();
                node.addHitEvent(BaseEvent.createBiCommandEvent(commandText, executeAtTarget));
            }
        }
        if (combo.has("hurt_command_list")) {
            commandList = combo.getAsJsonArray("hurt_command_list");
            for (JsonElement commandElement : commandList) {
                JsonObject command = commandElement.getAsJsonObject();
                String commandText = command.get("command").getAsString();
                boolean executeAtTarget = command.get("execute_at_target").getAsBoolean();
                node.addHurtEvent(BaseEvent.createBiCommandEvent(commandText, executeAtTarget));
            }
        }
        if (combo.has("dodge_success_command_list")) {
            commandList = combo.getAsJsonArray("dodge_success_command_list");
            for (JsonElement commandElement : commandList) {
                JsonObject command = commandElement.getAsJsonObject();
                String commandText = command.get("command").getAsString();
                boolean executeAtTarget = command.get("execute_at_target").getAsBoolean();
                node.addDodgeSuccessEvent(BaseEvent.createBiCommandEvent(commandText, executeAtTarget));
            }
        }
    }
}

