/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xvoidspawn;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jn.willfrydev.xvoidspawn.commands.VoidSpawnCommand;
import jn.willfrydev.xvoidspawn.listeners.JoinListener;
import jn.willfrydev.xvoidspawn.listeners.VoidFallListener;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class XVoidSpawn
extends JavaPlugin {
    private static XVoidSpawn instance;
    private Location spawnLocation;
    private VoidFallListener voidFallListener;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.loadSpawnLocation();
        this.voidFallListener = new VoidFallListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.voidFallListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new JoinListener(this), (Plugin)this);
        this.getCommand("xvoidspawn").setExecutor((CommandExecutor)new VoidSpawnCommand(this));
        String enabledMessage = this.getConfig().getString("console-messages.plugin-enabled", "&#55FF55[xVoidSpawn] Plugin enabled.");
        Bukkit.getConsoleSender().sendMessage(XVoidSpawn.colorize(enabledMessage));
    }

    public void onDisable() {
        String disabledMessage = this.getConfig().getString("console-messages.plugin-disabled", "&#FF5555[xVoidSpawn] Plugin disabled.");
        Bukkit.getConsoleSender().sendMessage(XVoidSpawn.colorize(disabledMessage));
    }

    public static XVoidSpawn getInstance() {
        return instance;
    }

    public Location getSpawnLocation() {
        return this.spawnLocation;
    }

    public boolean teleportToSpawn(Player player) {
        if (this.spawnLocation == null) {
            return false;
        }
        player.setFallDistance(0.0f);
        player.teleport(this.spawnLocation);
        return true;
    }

    public void reload() {
        this.reloadConfig();
        this.loadSpawnLocation();
    }

    private void loadSpawnLocation() {
        block5: {
            FileConfiguration config = this.getConfig();
            if (config.getBoolean("spawn-location.is-set")) {
                try {
                    World world;
                    String worldName = config.getString("spawn-location.world");
                    World world2 = world = worldName != null ? Bukkit.getWorld((String)worldName) : null;
                    if (world != null) {
                        this.spawnLocation = new Location(world, config.getDouble("spawn-location.x"), config.getDouble("spawn-location.y"), config.getDouble("spawn-location.z"), (float)config.getDouble("spawn-location.yaw"), (float)config.getDouble("spawn-location.pitch"));
                        break block5;
                    }
                    this.getLogger().warning("El mundo '" + worldName + "' no fue encontrado. El spawn del vac\u00edo est\u00e1 desactivado.");
                    this.spawnLocation = null;
                }
                catch (Exception e) {
                    this.getLogger().severe("Hubo un error al cargar la ubicaci\u00f3n del spawn desde config.yml.");
                    this.spawnLocation = null;
                }
            } else {
                this.spawnLocation = null;
            }
        }
    }

    public VoidFallListener getVoidFallListener() {
        return this.voidFallListener;
    }

    public static String colorize(String message) {
        if (message == null) {
            return "";
        }
        Pattern hexPattern = Pattern.compile("&#([A-Fa-f0-9]{6})");
        Matcher matcher = hexPattern.matcher(message);
        StringBuffer buffer = new StringBuffer(message.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            StringBuilder replacement = new StringBuilder("&x");
            for (char c : group.toCharArray()) {
                replacement.append('&').append(c);
            }
            matcher.appendReplacement(buffer, replacement.toString());
        }
        matcher.appendTail(buffer);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)buffer.toString());
    }
}

