/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xvoidspawn.commands;

import java.util.List;
import jn.willfrydev.xvoidspawn.XVoidSpawn;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class VoidSpawnCommand
implements CommandExecutor {
    private final XVoidSpawn plugin;

    public VoidSpawnCommand(XVoidSpawn plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String prefix = this.plugin.getConfig().getString("prefix", "&#FF5555&l[xVoidSpawn] &#AAAAAA\u00bb ");
        String noPermissionMsg = this.plugin.getConfig().getString("messages.no-permission", "&#FF5555Error! You do not have permission.");
        String playerOnlyMsg = this.plugin.getConfig().getString("messages.player-only", "&#FF5555Error! This command is for players only.");
        if (!(sender instanceof Player)) {
            sender.sendMessage(XVoidSpawn.colorize(playerOnlyMsg));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("xvoidspawn.admin")) {
            player.sendMessage(XVoidSpawn.colorize(prefix + noPermissionMsg));
            return true;
        }
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("setspawn")) {
                Location loc = player.getLocation();
                FileConfiguration config = this.plugin.getConfig();
                config.set("spawn-location.is-set", (Object)true);
                config.set("spawn-location.world", (Object)loc.getWorld().getName());
                config.set("spawn-location.x", (Object)loc.getX());
                config.set("spawn-location.y", (Object)loc.getY());
                config.set("spawn-location.z", (Object)loc.getZ());
                config.set("spawn-location.yaw", (Object)Float.valueOf(loc.getYaw()));
                config.set("spawn-location.pitch", (Object)Float.valueOf(loc.getPitch()));
                this.plugin.saveConfig();
                this.plugin.reload();
                String spawnSetMsg = this.plugin.getConfig().getString("messages.spawn-set", "&#55FF55Success! The void spawn has been set.");
                player.sendMessage(XVoidSpawn.colorize(prefix + spawnSetMsg));
                return true;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                this.plugin.reload();
                String reloadMsg = this.plugin.getConfig().getString("messages.reload", "&#55FF55Success! The config has been reloaded.");
                player.sendMessage(XVoidSpawn.colorize(prefix + reloadMsg));
                return true;
            }
        }
        List helpMessage = this.plugin.getConfig().getStringList("messages.help-message");
        for (String line : helpMessage) {
            player.sendMessage(XVoidSpawn.colorize(line));
        }
        return true;
    }
}

