/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xvoidspawn.listeners;

import jn.willfrydev.xvoidspawn.XVoidSpawn;
import jn.willfrydev.xvoidspawn.api.events.PostVoidTeleportEvent;
import jn.willfrydev.xvoidspawn.api.events.PreVoidTeleportEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class VoidFallListener
implements Listener {
    private final XVoidSpawn plugin;

    public VoidFallListener(XVoidSpawn plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (event.getTo() == null) {
            return;
        }
        int voidLevel = this.plugin.getConfig().getInt("void-level", 0);
        if (event.getTo().getY() <= (double)voidLevel) {
            Location spawnLocation = this.plugin.getSpawnLocation();
            if (spawnLocation != null) {
                if (!player.getWorld().equals(spawnLocation.getWorld())) {
                    return;
                }
                PreVoidTeleportEvent preEvent = new PreVoidTeleportEvent(player);
                Bukkit.getPluginManager().callEvent((Event)preEvent);
                if (preEvent.isCancelled()) {
                    return;
                }
                this.plugin.teleportToSpawn(player);
                String prefix = this.plugin.getConfig().getString("prefix", "");
                player.sendMessage(XVoidSpawn.colorize(prefix + this.plugin.getConfig().getString("messages.void-teleport")));
                PostVoidTeleportEvent postEvent = new PostVoidTeleportEvent(player, spawnLocation);
                Bukkit.getPluginManager().callEvent((Event)postEvent);
            } else if (!player.hasMetadata("xvoidspawn.warned")) {
                String prefix = this.plugin.getConfig().getString("prefix", "");
                player.sendMessage(XVoidSpawn.colorize(prefix + this.plugin.getConfig().getString("messages.spawn-not-set")));
                player.setMetadata("xvoidspawn.warned", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            }
        }
    }
}

