/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.client.hud;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerChangeGameTypeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.LBRText;
import net.swedz.little_big_redstone.block.microchip.MicrochipBlockEntity;
import net.swedz.little_big_redstone.item.FloppyDiskItem;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.network.packet.RequestMicrochipWatcherPacket;
import net.swedz.little_big_redstone.proxy.LBRProxy;
import net.swedz.tesseract.neoforge.helper.guigraphics.TesseractGuiGraphics;
import net.swedz.tesseract.neoforge.proxy.Proxies;
import org.apache.commons.lang3.mutable.MutableInt;

@EventBusSubscriber(modid="little_big_redstone", value={Dist.CLIENT})
public final class FloppyDiskConsumeItemsGuiOverlay {
    private static boolean SHOULD_FADE;
    private static FloppyDiskItem.ConsumeResult ITEMS;
    private static int DISPLAY_TIME;
    private static int TICK;
    private static int LAST_SELECTED_SLOT;
    private static BlockPos LAST_TARGET_BLOCK_POS;
    private static boolean SHOULD_FORCE_UPDATE;

    private static void displayItems(FloppyDiskItem.ConsumeResult items) {
        SHOULD_FADE = false;
        ITEMS = items;
        DISPLAY_TIME = 40;
    }

    private static void renderItem(TesseractGuiGraphics graphics, ItemStack stack, boolean isPresent, int x, float alpha) {
        graphics.setTexture(LBR.id("textures/gui/slot_atlas.png"));
        graphics.blit(x - 1, -1, 0, 0, 18, 18);
        graphics.renderItem(stack, x, 0);
        graphics.renderItemDecorations(stack, x, 0);
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 200.0f);
        graphics.blit(x - 1, -1, 18, isPresent ? 0 : 18, 18, 18);
        graphics.pose().popPose();
    }

    private static void renderItems(TesseractGuiGraphics graphics, int maxItems, MutableInt index, MutableInt x, List<ItemStack> items, boolean isPresent, float alpha) {
        for (int itemIndex = 0; itemIndex < items.size() && index.getValue() < maxItems; ++itemIndex) {
            if (index.getValue() == maxItems - 1 && index.getValue() != ITEMS.size() - 1) {
                graphics.setTexture(LBR.id("textures/gui/slot_atlas.png"));
                graphics.blit(x.getValue() - 1, -1, 0, 36, 18, 18);
                MutableComponent text = LBRText.FLOPPY_DISK_MORE_ITEMS.text(new Object[]{ITEMS.size() - index.getValue()});
                graphics.setStringDropShadow(false);
                graphics.drawString((Component)text, x.getValue() + 19 - 2 - graphics.getFont().width((FormattedText)text), 9);
                graphics.setStringDropShadow(true);
            } else {
                ItemStack stack = items.get(itemIndex);
                FloppyDiskConsumeItemsGuiOverlay.renderItem(graphics, stack, isPresent, x.getValue(), alpha);
            }
            index.increment();
            x.add(18);
        }
    }

    private static void renderItems(TesseractGuiGraphics graphics, float alpha) {
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, -24.0f, 0.0f);
        graphics.setColor(1.0f, 1.0f, 1.0f, alpha);
        int maxItems = 9;
        int x = -(Math.min(ITEMS.size(), maxItems) * 18) / 2;
        graphics.setTexture(LBR.id("textures/gui/slot_background.png"));
        graphics.nineSlice(x - 2, -2, Math.min(ITEMS.size(), maxItems) * 18 + 2, 20, 32, 32, 4);
        MutableInt index = new MutableInt();
        MutableInt itemX = new MutableInt(x);
        FloppyDiskConsumeItemsGuiOverlay.renderItems(graphics, maxItems, index, itemX, ITEMS.missing(), false, alpha);
        FloppyDiskConsumeItemsGuiOverlay.renderItems(graphics, maxItems, index, itemX, ITEMS.present(), true, alpha);
        graphics.resetColor();
        graphics.pose().popPose();
    }

    public static void render(GuiGraphics vanilla, DeltaTracker delta) {
        int alpha;
        if (ITEMS != null && ITEMS.size() > 0 && DISPLAY_TIME > 0 && (alpha = Math.min((int)(((float)DISPLAY_TIME - delta.getGameTimeDeltaPartialTick(false)) * 12.75f), 255)) > 8) {
            Gui gui = Minecraft.getInstance().gui;
            TesseractGuiGraphics graphics = new TesseractGuiGraphics(vanilla);
            graphics.pose().pushPose();
            int yShift = Math.max(gui.leftHeight, gui.rightHeight) + 9;
            graphics.pose().translate((float)(vanilla.guiWidth() / 2), (float)(vanilla.guiHeight() - Math.max(yShift, 68)), 0.0f);
            graphics.pose().translate(0.0f, -4.0f, 0.0f);
            FloppyDiskConsumeItemsGuiOverlay.renderItems(graphics, (float)alpha / 255.0f);
            graphics.pose().popPose();
        }
    }

    public static void update(boolean force) {
        if (force || ITEMS != null) {
            SHOULD_FORCE_UPDATE = true;
        }
    }

    private static boolean update(Level level, Player player, BlockPos targetBlock, Microchip.Immutable watchedMicrochip) {
        Microchip.Immutable microchip;
        ItemStack stack;
        if (FloppyDiskConsumeItemsGuiOverlay.isMicrochip(level, targetBlock) && watchedMicrochip != null && !(stack = FloppyDiskItem.getHeldStack(player)).isEmpty() && (microchip = (Microchip.Immutable)stack.get(LBRComponents.FLOPPY_DISK)) != null) {
            FloppyDiskItem.ConsumeResult items = FloppyDiskItem.consumeItems(player, microchip, watchedMicrochip, true);
            FloppyDiskConsumeItemsGuiOverlay.displayItems(items);
            return true;
        }
        return false;
    }

    private static boolean isMicrochip(Level level, BlockPos pos) {
        return pos != null && level.getBlockEntity(pos) instanceof MicrochipBlockEntity;
    }

    @SubscribeEvent
    private static void tick(ClientTickEvent.Post event) {
        BlockPos blockPos;
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        LBRProxy proxy = (LBRProxy)Proxies.get(LBRProxy.class);
        LocalPlayer player = Minecraft.getInstance().player;
        int selectedSlot = player.getInventory().selected;
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult hitResult2 = (BlockHitResult)hitResult;
            blockPos = hitResult2.getBlockPos();
        } else {
            blockPos = null;
        }
        BlockPos targetBlock = blockPos;
        Microchip.Immutable watchedMicrochip = proxy.getWatchedMicrochip();
        if (selectedSlot != LAST_SELECTED_SLOT || !Objects.equals(targetBlock, LAST_TARGET_BLOCK_POS)) {
            proxy.updateWatchedMicrochip(null);
            if (FloppyDiskConsumeItemsGuiOverlay.isMicrochip((Level)level, targetBlock)) {
                ItemStack floppyDisk = FloppyDiskItem.getHeldStack((Player)player);
                if (!floppyDisk.isEmpty()) {
                    new RequestMicrochipWatcherPacket(targetBlock, true).sendToServer();
                } else if (watchedMicrochip != null) {
                    new RequestMicrochipWatcherPacket(targetBlock, false).sendToServer();
                }
            } else if (watchedMicrochip != null) {
                new RequestMicrochipWatcherPacket(targetBlock, false).sendToServer();
            }
        } else if (SHOULD_FORCE_UPDATE || watchedMicrochip == null) {
            SHOULD_FORCE_UPDATE = false;
            if (!FloppyDiskConsumeItemsGuiOverlay.update((Level)level, (Player)player, targetBlock, watchedMicrochip)) {
                SHOULD_FADE = true;
            }
        }
        if (SHOULD_FADE) {
            if (DISPLAY_TIME > 0) {
                --DISPLAY_TIME;
            } else {
                ITEMS = null;
                SHOULD_FADE = false;
            }
        }
        LAST_SELECTED_SLOT = selectedSlot;
        LAST_TARGET_BLOCK_POS = targetBlock;
    }

    @SubscribeEvent
    private static void onGameModeChange(ClientPlayerChangeGameTypeEvent event) {
        if (ITEMS != null) {
            SHOULD_FORCE_UPDATE = true;
        }
    }
}

