/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.microchip.logic.renderer;

import net.minecraft.resources.ResourceLocation;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRClientShaders;
import net.swedz.little_big_redstone.gui.microchip.logic.LogicRenderer;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicGridSize;
import net.swedz.tesseract.neoforge.helper.guigraphics.TesseractGuiGraphics;

public final class OnOffLogicRenderer<L extends LogicComponent<?, ?>>
extends LogicRenderer<L> {
    @Override
    public void render(LogicRenderer.Context context, TesseractGuiGraphics graphics, L component, int x, int y) {
        LogicGridSize size = ((LogicComponent)component).size();
        this.renderAllPorts(context, graphics, x, y, component, 1.0f, 1.0f, 1.0f);
        this.renderBackground(context, graphics, x, y, (LogicComponent)component);
        graphics.setColor(context.foregroundColor());
        graphics.setTextureShader(LBRClientShaders::logicScanline, shader -> shader.getUniform("LogicUV").set(16.0f, 16.0f));
        graphics.setTextures(new ResourceLocation[]{context.getTexture(((LogicComponent)component).output(0) ? "on" : "off"), LBR.id("textures/logic/scanline.png")});
        int centerX = x + size.centerX() - 8;
        int centerY = y + size.centerY() - 8;
        graphics.blit(centerX, centerY, 0.0f, 0.0f, 16, 16, 16, 16);
        graphics.resetTextureShader();
        graphics.resetColor();
    }
}

