/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.stickynote.edit;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.network.chat.Style;
import net.minecraft.util.StringUtil;
import net.swedz.tesseract.neoforge.api.Bounds;
import org.apache.commons.lang3.mutable.MutableInt;

public final class StickyNoteEdit {
    private final Font font;
    private final int width;
    private final int height;
    private final TextFieldHelper editor;
    private String text;
    private boolean textModified = false;
    private Display display;

    public StickyNoteEdit(Font font, int width, int height, String text) {
        this.font = font;
        this.text = text;
        this.width = width;
        this.height = height;
        this.editor = new TextFieldHelper(this::text, this::setText, () -> TextFieldHelper.getClipboardContents((Minecraft)Minecraft.getInstance()), copy -> TextFieldHelper.setClipboardContents((Minecraft)Minecraft.getInstance(), (String)copy), input -> font.wordWrapHeight(input, width) <= height);
    }

    public TextFieldHelper editor() {
        return this.editor;
    }

    public String text() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.textModified = true;
        this.markDirty();
    }

    public boolean isTextModified() {
        return this.textModified;
    }

    public Display getDisplay() {
        if (this.display == null) {
            this.display = new Display();
        }
        return this.display;
    }

    private void markDirty() {
        this.display = null;
    }

    public void selectAll() {
        this.editor.selectAll();
        this.markDirty();
    }

    public void copy() {
        this.editor.copy();
    }

    public void paste() {
        this.editor.paste();
    }

    public void cut() {
        this.editor.cut();
    }

    public void insertNewLine() {
        this.editor.insertText("\n");
    }

    private TextFieldHelper.CursorStep getStep(boolean ctrl) {
        return ctrl ? TextFieldHelper.CursorStep.WORD : TextFieldHelper.CursorStep.CHARACTER;
    }

    public void backspace(boolean ctrl) {
        this.editor.removeFromCursor(-1, this.getStep(ctrl));
    }

    public void delete(boolean ctrl) {
        this.editor.removeFromCursor(1, this.getStep(ctrl));
    }

    public void moveLeft(boolean shift, boolean ctrl) {
        this.editor.moveBy(-1, shift, this.getStep(ctrl));
        this.markDirty();
    }

    public void moveRight(boolean shift, boolean ctrl) {
        this.editor.moveBy(1, shift, this.getStep(ctrl));
        this.markDirty();
    }

    private void moveVertically(int direction, boolean shift) {
        Display display = this.getDisplay();
        int targetLineX = display.cursorX();
        int targetLineY = display.cursorY() + direction;
        if (targetLineY >= 0 && targetLineY < display.lines().length) {
            DisplayLine line = display.lines()[targetLineY];
            targetLineX = line.findIndex(this.font, display.cursorScreenX());
        }
        int newCursorPos = display.toGlobalCursorPos(targetLineX, targetLineY);
        this.editor.setCursorPos(newCursorPos, shift);
        this.markDirty();
    }

    public void moveUp(boolean shift) {
        this.moveVertically(-1, shift);
    }

    public void moveDown(boolean shift) {
        this.moveVertically(1, shift);
    }

    public boolean type(char character) {
        if (StringUtil.isAllowedChatCharacter((char)character)) {
            this.editor.insertText(Character.toString(character));
            return true;
        }
        return false;
    }

    private int cursorPosAt(int mouseX, int mouseY) {
        Display display = this.getDisplay();
        int targetLineX = display.cursorX();
        int targetLineY = mouseY / display.lineHeight();
        if (targetLineY >= 0 && targetLineY < display.lines().length) {
            DisplayLine line = display.lines()[targetLineY];
            targetLineX = line.findIndex(this.font, mouseX);
        }
        return display.toGlobalCursorPos(targetLineX, targetLineY);
    }

    public void jumpTo(int mouseX, int mouseY, boolean shift) {
        this.editor.setCursorPos(this.cursorPosAt(mouseX, mouseY), shift);
        this.markDirty();
    }

    public final class Display {
        private final String fullText;
        private final DisplayLine[] lines;
        private final int lineHeight;
        private final int cursorX;
        private final int cursorY;
        private final int cursorScreenX;
        private final int cursorScreenY;
        private final boolean cursorAtEndOfLine;
        private final Bounds[] highlightedAreas;

        private Display() {
            this.fullText = StickyNoteEdit.this.text;
            Objects.requireNonNull(StickyNoteEdit.this.font);
            this.lineHeight = 9;
            int cursorIndex = StickyNoteEdit.this.editor.getCursorPos();
            int selectionIndex = StickyNoteEdit.this.editor.getSelectionPos();
            int highlightStartIndex = Math.min(cursorIndex, selectionIndex);
            int highlightEndIndex = Math.max(cursorIndex, selectionIndex);
            boolean hasHighlight = StickyNoteEdit.this.editor.isSelecting();
            MutableInt lineIndex = new MutableInt();
            ArrayList lines = Lists.newArrayList();
            StickyNoteEdit.this.font.getSplitter().splitLines(this.fullText, StickyNoteEdit.this.width, Style.EMPTY, false, (__, start, end) -> {
                int index = lineIndex.getAndIncrement();
                String lineText = this.fullText.substring(start, end);
                lines.add(new DisplayLine(index, lineText, index * this.lineHeight, StickyNoteEdit.this.font.width(lineText), start, end));
            });
            if (this.fullText.endsWith("\n")) {
                int index = lineIndex.getAndIncrement();
                int length = this.fullText.length();
                lines.add(new DisplayLine(index, "", index * this.lineHeight, 0, length, length));
            }
            int cursorX = 0;
            int cursorY = 0;
            int cursorScreenX = 0;
            int cursorScreenY = 0;
            boolean cursorAtEndOfLine = false;
            ArrayList highlightedAreas = Lists.newArrayList();
            for (int index = 0; index < lines.size(); ++index) {
                int highlightEndX;
                DisplayLine line = (DisplayLine)lines.get(index);
                int start2 = line.startIndex();
                int end2 = line.endIndex();
                if (cursorIndex >= start2 && cursorIndex <= end2) {
                    cursorX = cursorIndex - start2;
                    cursorY = index;
                    cursorScreenX = StickyNoteEdit.this.font.width(line.text().substring(0, cursorX));
                    cursorScreenY = line.y();
                    boolean bl = cursorAtEndOfLine = cursorIndex == end2;
                }
                if (!hasHighlight || highlightStartIndex > end2 || highlightEndIndex < start2) continue;
                int highlightStartX = 0;
                if (highlightStartIndex >= start2 && highlightStartIndex <= end2) {
                    highlightStartX = StickyNoteEdit.this.font.width(line.text().substring(0, highlightStartIndex - start2));
                }
                if (highlightEndIndex < start2) continue;
                int n = highlightEndX = highlightEndIndex <= end2 ? StickyNoteEdit.this.font.width(line.text().substring(0, highlightEndIndex - start2)) : line.width();
                if (highlightStartX == highlightEndX) continue;
                highlightedAreas.add(new Bounds(highlightStartX, line.y(), highlightEndX - highlightStartX, this.lineHeight));
            }
            this.lines = (DisplayLine[])lines.toArray(DisplayLine[]::new);
            this.cursorX = cursorX;
            this.cursorY = cursorY;
            this.cursorScreenX = cursorScreenX;
            this.cursorScreenY = cursorScreenY;
            this.cursorAtEndOfLine = cursorAtEndOfLine;
            this.highlightedAreas = (Bounds[])highlightedAreas.toArray(Bounds[]::new);
        }

        public String fullText() {
            return this.fullText;
        }

        public DisplayLine[] lines() {
            return this.lines;
        }

        public int lineHeight() {
            return this.lineHeight;
        }

        public int cursorX() {
            return this.cursorX;
        }

        public int cursorY() {
            return this.cursorY;
        }

        public int cursorScreenX() {
            return this.cursorScreenX;
        }

        public int cursorScreenY() {
            return this.cursorScreenY;
        }

        public boolean isCursorAtEndOfLine() {
            return this.cursorAtEndOfLine;
        }

        public Bounds[] highlightedAreas() {
            return this.highlightedAreas;
        }

        public int toGlobalCursorPos(int cursorX, int cursorY) {
            if (cursorY < 0) {
                return 0;
            }
            if (cursorY < this.lines.length) {
                DisplayLine line = this.lines[cursorY];
                return line.startIndex() + cursorX;
            }
            return this.fullText.length();
        }
    }

    public record DisplayLine(int index, String text, int y, int width, int startIndex, int endIndex) {
        public int length() {
            return this.text.length();
        }

        public int findIndex(Font font, int desiredWidth) {
            if (desiredWidth == 0) {
                return 0;
            }
            if (this.width <= desiredWidth) {
                return this.text.length();
            }
            int lastWidth = 0;
            int traversedWidth = 0;
            for (int i = 0; i < this.text.length(); ++i) {
                if (desiredWidth == (traversedWidth += font.width(String.valueOf(this.text.charAt(i))))) {
                    return i + 1;
                }
                if (desiredWidth < traversedWidth && desiredWidth > lastWidth) {
                    int distToLastWidth;
                    int distToWidth = Math.abs(traversedWidth - desiredWidth);
                    if (distToWidth <= (distToLastWidth = Math.abs(lastWidth - desiredWidth))) {
                        return i + 1;
                    }
                    return i;
                }
                lastWidth = traversedWidth;
            }
            return 0;
        }
    }
}

