/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.stickynote.edit;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.swedz.little_big_redstone.LBRColors;
import net.swedz.little_big_redstone.gui.microchip.MicrochipMenu;
import net.swedz.little_big_redstone.gui.microchip.MicrochipScreen;
import net.swedz.little_big_redstone.gui.stickynote.StickyNoteScreen;
import net.swedz.little_big_redstone.gui.stickynote.edit.StickyNoteEditWidget;
import net.swedz.little_big_redstone.gui.stickynote.reference.MicrochipStickyNoteReference;
import net.swedz.little_big_redstone.gui.stickynote.reference.StickyNoteReference;
import net.swedz.little_big_redstone.gui.stickynote.view.StickyNoteViewScreen;

public final class StickyNoteEditScreen
extends StickyNoteScreen {
    private final boolean shouldReturnToView;
    private StickyNoteEditWidget editWidget;
    private Button doneButton;

    public StickyNoteEditScreen(StickyNoteReference reference, boolean shouldReturnToView) {
        super(reference);
        this.shouldReturnToView = shouldReturnToView;
    }

    @Override
    protected void init() {
        super.init();
        this.editWidget = (StickyNoteEditWidget)this.addRenderableWidget(this.createNoteEditWidget(this.leftPos + this.contentLeftPos, this.topPos + this.contentTopPos, this.maxContentWidth, this.maxContentHeight, () -> LBRColors.stickyNoteText(this.textColor)));
        this.doneButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, b -> this.done()).bounds(this.leftPos, this.topPos + this.uiHeight - 20, this.uiWidth, 20).build());
    }

    private StickyNoteEditWidget createNoteEditWidget(int x, int y, int width, int height, Supplier<Integer> color) {
        return this.editWidget != null ? new StickyNoteEditWidget(this.font, x, y, width, height, this.editWidget, color) : new StickyNoteEditWidget(this.font, x, y, width, height, this.initialText, color);
    }

    private void close() {
        AbstractContainerMenu abstractContainerMenu;
        Object screen = null;
        if (this.shouldReturnToView) {
            screen = new StickyNoteViewScreen(this.reference.withText(this.editWidget.note().text()));
        } else if (this.reference instanceof MicrochipStickyNoteReference && (abstractContainerMenu = this.minecraft.player.containerMenu) instanceof MicrochipMenu) {
            MicrochipMenu menu = (MicrochipMenu)abstractContainerMenu;
            screen = new MicrochipScreen(menu, this.minecraft.player.getInventory(), (Component)Component.empty());
        }
        this.minecraft.setScreen(screen);
    }

    private void done() {
        this.close();
        if (this.editWidget.note().isTextModified()) {
            this.reference.withText(this.editWidget.note().text()).saveClient((Level)this.minecraft.level, (Player)this.minecraft.player);
        }
    }

    public void tick() {
        this.editWidget.tick();
        if (!this.reference.isStillValid((Level)Minecraft.getInstance().level, (Player)Minecraft.getInstance().player)) {
            this.minecraft.setScreen(null);
        }
    }
}

