/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.io;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.swedz.little_big_redstone.LBRText;
import net.swedz.little_big_redstone.LBRTextLine;
import net.swedz.little_big_redstone.microchip.awareness.AwarenessType;
import net.swedz.little_big_redstone.microchip.awareness.AwarenessTypes;
import net.swedz.little_big_redstone.microchip.awareness.MicrochipAware;
import net.swedz.little_big_redstone.microchip.awareness.types.RedstoneAwareness;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicContext;
import net.swedz.little_big_redstone.microchip.object.logic.LogicType;
import net.swedz.little_big_redstone.microchip.object.logic.LogicTypes;
import net.swedz.little_big_redstone.microchip.object.logic.io.LogicIOConfig;

public final class LogicIO
extends LogicComponent<LogicIO, LogicIOConfig>
implements MicrochipAware {
    public static final MapCodec<LogicIO> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LogicIOConfig.CODEC.fieldOf("config").forGetter(LogicComponent::config), (App)DyeColor.CODEC.optionalFieldOf("color").forGetter(LogicComponent::color), (App)Codec.BOOL.optionalFieldOf("output", (Object)false).forGetter(LogicIO::output)).apply((Applicative)instance, LogicIO::new));
    public static final StreamCodec<ByteBuf, LogicIO> STREAM_CODEC = StreamCodec.composite(LogicIOConfig.STREAM_CODEC, LogicComponent::config, (StreamCodec)ByteBufCodecs.optional((StreamCodec)DyeColor.STREAM_CODEC), LogicComponent::color, (StreamCodec)ByteBufCodecs.BOOL, LogicIO::output, LogicIO::new);
    private boolean outputState;

    private LogicIO(LogicIOConfig config, Optional<DyeColor> color, boolean outputState) {
        super(config, color);
        this.outputState = outputState;
    }

    private LogicIO(Optional<DyeColor> color, boolean outputState) {
        super(color);
        this.outputState = outputState;
    }

    public LogicIO() {
        this(Optional.empty(), false);
    }

    @Override
    public AwarenessType<?>[] awarenessTypes() {
        return new AwarenessType[]{AwarenessTypes.REDSTONE};
    }

    @Override
    protected LogicIOConfig defaultConfig() {
        return new LogicIOConfig();
    }

    @Override
    protected void processTickInternal(LogicContext context, boolean[] inputs) {
        boolean powerChanged = false;
        boolean originalOutputState = this.outputState;
        if (((LogicIOConfig)this.config).input) {
            int signal = context.awareness(AwarenessTypes.REDSTONE).getInputPower(((LogicIOConfig)this.config).direction);
            this.outputState = ((LogicIOConfig)this.config).signalComparison.test(signal, ((LogicIOConfig)this.config).signalStrength);
        } else {
            int signal;
            this.outputState = inputs[0];
            RedstoneAwareness redstone = context.awareness(AwarenessTypes.REDSTONE);
            int n = signal = this.outputState ? ((LogicIOConfig)this.config).signalStrength : 0;
            if (redstone.setOutputPowered(((LogicIOConfig)this.config).direction, signal)) {
                powerChanged = true;
            }
        }
        if (powerChanged || this.outputState != originalOutputState) {
            context.markDirty(this);
        }
    }

    @Override
    public LogicType<LogicIO> type() {
        return LogicTypes.IO;
    }

    @Override
    protected boolean outputInternal(int index) {
        return this.outputState;
    }

    public boolean output() {
        return this.output(0);
    }

    @Override
    public void appendShiftHoverText(List<Component> lines) {
        lines.add((Component)LBRTextLine.line(LBRText.LOGIC_HELP_IO_PORT_1));
        lines.add((Component)LBRTextLine.line(LBRText.LOGIC_HELP_IO_PORT_2));
    }

    @Override
    protected void internalLoadFrom(LogicIO other) {
        this.outputState = other.outputState;
    }

    @Override
    public void internalResetForPickup() {
        this.outputState = false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type(), this.config, this.color);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof LogicIO)) return false;
        LogicIO other = (LogicIO)o;
        if (!Objects.equals(this.config, other.config)) return false;
        if (!Objects.equals(this.color, other.color)) return false;
        return true;
    }
}

