/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.recipe;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.swedz.little_big_redstone.LBRBlocks;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.LBRItems;
import net.swedz.little_big_redstone.LBRRecipeTypes;
import net.swedz.little_big_redstone.LBRTags;
import net.swedz.little_big_redstone.item.DyeColoredItem;
import net.swedz.little_big_redstone.item.LogicItem;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;

public final class DataRetainingDyeRecipe
extends CustomRecipe {
    private static final Map<TagKey<Item>, ColorableItemTagHandler> TAG_RESULTS = Map.of(LBRTags.Items.MICROCHIPS, new ColorableItemTagHandler(color -> LBRBlocks.microchip(color).get()), LBRTags.Items.LOGIC_COMPONENTS, new ColorableItemTagHandler(stack -> stack.getItem() instanceof LogicItem ? ((LogicComponent)stack.get(LBRComponents.LOGIC)).color() : Optional.empty(), (original, color) -> {
        ItemStack output = original.copy();
        Object logic = ((LogicComponent)original.get(LBRComponents.LOGIC)).copy();
        ((LogicComponent)logic).setColor(color);
        output.set(LBRComponents.LOGIC, logic);
        return output;
    }), LBRTags.Items.LOGIC_ARRAYS, new ColorableItemTagHandler(LBRItems::logicArray), LBRTags.Items.FLOPPY_DISKS, new ColorableItemTagHandler(LBRItems::floppyDisk), LBRTags.Items.STICKY_NOTES, new ColorableItemTagHandler(LBRItems::stickyNote));

    public DataRetainingDyeRecipe(CraftingBookCategory category) {
        super(category);
    }

    public static Set<TagKey<Item>> getAcceptableTags() {
        return TAG_RESULTS.keySet();
    }

    public static boolean isDyeable(ItemStack stack) {
        for (TagKey<Item> tag : TAG_RESULTS.keySet()) {
            if (!stack.is(tag)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack outputVariant(ItemStack stack, Optional<DyeColor> color) {
        ItemStack output = ItemStack.EMPTY;
        for (Map.Entry<TagKey<Item>, ColorableItemTagHandler> entry : TAG_RESULTS.entrySet()) {
            ColorableItemTagHandler handler;
            Optional<DyeColor> currentColor;
            if (!stack.is(entry.getKey()) || (currentColor = (handler = entry.getValue()).colorGetter().get(stack)).equals(color)) continue;
            output = handler.coloredItemFactory().create(stack, color);
            break;
        }
        return output;
    }

    private static Optional<Match> find(CraftingInput input) {
        ItemStack outputVariant;
        ItemStack dyeableItem = ItemStack.EMPTY;
        Optional<DyeColor> color = Optional.empty();
        boolean hasDye = false;
        for (int index = 0; index < input.size(); ++index) {
            ItemStack stack = input.getItem(index);
            if (stack.isEmpty()) continue;
            if (DataRetainingDyeRecipe.isDyeable(stack)) {
                if (!dyeableItem.isEmpty()) {
                    return Optional.empty();
                }
                dyeableItem = stack;
                continue;
            }
            if (hasDye) {
                return Optional.empty();
            }
            Item item = stack.getItem();
            if (item instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)item;
                color = Optional.of(dyeItem.getDyeColor());
                hasDye = true;
                continue;
            }
            if (stack.is(LBRTags.Items.DYE_WASHER)) {
                hasDye = true;
                continue;
            }
            return Optional.empty();
        }
        if (!dyeableItem.isEmpty() && hasDye && !(outputVariant = DataRetainingDyeRecipe.outputVariant(dyeableItem, color)).isEmpty()) {
            return Optional.of(new Match(dyeableItem, color, outputVariant));
        }
        return Optional.empty();
    }

    public boolean matches(CraftingInput input, Level level) {
        return DataRetainingDyeRecipe.find(input).isPresent();
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
        return DataRetainingDyeRecipe.find(input).map(Match::outputVariant).orElse(ItemStack.EMPTY);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return LBRRecipeTypes.DATA_RETAINING_DYE_RECIPE_SERIALIZER.get();
    }

    private record ColorableItemTagHandler(ItemColorGetter colorGetter, ColoredItemFactory coloredItemFactory) {
        public ColorableItemTagHandler(ColoredItemFactory coloredItemFactory) {
            this(ItemColorGetter.DEFAULT, coloredItemFactory);
        }

        public ColorableItemTagHandler(ColoredItemFactory.Simple coloredItemFactory) {
            this(ItemColorGetter.DEFAULT, coloredItemFactory);
        }
    }

    private static interface ItemColorGetter {
        public static final ItemColorGetter DEFAULT = stack -> {
            DyeColoredItem dyeColoredItem;
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof DyeColoredItem) {
                DyeColoredItem item;
                dyeColoredItem = item = (DyeColoredItem)patt0$temp;
            } else {
                BlockItem blockItem;
                Item patt2$temp;
                Item patt1$temp = stack.getItem();
                if (patt1$temp instanceof BlockItem && (patt2$temp = (blockItem = (BlockItem)patt1$temp).getBlock().asItem()) instanceof DyeColoredItem) {
                    DyeColoredItem item;
                    dyeColoredItem = item = (DyeColoredItem)patt2$temp;
                } else {
                    return Optional.empty();
                }
            }
            return Optional.of(dyeColoredItem.color());
        };

        public Optional<DyeColor> get(ItemStack var1);
    }

    private static interface ColoredItemFactory {
        public ItemStack create(ItemStack var1, Optional<DyeColor> var2);

        public static interface Simple
        extends ColoredItemFactory {
            public ItemLike create(DyeColor var1);

            @Override
            default public ItemStack create(ItemStack original, Optional<DyeColor> color) {
                return color.map(c -> original.transmuteCopy(this.create((DyeColor)c))).orElse(ItemStack.EMPTY);
            }
        }
    }

    private record Match(ItemStack dyeableItem, Optional<DyeColor> color, ItemStack outputVariant) {
    }
}

