/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.logicconfig.button.slider;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;
import net.swedz.little_big_redstone.gui.logicconfig.button.LogicConfigButtonHelper;
import net.swedz.tesseract.neoforge.helper.guigraphics.TesseractGuiGraphics;

public class SliderLogicConfigButton
extends ExtendedSlider
implements LogicConfigButtonHelper {
    private final int color;
    private final boolean isInteger;
    private final ValueStringifier valueStringifier;
    private final OnValueChange onChange;
    private String typed = "";

    public SliderLogicConfigButton(int x, int y, int width, int height, int color, Component prefix, Component suffix, double minValue, double maxValue, double initialValue, double stepSize, int precision, boolean drawString, ValueStringifier valueStringifier, OnValueChange onChange) {
        super(x, y, width, height, prefix, suffix, minValue, maxValue, initialValue, stepSize, precision, drawString);
        this.color = color;
        this.isInteger = Mth.equal((double)stepSize, (double)Math.floor(stepSize));
        this.valueStringifier = valueStringifier;
        this.onChange = onChange;
        this.updateMessage();
    }

    public SliderLogicConfigButton(int x, int y, int width, int height, int color, Component prefix, Component suffix, double minValue, double maxValue, double initialValue, boolean drawString, ValueStringifier valueStringifier, OnValueChange onChange) {
        super(x, y, width, height, prefix, suffix, minValue, maxValue, initialValue, drawString);
        this.color = color;
        this.isInteger = Mth.equal((double)this.stepSize, (double)Math.floor(this.stepSize));
        this.valueStringifier = valueStringifier;
        this.onChange = onChange;
        this.updateMessage();
    }

    protected void updateMessage() {
        if (this.valueStringifier != null) {
            if (this.drawString) {
                this.setMessage((Component)Component.literal((String)"").append(this.prefix).append(this.valueStringifier.stringify(this.getValue(), this.getValueString())).append(this.suffix));
            } else {
                this.setMessage((Component)Component.empty());
            }
            this.onChange.onValueChange(this, this.minValue + this.value * (this.maxValue - this.minValue));
        }
    }

    public void onClick(double mouseX, double mouseY) {
        super.onClick(mouseX, mouseY);
        this.typed = this.getValueString();
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        super.onDrag(mouseX, mouseY, dragX, dragY);
        this.typed = this.getValueString();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean left;
        if (this.stepSize <= 0.0) {
            return false;
        }
        boolean bl = left = keyCode == 263;
        if (left || keyCode == 262) {
            float step;
            if (this.minValue > this.maxValue) {
                left = !left;
            }
            float f = step = left ? -1.0f : 1.0f;
            if (Screen.hasShiftDown()) {
                step *= 10.0f;
            }
            this.setValue(this.getValue() + (double)step * this.stepSize);
            this.typed = this.getValueString();
            return false;
        }
        if (this.isInteger) {
            if (keyCode >= 48 && keyCode <= 57) {
                int number = keyCode - 48;
                this.typed = this.typed + number;
                this.setValue(Integer.parseInt(this.typed));
                this.typed = this.getValueString();
                return false;
            }
            if (keyCode == 259 && !this.typed.isEmpty()) {
                this.typed = this.typed.substring(0, this.typed.length() - 1);
                this.setValue(this.typed.isEmpty() ? 0.0 : (double)Integer.parseInt(this.typed));
                return false;
            }
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        float step;
        boolean left;
        if (this.stepSize <= 0.0) {
            return false;
        }
        boolean bl = left = scrollY < 0.0;
        if (this.minValue > this.maxValue) {
            left = !left;
        }
        float f = step = left ? -1.0f : 1.0f;
        if (Screen.hasShiftDown()) {
            step *= 10.0f;
        }
        this.setValue(this.getValue() + (double)step * this.stepSize);
        this.typed = "";
        return true;
    }

    public void renderWidget(GuiGraphics internal, int mouseX, int mouseY, float partialTick) {
        TesseractGuiGraphics graphics = new TesseractGuiGraphics(internal);
        graphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        this.renderBackground(graphics, partialTick, this.getX() + (int)(this.value * ((double)this.width - 8.0)), this.getY(), 8, this.height, this.color, this.active && this.isHoveredOrFocused());
        this.renderBorder(graphics, this.getX(), this.getY(), this.width, this.height, this.color);
        this.renderBorder(graphics, this.getX() + (int)(this.value * ((double)this.width - 8.0)), this.getY(), 8, this.height, this.color);
        graphics.setColor(this.color);
        graphics.setStringDropShadow(false);
        graphics.drawCenteredString(this.getMessage(), (float)this.getX() + (float)this.width / 2.0f, (float)this.getY() + (float)this.height / 2.0f);
        graphics.resetColor();
    }

    public static interface ValueStringifier {
        public Component stringify(double var1, String var3);
    }

    public static interface OnValueChange {
        public void onValueChange(SliderLogicConfigButton var1, double var2);
    }
}

