/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.microchip.logicarray;

import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.gui.microchip.logicarray.LogicCreativeItemHandler;
import net.swedz.little_big_redstone.item.logicarray.LogicArrayItemHandler;

public final class MicrochipLogicArrayItemHandler
implements IItemHandlerModifiable {
    private static final LogicCreativeItemHandler CREATIVE = new LogicCreativeItemHandler();
    private final AbstractContainerMenu menu;
    private final Player player;
    private int logicArraySlot = -1;
    private Optional<IItemHandlerModifiable> logicArray = Optional.empty();

    public MicrochipLogicArrayItemHandler(AbstractContainerMenu menu, Player player) {
        this.menu = menu;
        this.player = player;
    }

    public int getSelectedSlot() {
        return this.logicArraySlot;
    }

    public boolean hasSelectedSlot() {
        return this.logicArraySlot != -1;
    }

    public boolean isCreativeMode() {
        return !this.hasSelectedSlot() && this.player.hasInfiniteMaterials();
    }

    public boolean shouldDisplay() {
        return this.handler().isPresent();
    }

    private Optional<IItemHandlerModifiable> handler() {
        return this.logicArray.isEmpty() && this.player.hasInfiniteMaterials() ? Optional.of(CREATIVE) : this.logicArray;
    }

    private boolean setPickedLogicArray(int slotId, ItemStack stack) {
        Object object;
        if (stack.has(LBRComponents.LOGIC_ARRAY_STORAGE) && (object = stack.getCapability(Capabilities.ItemHandler.ITEM)) instanceof LogicArrayItemHandler) {
            LogicArrayItemHandler logicArrayItemHandler = (LogicArrayItemHandler)((Object)object);
            this.logicArraySlot = slotId;
            this.logicArray = Optional.of(logicArrayItemHandler);
            return true;
        }
        return false;
    }

    public void deselectPickedLogicArray() {
        this.logicArraySlot = -1;
        this.logicArray = Optional.empty();
    }

    public void setPickedLogicArray(int slotId) {
        if (slotId < 0 || slotId >= this.menu.slots.size()) {
            return;
        }
        ItemStack stack = ((Slot)this.menu.slots.get(slotId)).getItem();
        this.setPickedLogicArray(slotId, stack);
    }

    public void pickLogicArrayFromInventory() {
        if (this.isCreativeMode()) {
            return;
        }
        for (int i = this.menu.slots.size() - 1; i >= 0; --i) {
            ItemStack stack = ((Slot)this.menu.slots.get(i)).getItem();
            if (!this.setPickedLogicArray(i, stack)) continue;
            return;
        }
        this.deselectPickedLogicArray();
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.handler().ifPresent(h -> h.setStackInSlot(slot, stack));
    }

    public int getSlots() {
        return this.handler().map(IItemHandler::getSlots).orElse(0);
    }

    public ItemStack getStackInSlot(int slot) {
        return this.handler().map(h -> h.getStackInSlot(slot)).orElse(ItemStack.EMPTY);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.handler().map(h -> h.insertItem(slot, stack, simulate)).orElse(stack);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.handler().map(h -> h.extractItem(slot, amount, simulate)).orElse(ItemStack.EMPTY);
    }

    public int getSlotLimit(int slot) {
        return this.handler().map(h -> h.getSlotLimit(slot)).orElse(0);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.handler().map(h -> h.isItemValid(slot, stack)).orElse(false);
    }
}

