/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.stickynote.reference;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.swedz.little_big_redstone.entity.stickynote.StickyNoteEntity;
import net.swedz.little_big_redstone.gui.stickynote.reference.StickyNoteReference;
import net.swedz.little_big_redstone.item.stickynote.StickyNote;
import net.swedz.little_big_redstone.network.packet.StickyNotePacket;

public final class EntityStickyNoteReference
implements StickyNoteReference {
    private final int entityId;
    private final DyeColor color;
    private final DyeColor textColor;
    private final String text;

    public EntityStickyNoteReference(StickyNoteEntity entity) {
        this(entity.getId(), entity.getColor(), entity.getTextColor(), entity.getNote().text());
    }

    private EntityStickyNoteReference(int entityId, DyeColor color, DyeColor textColor, String text) {
        this.entityId = entityId;
        this.color = color;
        this.textColor = textColor;
        this.text = text;
    }

    @Override
    public DyeColor color() {
        return this.color;
    }

    @Override
    public DyeColor textColor() {
        return this.textColor;
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    public StickyNoteReference withText(String text) {
        return new EntityStickyNoteReference(this.entityId, this.color, this.textColor, text);
    }

    @Override
    public void saveClient(Level level, Player player) {
        new StickyNotePacket(StickyNotePacket.ReferenceType.ENTITY, this.entityId, StickyNotePacket.Action.DONE_EDIT, this.text).sendToServer();
    }

    @Override
    public void saveServer(Level level, Player player) {
        StickyNoteEntity entity;
        Entity entity2 = level.getEntity(this.entityId);
        if (entity2 instanceof StickyNoteEntity && (entity = (StickyNoteEntity)entity2).distanceTo((Entity)player) <= 16.0f) {
            entity.setNote(new StickyNote(this.text));
        }
    }

    @Override
    public boolean isStillValid(Level level, Player player) {
        Entity entity = level.getEntity(this.entityId);
        return entity != null && entity.distanceTo((Entity)player) <= 16.0f;
    }
}

