/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.sequencer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRTooltips;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfig;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfigButtonReference;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfigMenuBuilder;
import net.swedz.little_big_redstone.microchip.object.logic.sequencer.LogicSequencerMode;
import net.swedz.tesseract.neoforge.api.range.IntRange;
import net.swedz.tesseract.neoforge.helper.CodecHelper;

public final class LogicSequencerConfig
extends LogicConfig<LogicSequencerConfig> {
    public static final MapCodec<LogicSequencerConfig> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecHelper.forLowercaseEnum(LogicSequencerMode.class).optionalFieldOf("mode", (Object)LogicSequencerMode.WEAK).forGetter(config -> config.mode), (App)Codec.LONG.optionalFieldOf("delay", (Object)20L).forGetter(config -> config.outputDelay), (App)Codec.BOOL.optionalFieldOf("auto_reset", (Object)false).forGetter(config -> config.autoReset), (App)Codec.BOOL.optionalFieldOf("reset_port", (Object)false).forGetter(config -> config.resetPort)).apply((Applicative)instance, LogicSequencerConfig::new));
    public static final StreamCodec<ByteBuf, LogicSequencerConfig> STREAM_CODEC = StreamCodec.composite((StreamCodec)CodecHelper.forLowercaseEnumStream(LogicSequencerMode.class), config -> config.mode, (StreamCodec)ByteBufCodecs.VAR_LONG, config -> config.outputDelay, (StreamCodec)ByteBufCodecs.BOOL, config -> config.autoReset, (StreamCodec)ByteBufCodecs.BOOL, config -> config.resetPort, LogicSequencerConfig::new);
    public LogicSequencerMode mode;
    public long outputDelay;
    public boolean autoReset;
    public boolean resetPort;

    private LogicSequencerConfig(LogicSequencerMode mode, long outputDelay, boolean autoReset, boolean resetPort) {
        this.mode = mode;
        this.outputDelay = outputDelay;
        this.autoReset = autoReset;
        this.resetPort = resetPort;
    }

    public LogicSequencerConfig() {
        this(LogicSequencerMode.WEAK, 20L, false, false);
    }

    @Override
    public IntRange inputsAllowed() {
        return new IntRange(1, 2);
    }

    @Override
    public int inputs() {
        return this.resetPort ? 2 : 1;
    }

    @Override
    public IntRange outputsAllowed() {
        return new IntRange(1, 1);
    }

    @Override
    public int outputs() {
        return 1;
    }

    @Override
    public void appendHoverText(List<Component> lines) {
        lines.add((Component)LBR.text().logicConfigTooltipMode(this.mode));
        lines.add((Component)LBR.text().logicConfigTooltipSequencerDelay(this.outputDelay));
        lines.add((Component)LBR.text().logicConfigTooltipSequencerAutoReset(this.autoReset));
        lines.add((Component)LBR.text().logicConfigTooltipSequencerResetPort(this.resetPort));
    }

    @Override
    public boolean hasMenu() {
        return true;
    }

    @Override
    public void buildMenu(LogicConfigMenuBuilder builder, int width, int height) {
        AtomicReference<LogicConfigButtonReference> modeButton = new AtomicReference<LogicConfigButtonReference>();
        modeButton.set(builder.addCycleButton((Component)LBR.text().logicConfigButtonLabelMode(), (Component)this.mode.tooltip(), 0, 0, width, 18, false, this.mode, Arrays.asList(LogicSequencerMode.values()), LogicSequencerMode::label, value -> {
            this.mode = value;
            if (modeButton.get() != null) {
                ((LogicConfigButtonReference)modeButton.get()).setTooltip((Component)this.mode.tooltip());
            }
        }));
        builder.addSlider((Component)LBR.text().logicConfigButtonLabelSequencerDelay(), (Component)Component.empty(), (Component)LBR.text().logicConfigButtonTooltipSequencerDelay(), 0, 22, width, 18, 1.0, 1200.0, this.outputDelay, 1.0, 0, (arg_0, arg_1) -> LBRTooltips.TICKS_AND_SECONDS_SLIDER_PARSER.parse(arg_0, arg_1), value -> {
            this.outputDelay = value.intValue();
        });
        builder.addCheckbox((Component)LBR.text().logicConfigButtonLabelSequencerAutoReset(), (Component)LBR.text().logicConfigButtonTooltipSequencerAutoReset(), 0, 44, this.autoReset, value -> {
            this.autoReset = value;
        });
        builder.addCheckbox((Component)LBR.text().logicConfigButtonLabelSequencerResetPort(), (Component)LBR.text().logicConfigButtonTooltipSequencerResetPort(), 0, 66, this.resetPort, value -> {
            this.resetPort = value;
        });
    }

    @Override
    protected void internalLoadFrom(LogicSequencerConfig other) {
        this.mode = other.mode;
        this.outputDelay = other.outputDelay;
        this.autoReset = other.autoReset;
        this.resetPort = other.resetPort;
    }

    @Override
    public void resetForPickup() {
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mode, this.outputDelay, this.autoReset, this.resetPort);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof LogicSequencerConfig)) return false;
        LogicSequencerConfig other = (LogicSequencerConfig)o;
        if (this.mode != other.mode) return false;
        if (this.outputDelay != other.outputDelay) return false;
        if (this.autoReset != other.autoReset) return false;
        if (this.resetPort != other.resetPort) return false;
        return true;
    }
}

