/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone;

import net.minecraft.core.Direction;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.swedz.little_big_redstone.LBRBlocks;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.LBRCreativeTabs;
import net.swedz.little_big_redstone.LBREntities;
import net.swedz.little_big_redstone.LBRItems;
import net.swedz.little_big_redstone.LBRMenus;
import net.swedz.little_big_redstone.LBRRecipeTypes;
import net.swedz.little_big_redstone.LBRText;
import net.swedz.little_big_redstone.LBRTooltips;
import net.swedz.little_big_redstone.datagen.client.provider.LanguageDatagenProvider;
import net.swedz.little_big_redstone.guide.LBRGuide;
import net.swedz.little_big_redstone.microchip.awareness.AwarenessTypes;
import net.swedz.little_big_redstone.microchip.object.logic.LogicMode;
import net.swedz.little_big_redstone.microchip.object.logic.LogicTypes;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicComparisonMode;
import net.swedz.little_big_redstone.network.LBRPackets;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.capabilities.CapabilitiesListeners;
import net.swedz.tesseract.neoforge.lang.LangInstance;
import net.swedz.tesseract.neoforge.lang.LangManager;
import net.swedz.tesseract.neoforge.registry.RegisteredObjectHolder;
import net.swedz.tesseract.neoforge.tooltip.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="little_big_redstone")
public final class LBR {
    public static final String ID = "little_big_redstone";
    public static final String NAME = "Little Big Redstone";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Little Big Redstone");
    private static LBRText TEXT;

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }

    public LBR(IEventBus bus, ModContainer container) {
        LBR.setupText();
        LogicTypes.init();
        AwarenessTypes.init();
        LBRComponents.init(bus);
        LBRItems.init(bus);
        LBRBlocks.init(bus);
        LBREntities.init(bus);
        LBRCreativeTabs.init(bus);
        LBRMenus.init(bus);
        LBRRecipeTypes.init(bus);
        LBRGuide.init();
        bus.addListener(RegisterPayloadHandlersEvent.class, LBRPackets::init);
        bus.addListener(FMLCommonSetupEvent.class, event -> {
            LBRItems.values().forEach(RegisteredObjectHolder::triggerRegistrationListener);
            LBRBlocks.values().forEach(RegisteredObjectHolder::triggerRegistrationListener);
        });
        bus.addListener(RegisterCapabilitiesEvent.class, event -> CapabilitiesListeners.triggerAll((String)ID, (RegisterCapabilitiesEvent)event));
    }

    public static LBRText text() {
        Assert.notNull((Object)TEXT, (String)"Text not yet loaded");
        return TEXT;
    }

    private static void setupText() {
        LangInstance instance = new LangManager(ID).builtinColorStyles().style("tooltip", () -> Style.EMPTY.withColor(TextColor.fromRgb((int)0xA9A9A9)).withItalic(Boolean.valueOf(false))).style("highlighted", () -> Style.EMPTY.withColor(TextColor.fromRgb((int)16768637)).withItalic(Boolean.valueOf(false))).style("yes", () -> Style.EMPTY.withColor(TextColor.fromRgb((int)0x7FFF7D)).withItalic(Boolean.valueOf(false))).style("no", () -> Style.EMPTY.withColor(TextColor.fromRgb((int)0xFF7D7F)).withItalic(Boolean.valueOf(false))).style("direction.down", () -> Style.EMPTY.withColor(TextColor.fromRgb((int)16766976)).withItalic(Boolean.valueOf(false))).style("direction.up", () -> Style.EMPTY.withColor(TextColor.fromRgb((int)0xFFFFFF)).withItalic(Boolean.valueOf(false))).style("direction.north", () -> Style.EMPTY.withColor(TextColor.fromRgb((int)5046016)).withItalic(Boolean.valueOf(false))).style("direction.south", () -> Style.EMPTY.withColor(TextColor.fromRgb((int)38143)).withItalic(Boolean.valueOf(false))).style("direction.west", () -> Style.EMPTY.withColor(TextColor.fromRgb((int)16738816)).withItalic(Boolean.valueOf(false))).style("direction.east", () -> Style.EMPTY.withColor(TextColor.fromRgb((int)0xFF0000)).withItalic(Boolean.valueOf(false))).style("input", () -> Style.EMPTY.withColor(TextColor.fromRgb((int)8232703)).withItalic(Boolean.valueOf(false))).style("output", () -> Style.EMPTY.withColor(TextColor.fromRgb((int)16751997)).withItalic(Boolean.valueOf(false))).builtinParsers().parser("percentage", Float.TYPE, () -> value -> Parser.FLOAT_PERCENTAGE.parse(value, (Object)0)).parser("ticks_and_seconds", Long.TYPE, () -> ticks -> ticks != 1L ? TEXT.logicConfigButtonLabelTicksAndSeconds((long)ticks, (float)ticks.longValue() / 20.0f) : TEXT.logicConfigButtonLabelTicksAndSecondsSingular((long)ticks, (float)ticks.longValue() / 20.0f)).parser("yes_no", Boolean.TYPE, () -> LBRTooltips.BOOLEAN_YES_NO_PARSER).parser(Direction.class, () -> LBRTooltips.DIRECTION_PARSER).parser(LogicMode.class, () -> LogicMode::label).parser(LogicComparisonMode.class, () -> LogicComparisonMode::symbol).build(LBRText.class).load();
        LanguageDatagenProvider.include(instance);
        TEXT = (LBRText)instance.lang();
    }
}

